/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.websocket;

import io.reactivex.disposables.Disposable;
import java.io.IOException;
import java.util.Collection;
import net.aequologica.neo.dagr.DagBerk;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Dags;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.websocket.DagSocketMessage;
import net.aequologica.neo.dagr.websocket.DagSocketMessageEncoderDecoder;
import org.atmosphere.config.service.Disconnect;
import org.atmosphere.config.service.ManagedService;
import org.atmosphere.config.service.Message;
import org.atmosphere.config.service.PathParam;
import org.atmosphere.config.service.Ready;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.Broadcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedService(path="/patata/{dagName}/patati/{scope}")
public final class DagSocket {
    private static final Logger LOG = LoggerFactory.getLogger(DagSocket.class);
    @PathParam(value="dagName")
    private String dagName;
    @PathParam(value="scope")
    private String scopeAsAString;
    private Scope scope;
    private DagOnSteroids dagOnSteroids;
    private Disposable subscription;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ready
    public final void onReady(AtmosphereResource r) {
        if (this.dagName == null) {
            throw new RuntimeException("@PathParam(\"dagName\") is " + this.dagName);
        }
        if (this.scopeAsAString == null) {
            throw new RuntimeException("@PathParam(\"scope\") is " + this.scopeAsAString);
        }
        String[] both = DagOnSteroids.parseName((String)this.dagName);
        Dags dags = DagBerk.PROFOND_DESESPOIR.getDags();
        this.dagOnSteroids = dags.getDagOnSteroids(both[0]);
        if (this.dagOnSteroids == null) {
            throw new RuntimeException("dag /" + this.dagName + "/ not found");
        }
        this.scope = Scope.valueOf((String)this.scopeAsAString);
        Object object = this.lock;
        synchronized (object) {
            if (this.subscription == null) {
                Bus bus = dags.getBus(this.dagName, this.scope);
                if (bus == null) {
                    LOG.warn("[websocket {}] no bus for dag {} {}", new Object[]{this.scopeAsAString, this.dagName, this.dagOnSteroids});
                } else {
                    this.subscription = bus.toObservable().map(nodeevent -> (Dag.Node)nodeevent.get()).subscribe(node -> {
                        Dag.Node node2 = this.broadcast(r.getBroadcaster(), (Dag.Node)node);
                    });
                    LOG.debug("[websocket {}] [broadcaster:#{}] subscribed - browser {} connected to dag {}", new Object[]{this.scopeAsAString, r.getBroadcaster().getID(), r.uuid(), this.dagOnSteroids});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disconnect
    public final void onDisconnect(AtmosphereResourceEvent event) {
        Collection atmosphereResources = event.getResource().getBroadcaster().getAtmosphereResources();
        if (atmosphereResources.size() < 2 && this.subscription != null) {
            Disposable disposable = this.subscription;
            synchronized (disposable) {
                this.subscription.dispose();
                this.subscription = null;
            }
            LOG.debug("[websocket {}] [broadcaster:#{}] unsubscribed !", (Object)this.scopeAsAString, (Object)event.getResource().getBroadcaster().getID());
        }
        if (event.isCancelled()) {
            LOG.info("[websocket {}] Client {} cancelled the connection", (Object)this.scopeAsAString, (Object)event.getResource().uuid());
        } else if (event.isClosedByClient()) {
            LOG.info("[websocket {}] Client {} closed the connection", (Object)this.scopeAsAString, (Object)event.getResource().uuid());
        }
    }

    @Message(encoders={DagSocketMessageEncoderDecoder.class}, decoders={DagSocketMessageEncoderDecoder.class})
    public final DagSocketMessage onMessage(DagSocketMessage message) throws IOException {
        DagOnSteroids.NodeCleaner nodeCleaner = message.getNodeCleaner();
        if (nodeCleaner == null) {
            LOG.info("[websocket {}] in dag /{}/, kein node", (Object)this.scopeAsAString, (Object)this.dagName);
        } else {
            LOG.info("[websocket {}] in dag /{}/, node /{}/ has state /{}/ ", new Object[]{this.scopeAsAString, this.dagName, message.getNodeCleaner().getNode().getName(), message.getNodeCleaner().getState()});
            this.dagOnSteroids.getDagCleaner(this.scope).getNodeCleaner(message.getNodeCleaner().getNode()).setState(message.getNodeCleaner().getState());
        }
        return message;
    }

    private Dag.Node broadcast(Broadcaster broadcaster, Dag.Node node) {
        try {
            LOG.info("[websocket {}] received node '{}' from the bus", (Object)this.scopeAsAString, (Object)node.getName());
            DagSocketMessage dagSocketMessage = node instanceof Dag.VirtualNodeZero ? new DagSocketMessage(true, this.scope) : (node instanceof Dag.VirtualNodeInfinity ? new DagSocketMessage(false, this.scope) : new DagSocketMessage(null, this.scope, this.dagOnSteroids.getDagCleaner(this.scope).getNodeCleaner(node)));
            DagSocketMessageEncoderDecoder codec = new DagSocketMessageEncoderDecoder();
            String encoded = codec.encode(dagSocketMessage);
            LOG.debug("[websocket {}] [broadcaster:#{}] about to broadcast: |{}|", new Object[]{this.scopeAsAString, broadcaster.hashCode(), encoded});
            broadcaster.broadcast((Object)encoded);
            return node;
        }
        catch (Exception e) {
            LOG.error("[websocket {}] exception /{}/ logged and re-thrown", (Object)this.scopeAsAString, (Object)e.getMessage());
            throw e;
        }
    }
}

