/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.servlet.mobile;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import io.reactivex.disposables.Disposable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.config.DagrConfig;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.geppaequo.crypto.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Listener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(Listener.class);
    private ObjectMapper mapper;
    private String googleCloudMessagingAPIKey;
    private Disposable subscription;
    @Inject
    Codec codec;

    public void contextInitialized(ServletContextEvent arg0) {
        this.mapper = new ObjectMapper();
        try {
            this.googleCloudMessagingAPIKey = this.codec.decrypt(((DagrConfig)ConfigRegistry.CONFIG_REGISTRY.getConfig(DagrConfig.class)).getEncryptedGoogleCloudMessagingAPIKey().toCharArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String dagName = null;
        String scope = null;
        Bus<Dag.Node, Scope> theBus = this.getBusFromGoogleCloudMessaging(dagName, scope);
        if (theBus != null) {
            this.subscription = theBus.toObservable().filter(event -> event.getType().equals((Object)BusEvent.Type.CLEAN_OK) || event.getType().equals((Object)BusEvent.Type.CLEAN_ERROR) || event.getType().equals((Object)BusEvent.Type.CLEAN_ABORTED)).map(event -> (Dag.Node)event.get()).subscribe(node -> this.sendNotification((Dag.Node)node));
        }
        log.debug("[gcm] subbscribed !");
    }

    private Bus<Dag.Node, Scope> getBusFromGoogleCloudMessaging(String dagName, String scope) {
        throw new UnsupportedOperationException();
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        if (this.subscription != null) {
            this.subscription.dispose();
            log.debug("[gcm] unsubscribed !");
        }
    }

    void sendNotification(Dag.Node node) {
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(node.getName());
        sb.append(" @ ");
        sb.append("travis");
        String message = sb.toString();
        log.debug("[gcm] sending notification {} for node {} to google cloud messaging", (Object)message, (Object)node.getName());
        try {
            GCMMessage msg = new GCMMessage(new GCMMessage.Data(message));
            String gcmMessageAsString = this.mapper.writeValueAsString((Object)msg);
            URL url = new URL("https://android.googleapis.com/gcm/send");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", "key=" + this.googleCloudMessagingAPIKey);
            conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(gcmMessageAsString.getBytes(StandardCharsets.UTF_8));
            InputStream inputStream = conn.getInputStream();
            String responseText = CharStreams.toString((Readable)new InputStreamReader(inputStream));
            log.debug("[gcm] Check your device/emulator for notification or logcat for confirmation of the receipt of the GCM message. GCM Response text is {}", (Object)responseText);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class GCMMessage {
        @JsonProperty
        private final String to = "/topics/global";
        @JsonProperty
        private Data data;

        public GCMMessage() {
        }

        public GCMMessage(Data data) {
            this.data = data;
        }

        private static class Data {
            @JsonProperty
            private String message;

            public Data() {
            }

            public Data(String message) {
                this.message = message;
            }
        }
    }
}

