/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs.travis;

import java.util.Collection;
import java.util.List;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.jaxrs.AbstractResource;
import net.aequologica.neo.dagr.model.Dag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notifiers/travis")
public class ResourceTravis
extends AbstractResource {
    static final Logger log = LoggerFactory.getLogger(ResourceTravis.class);

    @POST
    @Path(value="notification")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response receiveNotification(@FormParam(value="payload") String payload) throws Exception {
        try {
            log.debug("[travis] payload: {}", (Object)payload);
            System.out.println("[travis] payload: " + payload.replace("\n", "").replace("\r", ""));
            JsonObject travisPayload = (JsonObject)this.mapper.readValue(payload, JsonObject.class);
            if (travisPayload == null) {
                Response.serverError().entity((Object)("failed to parse payload from [" + payload + "]")).build();
            }
            String name = null;
            String owner_name = null;
            JsonObject repository = travisPayload.getJsonObject("repository");
            if (repository != null) {
                name = repository.getString("name");
                owner_name = repository.getString("owner_name");
            }
            String branch = travisPayload.getString("branch");
            int status = travisPayload.getInt("status");
            if (name != null && branch != null) {
                BusEvent.Type type = status == 0 ? BusEvent.Type.CLEAN_OK : BusEvent.Type.CLEAN_ERROR;
                log.error("[travis] sending event {}, name='{}', branch='{}' to bus={}", new Object[]{type, name, branch, owner_name});
                System.out.println("[travis] sending event " + type + ", name='" + name + "', branch='" + branch + "' to the bus");
                Bus<Dag.Node, Scope> bus = this.getBusFromTravis(owner_name, null);
                Dag dag = this.getDagFromTravis(owner_name, null);
                if (bus != null && dag != null) {
                    List nodes = DagOnSteroids.getNodesFromNameAndBranchContains((Dag)dag, (String)name, (String)branch);
                    bus.send(BusEvent.Type.SMUDGE, (Collection)nodes, "notification from github");
                }
            }
            return Response.noContent().build();
        }
        catch (Exception e) {
            log.error("[travis] exception {} /{}/ logged and re-thrown {}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            throw e;
        }
    }

    public Bus<Dag.Node, Scope> getBusFromTravis(String owner_name, Object object) {
        throw new UnsupportedOperationException();
    }

    public Dag getDagFromTravis(String owner_name, Object object) {
        throw new UnsupportedOperationException();
    }
}

