/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs.travis;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pivovarit.function.ThrowingBiFunction;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Map;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.geppaequo.config.geppaequo.GeppaequoConfig;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.eclipse.jgit.transport.URIish;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCleanerTravis {
    private static final Logger log = LoggerFactory.getLogger(NodeCleanerTravis.class);
    final URI uri;
    final ThrowingBiFunction<Map.Entry<Scope, Boolean>, Dag.Node, DagOnSteroids.NodeCleaner.NodeCleaningResult, DagOnSteroids.NodeCleaner.NodeCleanerException> cleaningFunction;

    public NodeCleanerTravis(String url, String token) {
        this.uri = URI.create(url);
        this.cleaningFunction = (scope, node) -> {
            URI nodeURI = this.uri;
            Header[] headers = new Header[]{new BasicHeader("Accept", "application/json; charset=utf-8"), new BasicHeader("Authorization", "token " + token), new BasicHeader("Content-Type", "application/json; charset=utf-8"), new BasicHeader("Travis-API-Version", "3")};
            String body = Body.string(Body.Request.request(node.getValue().getBranch() == null || node.getValue().getBranch().isEmpty() ? "master" : node.getValue().getBranch()));
            GeppaequoConfig config = (GeppaequoConfig)ConfigRegistry.CONFIG_REGISTRY.getConfig(GeppaequoConfig.class);
            String proxyIfNeeded = config.getProxyIfNeeded(this.uri.getHost());
            try {
                nodeURI = NodeCleanerTravis.calcNodeURI(this.uri, node);
                Request request = Request.Post((URI)nodeURI).setHeaders(headers).connectTimeout(5000).socketTimeout(5000).bodyString(body, ContentType.APPLICATION_JSON);
                if (proxyIfNeeded != null) {
                    request = request.viaProxy(proxyIfNeeded);
                }
                Response response = request.execute();
                StatusLine statusLine = response.returnResponse().getStatusLine();
                log.debug("NodeCleanerTravis \nrequest {} \nheaders {} \nbody {} \nproxy {} \nstatus {}", new Object[]{request, headers, body, proxyIfNeeded, statusLine});
                return DagOnSteroids.NodeCleaner.NodeCleaningResult.from((Scope)((Scope)scope.getKey()), (int)statusLine.getStatusCode(), (String)statusLine.getReasonPhrase(), (URI)nodeURI);
            }
            catch (Throwable t) {
                log.debug("NodeCleanerTravis exception wrapped and rethrown as NodeCleanerException. {} | {} | \"{}\" | {}", new Object[]{nodeURI, headers, body, t.getMessage()});
                throw new DagOnSteroids.NodeCleaner.NodeCleanerException(nodeURI + " | " + headers + " | " + body, t);
            }
        };
    }

    public ThrowingBiFunction<Map.Entry<Scope, Boolean>, Dag.Node, DagOnSteroids.NodeCleaner.NodeCleaningResult, DagOnSteroids.NodeCleaner.NodeCleanerException> getCleaningFunction() {
        return this.cleaningFunction;
    }

    static URI calcNodeURI(URI baseURI, Dag.Node node) throws URISyntaxException, UnsupportedEncodingException {
        if (baseURI == null || node == null || node.getValue() == null || node.getValue().getScm() == null || node.getValue().getScm().isEmpty()) {
            throw new RuntimeException("no base uri, no node, or no node.value.scm");
        }
        String path = NodeCleanerTravis.getPathFromGitProtocol(node.getValue().getScm());
        URI uri = URI.create(baseURI + "/repo/" + URLEncoder.encode(path, "UTF8") + "/requests");
        return uri;
    }

    static String getPathFromGitProtocol(String scm) throws URISyntaxException {
        URIish uri = new URIish(scm);
        String path = uri.getPath();
        path = NodeCleanerTravis.removeLeadingSlashIfAny(path);
        path = NodeCleanerTravis.removeTrailingDotGitIfAny(path);
        return path;
    }

    private static String removeTrailingDotGitIfAny(String path) {
        if (path.endsWith(".git")) {
            return path.substring(0, path.length() - 4);
        }
        return path;
    }

    private static String removeLeadingSlashIfAny(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    @JsonIgnoreProperties
    static class Body {
        static final ObjectMapper mapper = new ObjectMapper();
        @JsonProperty
        final Request request;

        static {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }

        Body(Request request) {
            this.request = request;
        }

        public String toString() {
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                log.error(e.getMessage());
                return null;
            }
        }

        static Body body(Request request) {
            return new Body(request);
        }

        static String string(Request request) {
            return Body.body(request).toString();
        }

        static HttpEntity entity(Request request) {
            return new StringEntity(Body.string(request), ContentType.APPLICATION_JSON);
        }

        @JsonIgnoreProperties
        static class Request {
            @JsonProperty
            final String branch;

            Request(String branch) {
                this.branch = branch;
            }

            static Request request(String branch) {
                return new Request(branch);
            }
        }
    }
}

