/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs.jenkins;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.ConcurrentMapTemplateCache;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import com.google.common.base.Charsets;
import com.pivovarit.function.ThrowingBiFunction;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.ws.rs.core.UriBuilder;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.geppaequo.config.geppaequo.GeppaequoConfig;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCleanerJenkins {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCleanerJenkins.class);
    private final URI uri;
    private final Executor executor;
    private final ThrowingBiFunction<Map.Entry<Scope, Boolean>, Dag.Node, DagOnSteroids.NodeCleaner.NodeCleaningResult, DagOnSteroids.NodeCleaner.NodeCleanerException> cleaningFunction;
    private final GeppaequoConfig geppaequoConfig;
    private final HB hb = new HB();

    public NodeCleanerJenkins(String dagName, String url, String token, Set<Map.Entry<String, String>> params, String authorizationHeader, Map<Scope, String> nameTemplateMap, Dag.Bumper bumper, URI callback) {
        String dagBranch;
        String dagPrefix;
        if (dagName != null && !dagName.trim().isEmpty()) {
            int lastDot = dagName.lastIndexOf(46);
            if (lastDot != -1) {
                dagPrefix = dagName.substring(0, lastDot);
                dagBranch = dagName.substring(lastDot + 1);
            } else {
                dagPrefix = dagName;
                dagBranch = null;
            }
        } else {
            dagPrefix = dagName;
            dagBranch = null;
        }
        this.geppaequoConfig = (GeppaequoConfig)ConfigRegistry.CONFIG_REGISTRY.getConfig(GeppaequoConfig.class);
        try {
            CloseableHttpClient httpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build()).build();
            this.executor = Executor.newInstance((HttpClient)httpClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.uri = URI.create(url);
        this.cleaningFunction = (tuple, node) -> {
            URI finalURL = null;
            Scope scope = (Scope)tuple.getKey();
            Boolean skipRelease = (Boolean)tuple.getValue();
            try {
                String proxyIfNeeded;
                String jobName;
                if (node == null) {
                    jobName = "~" + dagPrefix + "~";
                } else {
                    String nameTemplate;
                    jobName = node.getName();
                    if (nameTemplateMap != null && nameTemplateMap.size() > 0 && (nameTemplate = (String)nameTemplateMap.get(scope)) != null && !nameTemplate.isEmpty()) {
                        jobName = this.hb.applyTemplateAsString(node.getDag(), node, scope, nameTemplate);
                    }
                }
                UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.uri).path("job").path(jobName);
                if (token != null && !token.trim().isEmpty()) {
                    uriBuilder.queryParam("token", new Object[]{token});
                }
                if (params != null) {
                    uriBuilder.path("buildWithParameters");
                    for (Map.Entry entry : params) {
                        if (entry.getKey() == null || ((String)entry.getKey()).trim().isEmpty() || entry.getValue() == null || ((String)entry.getValue()).trim().isEmpty()) continue;
                        uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
                    }
                    if (scope.equals((Object)Scope.RELEASE) && node != null && node.getValue() != null && node.getValue().getGucrid() != null) {
                        if (skipRelease.booleanValue()) {
                            uriBuilder.queryParam("releaseVersion", new Object[]{""});
                            uriBuilder.queryParam("developmentVersion", new Object[]{""});
                        } else {
                            Dag.Gucrid gucrid = Dag.Gucrid.create((String)node.getValue().getGucrid());
                            String releaseVersion = gucrid.getReleaseVersion().toString();
                            String developmentVersion = gucrid.getNextDevelopmentVersion(bumper.fromNodeName(node.getName())).toString();
                            if (releaseVersion != null && !releaseVersion.trim().isEmpty()) {
                                uriBuilder.queryParam("releaseVersion", new Object[]{releaseVersion});
                            }
                            if (developmentVersion != null && !developmentVersion.trim().isEmpty()) {
                                uriBuilder.queryParam("developmentVersion", new Object[]{developmentVersion});
                            }
                        }
                    }
                    if (callback != null && node != null) {
                        uriBuilder.queryParam("statusCallbackURL", new Object[]{UriBuilder.fromUri((URI)callback).path("/api/dagr/v1/dags/" + NodeCleanerJenkins.doubleEncode(node.getDag().getName()) + "/buses/" + scope + "/nodes/" + NodeCleanerJenkins.doubleEncode(node.getName()) + "/events/")});
                    }
                    if (dagName != null && !dagName.trim().isEmpty()) {
                        uriBuilder.queryParam("dagURL", new Object[]{UriBuilder.fromUri((URI)callback).path("/api/dagr/v1/dags/" + NodeCleanerJenkins.doubleEncode(dagName))});
                    }
                    if (node != null) {
                        if (node.getValue() != null && node.getValue().getBranch() != null && !node.getValue().getBranch().trim().isEmpty()) {
                            uriBuilder.queryParam("branch", new Object[]{node.getValue().getBranch().trim()});
                        }
                    } else if (dagBranch != null && !dagBranch.trim().isEmpty()) {
                        uriBuilder.queryParam("branch", new Object[]{dagBranch.trim()});
                    }
                } else {
                    uriBuilder.path("build");
                }
                finalURL = uriBuilder.build(new Object[0]);
                Request request = Request.Post((URI)finalURL).bodyForm((Iterable)Form.form().build());
                request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                if (this.geppaequoConfig != null && (proxyIfNeeded = this.geppaequoConfig.getProxyIfNeeded(this.uri.getHost())) != null) {
                    request = request.viaProxy(proxyIfNeeded);
                }
                if (authorizationHeader != null && !authorizationHeader.trim().isEmpty()) {
                    request.addHeader("Authorization", authorizationHeader);
                }
                Response response = this.executor.execute(request);
                StatusLine statusLine = response.returnResponse().getStatusLine();
                LOG.debug("POST {} => status: {}", (Object)finalURL, (Object)statusLine);
                return DagOnSteroids.NodeCleaner.NodeCleaningResult.from((Scope)scope, (int)statusLine.getStatusCode(), (String)statusLine.getReasonPhrase(), (URI)finalURL);
            }
            catch (Exception e) {
                throw new DagOnSteroids.NodeCleaner.NodeCleanerException(finalURL, (Throwable)e);
            }
        };
    }

    public ThrowingBiFunction<Map.Entry<Scope, Boolean>, Dag.Node, DagOnSteroids.NodeCleaner.NodeCleaningResult, DagOnSteroids.NodeCleaner.NodeCleanerException> getCleaningFunction() {
        return this.cleaningFunction;
    }

    private static String doubleEncode(String name) {
        try {
            String utf8 = Charsets.UTF_8.name();
            return URLEncoder.encode(URLEncoder.encode(name, utf8), utf8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return name;
        }
    }

    public static class DagAndNode {
        public final Dag dag;
        public final Dag.Node node;

        private static DagAndNode get(Dag dag, Dag.Node node) {
            return new DagAndNode(dag, node);
        }

        private DagAndNode(Dag dag, Dag.Node node) {
            this.dag = dag;
            this.node = node;
        }

        public Dag getDag() {
            return this.dag;
        }

        public Dag.Node getNode() {
            return this.node;
        }
    }

    private static class HB {
        private final ConcurrentMapTemplateCache cache = new ConcurrentMapTemplateCache();
        private final Handlebars handlebars = new Handlebars();
        private final Parser parser = this.handlebars.getParserFactory().create(this.handlebars, "{{", "}}");

        private HB() {
        }

        private String applyTemplateAsString(Dag dag, Dag.Node node, Scope scope, String templateAsString) throws IOException {
            StringTemplateSource source = new StringTemplateSource(String.valueOf(dag.getName()) + "_" + scope.toString() + "_nameTemplate", templateAsString);
            Template template = this.cache.get((TemplateSource)source, this.parser);
            StringWriter writer = new StringWriter();
            template.apply((Object)DagAndNode.get(dag, node), (Writer)writer);
            ((Writer)writer).flush();
            return ((Object)writer).toString();
        }
    }
}

