/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs.github;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.jaxrs.AbstractResource;
import net.aequologica.neo.dagr.model.Dag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notifiers/github")
public class ResourceGithub
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(ResourceGithub.class);

    @POST
    @Path(value="/notification")
    @Consumes(value={"application/json"})
    public Response getPushNotification(String payload) throws IOException {
        try {
            log.debug("[github] payload: {}", (Object)payload);
            System.out.println("[github] payload: " + payload.replace("\n", "").replace("\r", ""));
            JsonObject githubPushPayload = (JsonObject)this.mapper.readValue(payload, JsonObject.class);
            String repo_fullname = null;
            String ref = githubPushPayload.getString("ref");
            JsonObject repositoryObject = githubPushPayload.getJsonObject("repository");
            if (repositoryObject != null) {
                repo_fullname = repositoryObject.getString("full_name");
            }
            if (repo_fullname != null && ref != null) {
                log.debug("[bus] sending event {}, repo_fullname='{}', ref='{}' to the bus", new Object[]{BusEvent.Type.SMUDGE, repo_fullname, ref});
                System.out.println("[bus] sending event " + BusEvent.Type.SMUDGE + ", repo_fullname='" + repo_fullname + "', ref='" + ref + "' to the bus");
                Bus<Dag.Node, Scope> bus = this.getBusFromGithubRepository(repo_fullname);
                Dag dag = this.getDagFromGithubRepository(repo_fullname);
                if (bus != null && dag != null) {
                    List nodes = DagOnSteroids.getNodesFromNameAndBranchContains((Dag)dag, (String)repo_fullname, (String)ref);
                    bus.send(BusEvent.Type.SMUDGE, (Collection)nodes, "notification from github");
                }
            }
            return Response.noContent().build();
        }
        catch (Exception e) {
            log.error("[github] exception /{}/ logged and re-thrown", (Object)e.getMessage());
            System.err.println("[github] exception /" + e.getMessage() + "/ logged and re-thrown");
            throw e;
        }
    }

    public Bus<Dag.Node, Scope> getBusFromGithubRepository(String repo) {
        throw new UnsupportedOperationException();
    }

    public Dag getDagFromGithubRepository(String repo) {
        throw new UnsupportedOperationException();
    }
}

