/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import de.skuzzle.semantic.Version;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Dags;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.jaxrs.DagInfo;
import net.aequologica.neo.dagr.jaxrs.GaranceWrapper;
import net.aequologica.neo.dagr.jaxrs.PATCH;
import net.aequologica.neo.dagr.jaxrs.jenkins.NodeCleanerJenkins;
import net.aequologica.neo.dagr.jaxrs.travis.NodeCleanerTravis;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.Pair;
import net.aequologica.neo.dagr.model.SubDagIncludes;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="v1")
public class ResourceDags
implements Observer {
    public static final String _PING = "_ping_";
    public static final String _VIEWS = "/views";
    public static final String __DAGS = "/dags/";
    public static final String __BUSES = "/buses/";
    public static final String __SUBS = "/subs/";
    public static final String __NODES = "/nodes/";
    public static final String __VERSIONS = "/versions/";
    public static final String __STATES = "/states/";
    public static final String __EVENTS = "/events/";
    public static final String __DESCRIPTION = "/description/";
    public static final String _RELOAD = "reload";
    public static final String _SEARCH = "search";
    public static final String _INFO = "/info";
    public static final String _JOURNAL = "/journal";
    public static final String _RELOAD_ME = "/reload";
    public static final String _RULES = "/rules";
    public static final String _FILTER = "/filter";
    public static final String _CURR_VER = "/current";
    public static final String _NEXT_VER = "/next";
    public static final String _TOPOLOGICAL = "/topological";
    public static final String _ISOMORPH = "/isomorph";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDags.class);
    private static final String SIMPLENAME = ResourceDags.class.getSimpleName();
    private final GaranceWrapper garanceWrapper = GaranceWrapper.THIS;
    @Inject
    private Dags dags;
    @Context
    private HttpServletRequest request;

    @Inject
    public ResourceDags() throws IOException {
    }

    @PostConstruct
    public void postConstruct() {
        this.dags.addObserver((Observer)this);
        ArrayList exceptions = new ArrayList();
        this.update((Observable)this.dags, exceptions);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(o instanceof Dags) || !this.dags.equals(o)) {
            return;
        }
        if (arg instanceof Boolean && ((Boolean)arg).booleanValue()) {
            this.garanceWrapper._closeGaranceSubscriptions();
        } else if (arg instanceof String) {
            String dagName = (String)arg;
            this.garanceWrapper._closeGaranceSubscription(dagName);
        } else if (arg instanceof Map.Entry) {
            Map.Entry thisDagEntry = (Map.Entry)arg;
            DagOnSteroids dagOnSteroids = this.dags.getDagOnSteroids(((String)thisDagEntry.getKey()).toString());
            if (dagOnSteroids != null) {
                for (Map.Entry busEntry : dagOnSteroids.getBusEntries()) {
                    ((Collection)thisDagEntry.getValue()).addAll(this.garanceWrapper._initGaranceSubscription(dagOnSteroids, busEntry));
                }
                ((Collection)thisDagEntry.getValue()).addAll(this._initProperties(dagOnSteroids));
            }
        } else if (arg instanceof Collection) {
            Collection exceptions = (Collection)arg;
            Collection dagOnSteroidss = this.dags.getDagOnSteroidss();
            for (DagOnSteroids dagOnSteroids : dagOnSteroidss) {
                for (Map.Entry busEntry : dagOnSteroids.getBusEntries()) {
                    exceptions.add(ResourceDags.tuple(dagOnSteroids.getDag().getName(), this.garanceWrapper._initGaranceSubscription(dagOnSteroids, busEntry)));
                }
                exceptions.add(ResourceDags.tuple(dagOnSteroids.getDag().getName(), this._initProperties(dagOnSteroids)));
            }
        }
    }

    private Collection<Map.Entry<String, String>> _initProperties(DagOnSteroids dagOnSteroids) {
        ArrayList exceptions;
        block18: {
            Map properties = dagOnSteroids.getProperties();
            if (properties == null) {
                return Collections.emptyList();
            }
            exceptions = Lists.newArrayList();
            try {
                String dagCleanerType = (String)properties.get("type");
                String dagCleanerName = (String)properties.get("name");
                String dagCleanerUrl = (String)properties.get("url");
                String dagCleanerToken = (String)properties.get("token");
                String dagCleanerAuthorizationHeader = (String)properties.get("authorizationHeader");
                String dagCleanerCallbackHost = (String)properties.get("callbackHost");
                EnumMap dagCleanerNameTemplates = dagOnSteroids.getNameTemplates();
                if (dagOnSteroids == null || dagCleanerType == null || dagCleanerName == null || dagCleanerUrl == null || dagCleanerToken == null) break block18;
                if (dagCleanerType.equals("jenkins")) {
                    Set<Map.Entry<String, String>> dagCleanerParams = this._getBuildParamsIfAny((String)properties.get("params"), exceptions);
                    URI callback = null;
                    if (this.request != null) {
                        String callbackURIAsString = this.request.getRequestURL().toString().replace(this.request.getRequestURI(), this.request.getContextPath());
                        UriBuilder uriBuilder = UriBuilder.fromUri((String)callbackURIAsString);
                        if (dagCleanerCallbackHost != null && !dagCleanerCallbackHost.trim().isEmpty()) {
                            uriBuilder = uriBuilder.host(dagCleanerCallbackHost);
                        } else if (this.request.getServerName().equals("localhost")) {
                            Throwable throwable = null;
                            Object var16_19 = null;
                            try (DatagramSocket socket = new DatagramSocket();){
                                socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
                                String ip = socket.getLocalAddress().getHostAddress();
                                uriBuilder = uriBuilder.host(ip);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        callback = uriBuilder.build(new Object[0]);
                    }
                    dagOnSteroids.setCleaningFunction(new NodeCleanerJenkins(dagOnSteroids.getDag().getName(), dagCleanerUrl, dagCleanerToken, dagCleanerParams, dagCleanerAuthorizationHeader, dagCleanerNameTemplates, dagOnSteroids.bumper, callback).getCleaningFunction());
                    break block18;
                }
                if (dagCleanerType.equals("travis")) {
                    String dagCleanerUrlProxy = (String)properties.get("urlProxy");
                    dagOnSteroids.setCleaningFunction(new NodeCleanerTravis(dagCleanerUrlProxy != null ? dagCleanerUrlProxy : dagCleanerUrl, dagCleanerToken).getCleaningFunction());
                }
            }
            catch (Exception e) {
                exceptions.add(ResourceDags.tuple(e.getClass().getSimpleName(), e.getMessage()));
            }
        }
        return exceptions;
    }

    private Set<Map.Entry<String, String>> _getBuildParamsIfAny(String dagCleanerParams, Collection<Map.Entry<String, String>> exceptions) {
        if (dagCleanerParams == null) {
            return null;
        }
        Set params = Collections.emptySet();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            params = (Set)objectMapper.readValue(dagCleanerParams, (TypeReference)new TypeReference<Set<Map.Entry<String, String>>>(){});
        }
        catch (IOException e) {
            exceptions.add(ResourceDags.tuple("params=" + dagCleanerParams, String.valueOf(e.getClass().getSimpleName()) + " - " + e.getMessage()));
        }
        return params;
    }

    @GET
    @Path(value="_ping_")
    @Produces(value={"text/plain"})
    public String ping_GET_TEXT() {
        return "_pong_";
    }

    @POST
    @Path(value="/dags/reload")
    @Produces(value={"application/json"})
    public Response dagReloadAll_POST() {
        Collection allExceptions = this.dags.loadDags();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)allExceptions).build();
    }

    @POST
    @Path(value="/dags/{dag}/reload")
    @Produces(value={"application/json"})
    public Response dagReloadThis_POST(@PathParam(value="dag") String dagName) {
        Dag dag = this._getDag(dagName);
        Map.Entry thisDagLoadExceptions = this.dags.loadDag(dagName);
        if (((Collection)thisDagLoadExceptions.getValue()).size() > 0) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)thisDagLoadExceptions).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/dags/search")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public List<String> dagSearch_GET(@QueryParam(value="node") @DefaultValue(value="") String nodeName, @QueryParam(value="key") @DefaultValue(value="") String key, @QueryParam(value="value") @DefaultValue(value="") String value) {
        if (nodeName.isEmpty() && (key.isEmpty() || value.isEmpty())) {
            return Collections.emptyList();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Dag dag : this.dags.getDAGs()) {
            String filter = ".nodes[]";
            if (!nodeName.isEmpty()) {
                filter = String.valueOf(filter) + "| select(.name | test(\"" + nodeName + "\"))";
            }
            if (!key.isEmpty() && !value.isEmpty()) {
                filter = String.valueOf(filter) + "| select(." + key + " | test(\"" + value + "\"))";
            }
            try {
                List list;
                Object o = dag.filter(filter);
                if (!(o instanceof List) || (list = (List)o).size() <= 0) continue;
                ret.add(dag.getName());
            }
            catch (JsonQueryException e) {
                LOG.warn("Exception applying filter\"" + filter + "\" to dag /" + dag.getName() + ": " + e.getMessage());
            }
        }
        return ret;
    }

    @GET
    @Path(value="/dags/")
    @Produces(value={"application/json"})
    public List<DagInfo> dagInfos_GET_JSON() throws IOException {
        return this.dags.getDagOnSteroidss().stream().map(d -> DagInfo.create(d)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/dags/{dag}")
    @Produces(value={"application/json"})
    public Dag dag_GET_JSON(@PathParam(value="dag") String dagName) throws IOException {
        return this._getDag(dagName);
    }

    @GET
    @Path(value="/dags/{dag}/info")
    @Produces(value={"application/json"})
    public DagInfo dagInfo_GET_JSON(@PathParam(value="dag") String dagName) throws Exception {
        return this._getDagInfo(dagName, null);
    }

    @POST
    @Path(value="/dags/{dag}/filter")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response dagFilter_POST(String jsonQuery, @PathParam(value="dag") String dagName, @QueryParam(value="returnSingleElementArray") @DefaultValue(value="false") Boolean returnSingleElementArray) throws Exception {
        List list;
        Dag dag = this._getDag(dagName);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("dag /" + dagName + "/ not found")).build());
        }
        Object filtered = dag.filter(jsonQuery);
        if (!returnSingleElementArray.booleanValue() && filtered instanceof List && (list = (List)filtered).size() == 1) {
            filtered = list.get(0);
        }
        return Response.ok().entity(filtered).build();
    }

    @GET
    @Path(value="/dags/{dag}/current")
    @Produces(value={"application/json"})
    public Response dagCurrent_GET(@PathParam(value="dag") String dagName) throws Exception {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagName);
        if (dagOnSteroids == null || dagOnSteroids.getDag() == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("dag /" + dagName + "/ not found")).build());
        }
        Collection currents = dagOnSteroids.getCurrents(true);
        return Response.ok().entity((Object)currents).build();
    }

    @GET
    @Path(value="/dags/{dag}/next")
    @Produces(value={"application/json"})
    public Response dagNext_GET(@PathParam(value="dag") String dagName, @QueryParam(value="allowSnapshots") @DefaultValue(value="true") Boolean allowSnapshots) throws Exception {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagName);
        if (dagOnSteroids == null || dagOnSteroids.getDag() == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("dag /" + dagName + "/ not found")).build());
        }
        Collection nexts = dagOnSteroids.getNexts(true, allowSnapshots.booleanValue());
        return Response.ok().entity((Object)nexts).build();
    }

    @GET
    @Path(value="/dags/{dag}/subs/")
    @Produces(value={"application/json"})
    public Collection<Map.Entry<String, SortedSet<String>>> dagSubs_GET(@PathParam(value="dag") String dagName) throws Exception {
        Dag dag = this._getDag(dagName);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("dag /" + dagName + "/ not found")).build());
        }
        return dag.getSubDagIds();
    }

    @POST
    @Path(value="/dags/{dag}/subs/")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String dagSub_POST(Set<String> nodeNames, @PathParam(value="dag") String dagName, @QueryParam(value="with") SubDagIncludes includes, @QueryParam(value="depth") @DefaultValue(value="0") Integer depth) throws Exception {
        Dag dag = this._getDag(dagName);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("dag /" + dagName + "/ not found")).build());
        }
        if (includes != null || depth != 0) {
            nodeNames = dag.expandNodesNames(nodeNames, includes, depth);
        }
        return dag.registerSubDag(nodeNames);
    }

    @GET
    @Path(value="/dags/{dag}/subs/{sub}")
    @Produces(value={"application/json"})
    public Dag dagSub_GET_JSON(@PathParam(value="dag") String dagName, @PathParam(value="sub") String subDagKey, @QueryParam(value="with") SubDagIncludes includes, @QueryParam(value="depth") @DefaultValue(value="0") Integer depth) throws Exception {
        Dag dag = this._getDag(dagName);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("dag [" + dagName + "] not found")).build());
        }
        Dag subdag = dag.getSubDag(subDagKey);
        if (subdag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("dag > sub [" + dagName + " > " + subDagKey + "] not found")).build());
        }
        if (includes == null || depth == 0) {
            return subdag;
        }
        Set expandedNodesNames = dag.expandNodesNames(subdag.getNodes().stream().map(n -> n.getName()).collect(Collectors.toSet()), includes, depth);
        String subDagId = dag.registerSubDag(expandedNodesNames);
        return dag.getSubDag(subDagId);
    }

    @POST
    @Path(value="/dags/{dag}/subs/{sub}/description/{description}")
    @Produces(value={"text/plain"})
    public String dagSubSave_PUT_JSON(@PathParam(value="dag") String dagName, @PathParam(value="sub") String subDagKey, @PathParam(value="description") String description) throws Exception {
        Dag dag = this._getDag(dagName);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("dag [" + dagName + "] not found")).build());
        }
        Dag subdag = dag.getSubDag(subDagKey);
        if (subdag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("dag > sub [" + dagName + " > " + subDagKey + "] not found")).build());
        }
        java.nio.file.Path path = this.dags.saveSub(dag, subDagKey, description);
        return path.toString();
    }

    @DELETE
    @Path(value="/dags/{dag}/subs/{sub}")
    public void dagSub_DELETE(@PathParam(value="dag") String dagName, @PathParam(value="sub") String subDagKey) throws Exception {
        Dag dag = this._getDag(dagName);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("dag [" + dagName + "] not found")).build());
        }
        String removeSubDag = dag.unregisterSubDag(subDagKey);
        if (removeSubDag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("subgraph [" + subDagKey + "] for dag [" + dagName + "] not found")).build());
        }
    }

    @GET
    @Path(value="/dags/{dag}/isomorph/{otherDag}")
    @Produces(value={"application/json"})
    public Collection<List<Pair<Dag.Node, Dag.Node>>> isomorph_GET_JSON(@PathParam(value="dag") String dagName, @PathParam(value="otherDag") String otherDagName) throws Exception {
        Dag dag = this._getDag(dagName);
        Dag other = this._getDag(otherDagName);
        return dag.getIsomorphism(other);
    }

    @GET
    @Path(value="/dags/{dag}/topological")
    @Produces(value={"application/json"})
    public List<String> topological_GET_JSON(@PathParam(value="dag") String dagName, @QueryParam(value="type") @DefaultValue(value="ID") TopologicalReturnType type) throws Exception {
        Function transform;
        Dag dag = this._getDag(dagName);
        Iterator topologicalOrderIterator = dag.getTopologicalOrderIterator();
        if (type == null || type.equals((Object)TopologicalReturnType.ID)) {
            transform = n -> n.getId();
        } else if (type.equals((Object)TopologicalReturnType.NAME)) {
            transform = n -> n.getName();
        } else if (type.equals((Object)TopologicalReturnType.GAV)) {
            transform = node -> {
                Dag.NodeValue value = node.getValue();
                if (value == null) {
                    return node.getId();
                }
                String gucrid = value.getGucrid();
                if (gucrid == null || gucrid.length() == 0) {
                    return node.getId();
                }
                Iterable split = Splitter.on((char)':').split((CharSequence)gucrid);
                Iterator iterator = split.iterator();
                if (!iterator.hasNext()) {
                    return node.getId();
                }
                String groupId = (String)iterator.next();
                if (!iterator.hasNext()) {
                    return node.getId();
                }
                String artifactId = (String)iterator.next();
                if (artifactId == null || artifactId.toString().length() == 0) {
                    return node.getId();
                }
                return gucrid;
            };
        } else {
            throw new InvalidParameterException("invalid parameter 'type' ('" + (Object)((Object)type) + "') in query string. must be one of " + TopologicalReturnType.values() + "; when not type parameter is given, type='" + (Object)((Object)TopologicalReturnType.ID) + "' is the default.");
        }
        return Lists.newArrayList((Iterator)Iterators.transform((Iterator)topologicalOrderIterator, (Function)transform));
    }

    @GET
    @Path(value="/dags/{dag}/buses/{bus}/journal")
    @Produces(value={"text/plain"})
    public String dagBusJournal_GET_TEXT_PLAIN(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope) throws Exception {
        DagOnSteroids dagOnSteroids = this.dags.getDagOnSteroids(dagName);
        if (dagOnSteroids == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagName + "] not found").valueOf(MediaType.TEXT_PLAIN_TYPE)).build());
        }
        return dagOnSteroids.getDagCleaner(scope).getJournalAsString();
    }

    @DELETE
    @Path(value="/dags/{dag}/buses/{bus}")
    @Produces(value={"application/json"})
    public Response dagBus_DELETE(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope) throws Exception {
        return this.dagBusSub_DELETE(dagName, scope, null);
    }

    @DELETE
    @Path(value="/dags/{dag}/buses/{bus}/subs/{sub}")
    @Produces(value={"application/json"})
    public Response dagBusSub_DELETE(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="sub") String subDagKey) throws Exception {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagName);
        DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
        String info = null;
        DagOnSteroids.State state = dagCleaner.getState();
        if (state == null || !state.equals((Object)DagOnSteroids.State.RUNNING)) {
            info = "cleaning not running, nothing to cancel";
        } else {
            dagCleaner.cancel();
            info = !dagCleaner.getState().equals((Object)DagOnSteroids.State.RUNNING) ? "cleaning cancelled (nb. node cleanings already ordered or currently running will continue until completion)" : "oooops, seems that cleaning could not be cancelled ... maybe retry ?";
        }
        return Response.ok((Object)Message.message(info)).build();
    }

    @GET
    @Path(value="/dags/{dag}/buses/{bus}")
    @Produces(value={"text/plain"})
    public Response dagBus_GET(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope) throws Exception {
        DagOnSteroids.State state = null;
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagName);
        try {
            DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
            state = dagCleaner.getState();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Error.error(e.getMessage())).build());
        }
        return Response.ok().entity((Object)(state == null ? "null" : state.toString())).build();
    }

    @PUT
    @Path(value="/dags/{dag}/buses/{bus}")
    @Produces(value={"application/json"})
    public Response dagBus_PUT(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope) throws Exception {
        return this.privateDagBusPut(dagName, scope, null);
    }

    @PATCH
    @Deprecated
    @Path(value="/dags/{dag}/buses/{bus}")
    @Produces(value={"application/json"})
    public Response dagBus_PATCH(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope) throws Exception {
        return this.privateDagBusPut(dagName, scope, null);
    }

    @PUT
    @Path(value="/dags/{dag}/buses/{bus}/subs/{sub}")
    @Produces(value={"application/json"})
    public Response dagBusSub_PUT(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="sub") String subDagKey) throws Exception {
        return this.privateDagBusPut(dagName, scope, subDagKey);
    }

    @PATCH
    @Deprecated
    @Path(value="/dags/{dag}/buses/{bus}/subs/{sub}")
    @Produces(value={"application/json"})
    public Response dagBusSub_PATCH(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="sub") String subDagKey) throws Exception {
        return this.privateDagBusPut(dagName, scope, subDagKey);
    }

    private Response privateDagBusPut(String dagName, Scope scope, String subDagKey) {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagName);
        try {
            DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
            dagCleaner.cleanSubDag(subDagKey);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Error.error(e.getMessage())).build());
        }
        return Response.created((URI)URI.create("journal")).status(Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/dags/{dag}/nodes/")
    @Produces(value={"application/json"})
    public Collection<Dag.Node> dagNodes_GET_JSON(@PathParam(value="dag") String dagName) throws Exception {
        Dag dag = this._getDag(dagName);
        return dag.getNodes();
    }

    @GET
    @Path(value="/dags/{dag}/nodes/{node}")
    @Produces(value={"application/json"})
    public Dag.Node dagNode_GET_JSON(@PathParam(value="dag") String dagName, @PathParam(value="node") String node) throws Exception {
        return this._getDagAndNodeByName((String)dagName, (String)node).node;
    }

    @GET
    @Path(value="/dags/{dag}/nodes/{node}/versions/current")
    @Produces(value={"application/json"})
    public String dagNodeCurrentVersion_GET_JSON(@PathParam(value="dag") String dagName, @PathParam(value="node") String node) throws Exception {
        DagOnSteroidsAndNode _getDagAndNodeByName = this._getDagOnSteroidsAndNodeByName(dagName, node);
        DagOnSteroids.NodeNameVersion current = _getDagAndNodeByName.dag.getCurrent(_getDagAndNodeByName.node, false);
        return current.version;
    }

    @GET
    @Path(value="/dags/{dag}/nodes/{node}/versions/next")
    @Produces(value={"application/json"})
    public String dagNodeNextVersions_GET_JSON(@PathParam(value="dag") String dagName, @PathParam(value="node") String node, @QueryParam(value="allowSnapshots") @DefaultValue(value="true") Boolean allowSnapshots) throws Exception {
        DagOnSteroidsAndNode _getDagAndNodeByName = this._getDagOnSteroidsAndNodeByName(dagName, node);
        DagOnSteroids.NodeNameVersion current = _getDagAndNodeByName.dag.getNext(_getDagAndNodeByName.node, false, allowSnapshots.booleanValue(), false);
        return current.version;
    }

    @GET
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}/states/")
    @Produces(value={"application/json"})
    public DagOnSteroids.NodeCleaner.NodeState dagBusNodeState_GET_JSONfinal(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="node") String nodeName) throws Exception {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagName);
        Dag.Node node = this.dagNode_GET_JSON(dagName, nodeName);
        return dagOnSteroids.getDagCleaner(scope).getNodeCleaner(node).getState();
    }

    @PATCH
    @Deprecated
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}")
    @Produces(value={"application/json"})
    public Response dagBusNode_PATCH(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="node") String nodeName, @PathParam(value="skipRelease") @DefaultValue(value="false") Boolean skipRelease) throws Exception {
        return this.dagBusNode_PUT(dagName, scope, nodeName, skipRelease);
    }

    @PUT
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}")
    @Produces(value={"application/json"})
    public Response dagBusNode_PUT(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="node") String nodeName, @PathParam(value="skipRelease") @DefaultValue(value="false") Boolean skipRelease) throws Exception {
        DagAndNode dagAndNode = this._getDagAndNodeByName(dagName, nodeName);
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagName);
        DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
        Bus bus = dagCleaner.getBus();
        DagOnSteroids.NodeCleaner.NodeCleaningResult cleanResult = dagOnSteroids.clean(scope, dagAndNode.node, skipRelease);
        if (cleanResult != null && cleanResult.asBoolean()) {
            this._sendBusEvent((Bus<Dag.Node, Scope>)bus, BusEvent.Type.CLEAN_ORDER_OK, dagAndNode.node);
            return Response.accepted().build();
        }
        this._sendBusEvent((Bus<Dag.Node, Scope>)bus, BusEvent.Type.CLEAN_ORDER_ERROR, dagAndNode.node);
        return Response.serverError().entity((Object)cleanResult).build();
    }

    @PATCH
    @Deprecated
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}/states/{state}")
    @Produces(value={"application/json"})
    public Response dagBusNodeState_PATCH_JSON(@PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="node") String nodeName, @PathParam(value="state") DagOnSteroids.NodeCleaner.NodeState newState) throws Exception {
        return this.dagBusNodeState_PUT_JSON(dagName, scope, nodeName, newState);
    }

    @PUT
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}/states/{state}")
    @Produces(value={"application/json"})
    public Response dagBusNodeState_PUT_JSON(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Scope scope, @PathParam(value="node") String nodename, @PathParam(value="state") DagOnSteroids.NodeCleaner.NodeState newState) throws Exception {
        try {
            DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
            DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
            Bus bus = dagCleaner.getBus();
            Dag.Node node = this.dagNode_GET_JSON(dagkey, nodename);
            DagOnSteroids.NodeCleaner nodeCleaner = dagCleaner.getNodeCleaner(node);
            DagOnSteroids.NodeCleaner.NodeState currentState = nodeCleaner.getState();
            if (currentState == null && newState == null || currentState != null && newState != null && newState.equals((Object)currentState)) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
            nodeCleaner.setState(newState);
            this._sendBusEvent((Bus<Dag.Node, Scope>)bus, BusEvent.Type.STATE_CHANGE_HACK, node);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("[dagr " + SIMPLENAME + "] exception /{}/ logged and re-thrown", (Object)e.getMessage());
            throw e;
        }
    }

    @GET
    @Path(value="/dags/{dag}/rules")
    @Produces(value={"application/xml"})
    public Response dagBusNodeRules_GET_JSONfinal(@PathParam(value="dag") String dagkey, @QueryParam(value="withArtifact") @DefaultValue(value="false") boolean withArtifact) throws Exception {
        Dag dag = this._getDag(dagkey);
        StringBuilder entity = new StringBuilder();
        entity.append("<ruleset comparisonMethod=\"maven\"\n         xmlns=\"http://mojo.codehaus.org/versions-maven-plugin/rule/2.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://mojo.codehaus.org/versions-maven-plugin/rule/2.0.0 http://mojo.codehaus.org/versions-maven-plugin/xsd/rule-2.0.0.xsd\">\n  <rules>\n");
        for (Dag.Node node : dag.getNodes()) {
            Dag.Gucrid gucrid = Dag.Gucrid.create((String)node.getValue().getGucrid());
            if (!(gucrid != null && gucrid.getGroupId().isPresent() && gucrid.getArtifactId().isPresent() && gucrid.getSemanticVersion().isPresent())) {
                entity.append("    <!-- cannot parse groupId or artifactId or semantic version from gucrid=[" + node.getValue().getGucrid() + "] -->");
                continue;
            }
            StringBuilder forbiddenVersions = new StringBuilder();
            int major = ((Version)gucrid.getSemanticVersion().get()).getMajor();
            int i = major + 1;
            while (i < 10) {
                forbiddenVersions.append(String.valueOf(i));
                ++i;
            }
            entity.append("    <rule groupId=\"" + (String)gucrid.getGroupId().get() + "\"");
            if (withArtifact) {
                entity.append(" artifactId=\"" + (String)gucrid.getArtifactId().get() + "\" ");
            }
            entity.append(" comparisonMethod=\"maven\">\n      <ignoreVersions>\n        <ignoreVersion type=\"regex\">^[" + forbiddenVersions.toString() + "]\\..*</ignoreVersion>\n" + "      </ignoreVersions>\n" + "    </rule>\n" + "    ");
        }
        entity.append("  </rules>\n</ruleset>");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)entity.toString()).build();
    }

    @PUT
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}/events/{event}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response dagBusNodeEvent_PUT(String cleanerId, @PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="node") String nodeName, @PathParam(value="event") BusEvent.Type eventType) {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagName);
        DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
        Bus bus = dagCleaner.getBus();
        DagAndNode dagAndNode = this._getDagAndNodeByName(dagName, nodeName);
        DagOnSteroids.NodeCleaner nodeCleaner = dagCleaner.getNodeCleaner(dagAndNode.node);
        if (eventType.equals((Object)BusEvent.Type.CLEAN_STARTED)) {
            if (cleanerId != null && cleanerId.length() > 0) {
                nodeCleaner.setId(cleanerId);
            }
        } else if (eventType.equals((Object)BusEvent.Type.CLEAN_OK) || eventType.equals((Object)BusEvent.Type.CLEAN_ERROR) || eventType.equals((Object)BusEvent.Type.CLEAN_ABORTED)) {
            nodeCleaner.setId(null);
        }
        this._sendBusEvent((Bus<Dag.Node, Scope>)bus, eventType, dagAndNode.node);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @PATCH
    @Deprecated
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}/events/{event}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response dagBusNodeEvent_PATCH(String cleanerId, @PathParam(value="dag") String dagName, @PathParam(value="bus") Scope scope, @PathParam(value="node") String nodeName, @PathParam(value="event") BusEvent.Type eventType) {
        return this.dagBusNodeEvent_PUT(cleanerId, dagName, scope, nodeName, eventType);
    }

    @GET
    @Path(value="/views/dags/")
    @Produces(value={"text/html"})
    public Viewable dagList_GET_HTML() throws IOException {
        return new Viewable("/WEB-INF/dagr/dag-list");
    }

    @GET
    @Path(value="/views/dags/{dag}")
    @Produces(value={"text/html"})
    public Viewable dag_GET_HTML(@PathParam(value="dag") String dagName) {
        return this.dagSub_GET_HTML(dagName, null);
    }

    @GET
    @Path(value="/views/dags/{dag}/subs/{sub}")
    @Produces(value={"text/html"})
    public Viewable dagSub_GET_HTML(@PathParam(value="dag") String dagName, @PathParam(value="sub") String subkey) {
        try {
            DagInfo info = this._getDagInfo(dagName, subkey);
            String warning = subkey != null && !subkey.isEmpty() && info.getSubDagId() == null ? "sub \"" + subkey + "\" not found in dag \"" + dagName + "\"" : null;
            return new Viewable("/WEB-INF/dagr/dag", (Object)new Model(Arrays.asList(info), warning, null));
        }
        catch (NotFoundException e) {
            return new Viewable("/WEB-INF/dagr/dag", (Object)new Model(null, "dag \"" + dagName + "\" not found", (Exception)((Object)e)));
        }
    }

    private Dag _getDag(String dagkey) throws NotFoundException {
        String[] both = DagOnSteroids.parseName((String)dagkey);
        Dag dag = this.dags.getDAG(both[0]);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagkey + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        return dag;
    }

    private DagInfo _getDagInfo(String dagkey, String subDagId) throws NotFoundException {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
        dagOnSteroids.setSubDagId(subDagId);
        DagInfo info = DagInfo.create(dagOnSteroids);
        if (info == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("info for dag [" + dagkey + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        return info;
    }

    private DagOnSteroids _getDagOnSteroids(String dagkey) throws NotFoundException {
        DagOnSteroids dagOnSteroids = this.dags.getDagOnSteroids(dagkey);
        if (dagOnSteroids == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagkey + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        return dagOnSteroids;
    }

    private DagAndNode _getDagAndNodeByName(String dagkey, String nodeName) throws NotFoundException {
        Dag dag = this._getDag(dagkey);
        Collection nodes = dag.getNodesFromName(nodeName);
        if (nodes.size() == 0) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagkey + "] node [" + nodeName + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        if (nodes.size() > 1) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)("application error. Found multiple nodes with the same name [" + nodeName + "] in dag [" + dagkey + "]. This is not supported")).build());
        }
        return DagAndNode.dagAndNode(dag, (Dag.Node)nodes.stream().findFirst().get());
    }

    private DagOnSteroidsAndNode _getDagOnSteroidsAndNodeByName(String dagkey, String nodeName) throws NotFoundException {
        DagOnSteroids dag = this._getDagOnSteroids(dagkey);
        Collection nodes = dag.getDag().getNodesFromName(nodeName);
        if (nodes.size() == 0) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagkey + "] node [" + nodeName + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        if (nodes.size() > 1) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)("application error. Found multiple nodes with the same name [" + nodeName + "] in dag [" + dagkey + "]. This is not supported")).build());
        }
        return DagOnSteroidsAndNode.dagOnSteroidsAndNode(dag, (Dag.Node)nodes.stream().findFirst().get());
    }

    private void _sendBusEvent(Bus<Dag.Node, Scope> bus, BusEvent.Type eventType, Dag.Node node) {
        if (bus == null) {
            throw new RuntimeException("no bus");
        }
        List<Object> listOfNodes = node == null ? Collections.emptyList() : Collections.singletonList(node);
        LOG.debug("[dagr {}] sending event {}, node='{}' to the bus", new Object[]{SIMPLENAME, eventType, node == null ? "\u2205" : node.getName()});
        bus.send(eventType, listOfNodes, this.request.getRequestURI().toString());
    }

    static <T> Map.Entry<String, T> tuple(String a, T b) {
        return new AbstractMap.SimpleImmutableEntry<String, T>(a, b);
    }

    static class DagAndNode {
        final Dag dag;
        final Dag.Node node;

        static DagAndNode dagAndNode(Dag dag, Dag.Node node) {
            return new DagAndNode(dag, node);
        }

        private DagAndNode(Dag dag, Dag.Node node) {
            this.dag = dag;
            this.node = node;
        }
    }

    static class DagOnSteroidsAndNode {
        final DagOnSteroids dag;
        final Dag.Node node;

        static DagOnSteroidsAndNode dagOnSteroidsAndNode(DagOnSteroids dag, Dag.Node node) {
            return new DagOnSteroidsAndNode(dag, node);
        }

        private DagOnSteroidsAndNode(DagOnSteroids dag, Dag.Node node) {
            this.dag = dag;
            this.node = node;
        }
    }

    @JsonIgnoreProperties
    public static class Error {
        @JsonProperty
        final String error;

        public static Error error(String error) {
            return new Error(error);
        }

        public Error(String error) {
            this.error = error;
        }

        public Object valueOf(MediaType mediaType) {
            if (mediaType.equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
                return this.error;
            }
            if (mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE)) {
                return this;
            }
            return this.error;
        }
    }

    @JsonIgnoreProperties
    public static class Message {
        @JsonProperty
        final String message;

        public static Message message(String message) {
            return new Message(message);
        }

        public Message(String message) {
            this.message = message;
        }
    }

    public static class Model {
        final List<DagInfo> infos;
        final String warning;
        final Exception exception;

        public Model(List<DagInfo> infos, String warning, Exception exception) {
            this.infos = infos == null ? Collections.emptyList() : infos;
            this.warning = warning;
            this.exception = exception;
        }

        public List<DagInfo> getInfos() {
            return this.infos;
        }

        public String getWarning() {
            return this.warning;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static enum TopologicalReturnType {
        ID,
        NAME,
        GAV;

    }
}

