/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import com.google.common.collect.Lists;
import io.reactivex.disposables.Disposable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.config.DagrConfig;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

enum GaranceWrapper {
    THIS;

    final Map<String, EnumMap<Scope, Disposable>> garanceSubscriptions = new HashMap<String, EnumMap<Scope, Disposable>>();
    private final Base64.Encoder base64encoder = Base64.getEncoder();
    private final String garanceEndPoint;
    private final String garanceApi;

    private GaranceWrapper() {
        String applicationUrl;
        DagrConfig dagrConfig = (DagrConfig)ConfigRegistry.CONFIG_REGISTRY.getConfig(DagrConfig.class);
        this.garanceEndPoint = dagrConfig.getGaranceEndPoint().contains("localhost") ? ((applicationUrl = System.getenv("HC_APPLICATION_URL")) != null && !applicationUrl.isEmpty() ? applicationUrl : dagrConfig.getGaranceEndPoint()) : dagrConfig.getGaranceEndPoint();
        this.garanceApi = "/api/garance/v1";
    }

    int put2garance(String key, Long value) throws UnsupportedEncodingException {
        if (key == null || value == null) {
            return -1;
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost postRequest = new HttpPost(String.valueOf(this.garanceEndPoint) + this.garanceApi + "/series/" + this.base64encoder.encodeToString(key.getBytes("UTF-8")) + "/values/" + String.valueOf(value.doubleValue()));
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)postRequest);){
                httpResponse.getEntity();
                int statusCode = httpResponse.getStatusLine().getStatusCode();
                return statusCode;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    Collection<Map.Entry<String, String>> _initGaranceSubscription(DagOnSteroids dagOnSteroids, Map.Entry<Scope, Bus<Dag.Node, Scope>> busEntry) {
        ArrayList exceptions = Lists.newArrayList();
        try {
            Disposable subscription = busEntry.getValue().toObservable().filter(event -> event.getType().equals((Object)BusEvent.Type.CLEAN_OK)).map(event -> (Dag.Node)event.get()).subscribe(node -> {
                if (busEntry != null && busEntry.getKey() != null && node != null && node.getId() != null && node.getDag() != null && node.getDag().getName() != null) {
                    String key = String.valueOf(node.getDag().getName()) + "::" + busEntry.getKey() + "::" + node.getName();
                    if (dagOnSteroids != null && dagOnSteroids.getDagCleaner((Scope)busEntry.getKey()) != null && dagOnSteroids.getDagCleaner((Scope)busEntry.getKey()).getNodeCleaner(node) != null) {
                        Long duration = dagOnSteroids.getDagCleaner((Scope)busEntry.getKey()).getNodeCleaner(node).getDuration();
                        this.put2garance(key, duration);
                    }
                }
            });
            String dagName = dagOnSteroids.getDag().getName();
            EnumMap<Scope, Object> dagSubscriptions = this.garanceSubscriptions.get(dagName);
            if (dagSubscriptions == null) {
                dagSubscriptions = new EnumMap(Scope.class);
                this.garanceSubscriptions.put(dagName, dagSubscriptions);
            }
            dagSubscriptions.put(busEntry.getKey(), (Object)subscription);
        }
        catch (Exception e) {
            exceptions.add(GaranceWrapper.tuple(e.getClass().getSimpleName(), e.getMessage()));
        }
        return exceptions;
    }

    void _closeGaranceSubscriptions() {
        for (EnumMap<Scope, Disposable> dagSubscriptions : this.garanceSubscriptions.values()) {
            for (Disposable aSubscription : dagSubscriptions.values()) {
                aSubscription.dispose();
            }
        }
        this.garanceSubscriptions.clear();
    }

    void _closeGaranceSubscription(String dagName) {
        EnumMap<Scope, Disposable> dagSubscriptions = this.garanceSubscriptions.get(dagName);
        if (dagSubscriptions != null) {
            for (Disposable aSubscription : dagSubscriptions.values()) {
                if (aSubscription == null) continue;
                aSubscription.dispose();
                this.garanceSubscriptions.remove(dagName);
            }
        }
    }

    static <T> Map.Entry<String, T> tuple(String a, T b) {
        return new AbstractMap.SimpleImmutableEntry<String, T>(a, b);
    }
}

