package net.aequologica.neo.dagr.websocket;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.DagOnSteroids.NodeCleaner;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class DagSocketMessage{
    private Boolean     initialize;
    private Scope       scope;
    private NodeCleaner nodeCleaner;
    private long        time;

    public DagSocketMessage(Boolean initialize, Scope scope){
        this(initialize, scope, null);
    }

    @JsonCreator
    public DagSocketMessage(@JsonProperty("initialize") final Boolean     initialize,
                            @JsonProperty("scope")      final Scope       scope,
                            @JsonProperty("cleaner")    final NodeCleaner cleaner){
        this.initialize  = initialize;
        this.scope       = scope;
        this.nodeCleaner = cleaner;
        this.time        = new Date().getTime();
    }

    @JsonProperty("initialize") 
    public Boolean getInitialize() {
        return initialize;
    }

    public void setInitialize(Boolean initialize) {
        this.initialize = initialize;
    }

    @JsonProperty("scope") 
    public Scope getScope() {
        return scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    @JsonProperty("cleaner") 
    public NodeCleaner getNodeCleaner(){
        return nodeCleaner;
    }

    public void setNodeCleaner(NodeCleaner cleaner){
        this.nodeCleaner = cleaner;
    }

    public long getTime(){
        return time;
    }

    public void setTime(long time){
        this.time = time;
    }

    @Override
    public String toString() {
        return "DagSocketMessage [cleaner=" + nodeCleaner + ", time=" + time + "]";
    }

}
