package net.aequologica.neo.dagr.jaxrs.travis;

import java.util.Collection;

import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.jaxrs.AbstractResource;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.Dag.Node;

@javax.ws.rs.Path("/notifiers/travis")
public class ResourceTravis extends AbstractResource {
    
    final static Logger log = LoggerFactory.getLogger(ResourceTravis.class);
    
    @POST
    @javax.ws.rs.Path("notification")
    @Consumes("application/x-www-form-urlencoded")
    public Response receiveNotification(@FormParam("payload") String payload) throws Exception {
        
        try {
            log.debug("[travis] payload: {}", payload);
            System.out.println("[travis] payload: "+ payload.replace("\n", "").replace("\r", ""));
        
            // massage travis payload
            JsonObject travisPayload = mapper.readValue(payload, JsonObject.class);
            if (travisPayload == null) {
                Response.serverError().entity("failed to parse payload from [" + payload + "]").build();
            }
            
            String name = null;
            String owner_name = null;
            JsonObject repository = travisPayload.getJsonObject("repository");
            if (repository != null) {
                name = repository.getString("name");                // e.g. runciter
                owner_name = repository.getString("owner_name");    // e.g. production-neo-ondemand-com
            }
            final String branch = travisPayload.getString("branch");
            final int    status = travisPayload.getInt("status");
        
            if (name != null && branch != null) {
                BusEvent.Type type = (status == 0 ? BusEvent.Type.CLEAN_OK : BusEvent.Type.CLEAN_ERROR);
                
                log.error("[travis] sending event {}, name='{}', branch='{}' to bus={}", type, name, branch, owner_name);
                System.out.println("[travis] sending event "+type+", name='"+name+"', branch='"+branch+"' to the bus");
                
                // balance dans le bus
                Bus<Node, Scope> bus = getBusFromTravis(owner_name, null);
                Dag dag = getDagFromTravis(owner_name, null);
                if (bus != null && dag != null) {
                    Collection<Node> nodes = DagOnSteroids.getNodesFromNameAndBranchContains(dag,  name, branch);
                    
                    bus.send(BusEvent.Type.SMUDGE, nodes, "notification from github");
                }
            }
        
            return Response.noContent().build();
        } catch (Exception e) {
            log.error("[travis] exception {} /{}/ logged and re-thrown {}", e.getClass().getSimpleName(), e.getMessage(), e);
            throw e;
        } finally {
        }
    }
    
    public Bus<Node, Scope> getBusFromTravis(String owner_name, Object object) {
        throw new UnsupportedOperationException();
    }

    public Dag getDagFromTravis(String owner_name, Object object) {
        throw new UnsupportedOperationException();
    }
}
