package net.aequologica.neo.dagr.jaxrs.github;

import java.io.IOException;
import java.util.Collection;

import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.jaxrs.AbstractResource;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.Dag.Node;

@javax.ws.rs.Path("/notifiers/github")
public class ResourceGithub extends AbstractResource {

    private final static Logger log = LoggerFactory.getLogger(ResourceGithub.class);
    
    // cf. https://developer.github.com/v3/orgs/hooks/
    @POST
    @javax.ws.rs.Path("/notification")
    @Consumes("application/json")
    public Response getPushNotification(String payload) throws IOException {
        try {
            log.debug("[github] payload: {}", payload);
            System.out.println("[github] payload: "+ payload.replace("\n", "").replace("\r", ""));
            
            JsonObject githubPushPayload = mapper.readValue(payload, JsonObject.class);

            String repo_fullname = null;
            String ref           = githubPushPayload.getString("ref");

            JsonObject repositoryObject = githubPushPayload.getJsonObject("repository");
            if (repositoryObject != null) {
                repo_fullname = repositoryObject.getString("full_name");
            }
            
            if (repo_fullname != null && ref != null) {
                log.debug("[bus] sending event {}, repo_fullname='{}', ref='{}' to the bus", BusEvent.Type.SMUDGE, repo_fullname, ref);
                System.out.println("[bus] sending event "+BusEvent.Type.SMUDGE+", repo_fullname='"+repo_fullname+"', ref='"+ref+"' to the bus");
                
                // ça balance pas mal, dans le bus:
                Bus<Node, Scope> bus = getBusFromGithubRepository(repo_fullname);  
                Dag dag = getDagFromGithubRepository(repo_fullname);
                if (bus != null && dag != null) {
                    Collection<Node> nodes = DagOnSteroids.getNodesFromNameAndBranchContains(dag,  repo_fullname, ref);
                    bus.send(BusEvent.Type.SMUDGE, nodes, "notification from github");
                }
            } else {
            }

            return Response.noContent().build();
        } catch (Exception e) {
            log.error("[github] exception /{}/ logged and re-thrown", e.getMessage());
            System.err.println("[github] exception /" + e.getMessage() + "/ logged and re-thrown");
            throw e;
        } finally {
        }

    }
    
    public Bus<Node, Scope> getBusFromGithubRepository(final String repo) {
        throw new UnsupportedOperationException();
    }

    public Dag getDagFromGithubRepository(final String repo) {
        throw new UnsupportedOperationException();
    }

}
