package net.aequologica.neo.dagr.jaxrs;

import static net.aequologica.neo.dagr.jaxrs.ResourceDags.Error.error;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import net.aequologica.neo.dagr.DagOnSteroids.NodeCleaner;

@Provider
public class NodeCleanerExceptionMapper implements ExceptionMapper<NodeCleaner.NodeCleanerException> {

    @Override
    public Response toResponse(NodeCleaner.NodeCleanerException ex) {
        return Response.status(Status.INTERNAL_SERVER_ERROR)
                       .entity(error(ex.getMessage()))
                       .type(MediaType.APPLICATION_JSON)
                       .build();
      }
    }
