package net.aequologica.neo.dagr.jaxrs;

import static net.aequologica.neo.dagr.jaxrs.ResourceDags.Error.error;

import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import net.thisptr.jackson.jq.exception.JsonQueryException;

@Provider
public class JsonQueryExceptionMapper implements ExceptionMapper<JsonQueryException> {

    @Override
    public Response toResponse(JsonQueryException ex) {
        Throwable cause = ex.getCause();
        return Response.status(422) // http://stackoverflow.com/a/34088882/1070215
                       .entity(error(cause != null ? cause.getMessage() : ex.getMessage()))
                       .type(MediaType.APPLICATION_JSON)
                       .build();
      }
    }
