(function() {

  'use strict';

  window.DAGRE_D3_HELPER = (function() {
    
    // http://stackoverflow.com/questions/10973339/modifying-svg-attributes-with-javascript-has-no-effect
    ['preserveAspectRatio', 'viewBox'].forEach(function(k) {
      // jQuery converts the attribute name to lowercase before
      // looking for the hook. 
      $.attrHooks[k.toLowerCase()] = {
        set: function(el, value) {
          if (value) {
            el.setAttribute(k, value);
          } else {
            el.removeAttribute(k, value);
          }
          return true;
        },
        get: function(el) {
          return el.getAttribute(k);
        },
      };
    });
    
    // wire graph to table 
    function wireGraph2Table(dagId) {

      var $table = $('table.table[data-id="'+dagId+'"]');
      $('svg[data-id="'+dagId+'"] g.node' )
      .mouseenter(function() { 
        var nodeId = $(this).attr('id');
        if (nodeId) {
          var $tr = $table.find('tr[data-id="'+nodeId+'"]');
          $tr.addClass('HOVER');
        }
      }).on('click', function(event) {
        // console.log(event);
        if (event.shiftKey && event.ctrlKey) {
          event.preventDefault();
        } else {
          var nodeId = $(this).attr('id');
          if (nodeId) {
  
            var $tds  = $table.find('tr[data-id="'+nodeId+'"] td');
            var clazz = $(event.currentTarget).attr('class');

            if (event.shiftKey || clazz.includes('_checked_up_')) {
              var $preds = $tds.find('button.predecessors');
              if ($preds.length == 1 && $preds.css('visibility') != 'hidden') {
                $preds[0].click();
                event.preventDefault();
              }
            } 
              
            if (event.ctrlKey || clazz.includes('_checked_down_')) {
              var $succs = $tds.find('button.successors');
              if ($succs.length == 1 && $succs.css('visibility') != 'hidden') {
                $succs[0].click();
                event.preventDefault();
              }
            }
            
          }
        }
      }).mouseleave(function() {
        var nodeId = $(this).attr('id');
        if (nodeId) {
          var $tr = $table.find('tr[data-id="'+nodeId+'"]');
          $tr.removeClass('HOVER');
        }
      });

      var count = 0;
      $('svg[data-id="'+dagId+'"] g.edgePath path' )
      .mouseenter(function() {
        count = count + 1 ;
        d3.select(this).append("title").text("blah " + count);
      }).mouseleave(function() {
        d3.select("title").remove();
      });
    }
    
    var dim, undim;
    
    var putTheStuffMan = function(nodeId, remove, add) {
      // cf. http://stackoverflow.com/questions/8638621/jquery-svg-why-cant-i-addclass 
      $('g.node#' + nodeId).attr('class', function(index, classNames) {
          var arr                   = classNames.split(" ");          // console.log(nodeId, "classNames BEFORE", arr);
          var arrAfterRemove        = _.difference(arr, remove);
          var arrAfterRemoveThenAdd = _.unionBy(arrAfterRemove, add);
          
          // dim / undim ALL edges
          if (_.contains(_.difference(arrAfterRemoveThenAdd, arr), "_dimmed_")) {
            // dim
            // first cancel any undim
            if (undim) undim.cancel(); 
            dim = _.debounce( function(){
              d3.selectAll('g.edgePath path').style("stroke-opacity", .333);
            }, 500)();
          } else if (_.contains(_.difference(arr, arrAfterRemoveThenAdd), "_dimmed_")) {
            // no dim
            undim = _.debounce( function(){
              d3.selectAll('g.edgePath path').style("stroke-opacity", 1);
            }, 250)();
          }
          // console.log(nodeId, "classNames AFTER", arrAfterRemoveThenAdd);
          return arrAfterRemoveThenAdd.join(" ");
      });
    };
    
    var renderGraph = function(dag, dagSvgElement, node_name_variant_index) {
      if (typeof dag === "undefined" || typeof dag.nodes === "undefined") {
        return;
      }
      
      // window.log('rendering graph', moment().format());
      // console.trace();
      
      // clone dag to prevent angular infinite loop on $digest
      var dagClone = $.extend(true, {}, dag);
      // remove all nodes with clazz "artifact"
      _.remove(dagClone.nodes, function (node) {
        return node.clazz === 'artifact';
      });
      // remove all links with clazz "predecessor" or "successor" 
      _.remove(dagClone.links, function (link) {
        return link.clazz === 'predecessor' || link.clazz === 'successor';
      });

      // grab first child g element
      var outerSvgGroupElement = dagSvgElement.find('svg').children('g').get(0);
      $(outerSvgGroupElement).empty();
      
      // set up an SVG group so that we can translate the final graph.
      var innerSvgGroupElement = d3.select(outerSvgGroupElement).append("g");

      var createGraph = function(dag) {
        var dagreD3graph = new dagreD3.graphlib.Graph({
          compound : true
        }).setGraph({}).setDefaultEdgeLabel(function() {
          return {};
        });

        dag.nodes.forEach(function(node) {

          if (node.clazz !== "cluster") {
            if (typeof node_name_variant_index !== "undefined") {
              if (node_name_variant_index == 0) {
                node.value.label = node.value.labelShort;
              } else if (node_name_variant_index == 1) {
                node.value.label = node.value.labelMedium;
              } else {
                node.value.label = node.value.labelFull;
              }
            }
          } else {
            node.value.label = node.name;
          }
          
          if (node.parent && _.find(dag.nodes, function(n) { return n.id == node.parent; })) {
            dagreD3graph.setParent(node.id, node.parent);
          }
          dagreD3graph.setNode(node.id, node.value);
        });

        dag.links.forEach(function(link) {
          if (!link.value) {
            link.value = {};
          }
          link.value['curve'] = d3.curveBasis;
          dagreD3graph.setEdge(link.u, link.v, link.value);
        });

        return dagreD3graph;
      };

      var dagreD3graph = createGraph(dagClone);

      dagreD3graph.nodes().forEach(function(nodeId) {
        var node = dagreD3graph.node(nodeId);
        if (node) {
          node.id = nodeId;
          // round the corners of the nodes
          node.rx = node.ry = 6;
        }
      });

      var localNodeMap = {};
      $.each(dagClone.nodes, function(index, node) {
        localNodeMap[node.id] = node;
      });

      // create the renderer
      var render = new dagreD3.render();

      // run the renderer; this is what draws the final graph.
      render(innerSvgGroupElement, dagreD3graph);

      dagreD3graph.nodes().forEach(function(nodeId) {
        var node = localNodeMap[nodeId];
        if (node) {
          // label
          if (node.value && node.value.label) {
            var $node = $('g.node#' + nodeId);
            if ($node) {
              $node.attr('name', node.value.label);
            }
          }
        }
      });
      
      resizeGraph(dagreD3graph, dagSvgElement);
      
      setTimeout(function() {
        wireGraph2Table(dag.id.name);
      }, 1000);
      
      return dagreD3graph;
    };

    
    var resizeGraph = function(dagreD3graph, dagSvgElement) {
      if (typeof dagreD3graph === "undefined") {
        return;
      }
      // grab elements
      var $svgElement            = dagSvgElement.find('svg');
      var $svgParent             = $svgElement.parent();
      var $svgParentParent       = $svgParent.parent();
      var $svgParentParentParent = $svgParentParent.parent();
      var outerSvgGroupElement   = $svgElement.children('g').get(0);
      var innerSvgGroupElement   = $svgElement.children('g').children('g').get(0);
      var d3outerSvgGroupElement = d3.select(outerSvgGroupElement);
      var d3innerSvgGroupElement = d3.select(innerSvgGroupElement);
      
      if ($svgParent.width() == 0) {
        return;
      }
      
      $svgParentParent.css( {
        position : "absolute",
        width    : $svgParentParentParent.width()+"px",
      });
      var horzMargin = 40;
      
      $svgParent.css({
        position : "relative",
        left     : -Math.ceil($("body .container").offset().left - horzMargin)+"px",
        top      : "0",
        width    : Math.ceil($("body" ).width() - (3*horzMargin) )+"px",
        height   : "auto",
      });
      
      // MUST READ : http://www.justinmccandless.com/demos/viewbox/index.html
      // set margins and center the thing
      var viewbox = {
          x      : -(($svgParent.width()-dagreD3graph.graph().width) / 2),
          y      : -(horzMargin),
          width  : Math.max(100, $svgParent.width()-(2*horzMargin)),
          height : Math.max(100, dagreD3graph.graph().height + (2*horzMargin)),
      }
      var viewboxAsString = _.map(viewbox, function(value, key){ return Math.ceil(value); }).join(' ');
      $svgElement.attr({
        width               : "100%",
        height              : "100%",
        viewBox             : viewboxAsString,
        preserveAspectRatio : "xMidYMin meet",
      });
      
      var setParentHeight = function(scale) {
        var h         = scale * dagreD3graph.graph().height;
        var newHeight = Math.ceil(Math.max(h, 100));
        
        $svgParentParentParent.height((newHeight + parseInt($svgParentParent.css('padding-top'))+ parseInt($svgParentParent.css('padding-bottom'))) + "px");
        $svgParent.height(newHeight + "px");
      }
      
      var scale = 1;
      setParentHeight(scale);
      
      // ################################################

      d3.select(dagSvgElement.get(0)).call(
          d3.zoom()
            .scaleExtent([1 / 8, 2])
            .on("zoom", zoomed));

      function zoomed() {
        // console.log(d3.event.transform);
        d3innerSvgGroupElement.attr("transform", d3.event.transform);
        if (d3.event && d3.event.sourceEvent) {
          d3.event.sourceEvent.stopPropagation();
        }
      }
      // ################################################

    };
    
    return {
        renderGraph : renderGraph,
        resizeGraph : resizeGraph,
        putTheStuffMan : putTheStuffMan
    };
  })();
})();
