<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" trimDirectiveWhitespaces="true"%>
<%@ taglib prefix="c"  uri="http://java.sun.com/jsp/jstl/core"          %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"     %>
<%@ taglib prefix="t"  uri="http://net.aequologica.neo/jsp/jstl/layout" %>
<%@ taglib prefix="l"  uri="http://net.aequologica.neo/jsp/jstl/title"  %>
<t:layout jsmodules="angular moment handlebars">

<script id="handlebars_messages" type="text/x-handlebars-template"><ul>{{#each this}}
  <li>
    <ul>{{#each this}}
      <li>
        <strong>{{@key}}</strong> 
        <ul>{{#each this}}
          <li>
            <ul>{{#each this}}
              <li>
                <span>{{@key}}:</span>
                <span>«&nbsp;<i>{{this}}</i>&nbsp;»</span>
              </li>
            {{/each}}</ul>
          </li>
        {{/each}}</ul>
      </li>
    {{/each}}</ul>
  </li>
{{/each}}</ul></script>

<style>
ul {
  list-style-type: none;
}

span#back_to_index {
  white-space: nowrap;
  overflow: hidden;
}

#alert ul {
  list-style-type: none;
  padding: 0;
}
</style>

<c:if test="${empty pageContext.request.remoteUser}">
  <div id="please_log_in" class="alert alert-info">
    <span class="label label-info">info</span>
    <span><a href="<c:url value='/modules/login.jsp'/>#/api/dagr/v1/views/dags"><span><i class="shaky fas fa-sign-in-alt"></i>&nbsp;Sign in</span></a> to get the list of DAGs</span>
  </div>
</c:if>

<c:if test="${not empty pageContext.request.remoteUser}">
  <div data-ng-app="ngAppDAGs">
    <div class="row">
      <div class="col-lg-12">
        <l:title value="DAG list"/>
      </div>
    </div>
    <div class="row" >
      <form  data-ng-controller="DAGsCtrl">
        <ul class="unstyled col-lg-12">
          <li data-ng-repeat="dagInfo in dagInfos| orderBy:'name'" >
            <a href="<c:url value='/api/dagr/v1/views/dags/'/>{{dagInfo.name}}" style="border-bottom: 1px dashed #999;">
              <span ng-style="{'font-weight' : ($parent.curdag == dagInfo.name ? 'bold' : 'inherit')}">{{dagInfo.label || dagInfo.name}}</span>
            </a>
          </li>
        </ul>
      </form>
    </div>
    <div class="row"  data-ng-controller="goCtrl">
      <div class="col-lg-12">
        <div class="btn-group btn-group-md" role="group" aria-label="...">
          <button id="reload" type="button" class="btn btn-outline-secondary btn-sm">
            <span>
              reload DAGs
              <i class="shaky fas fa-sync"></i>
            </span>
          </button>
          &nbsp;
          <button id="directory" type="button" class="btn btn-outline-secondary btn-sm" 
            ng-click="go()">
            <span>
              open DAGs directory
              <i class="shaky fas fa-external-link-alt"></i>
            </span>
          </button>
        </div>
      </div>
    </div>
  </div>

  <div id="messages" style="padding: 1em 0 0 0;"></div>
  <div id="alert" class="alert alert-dismissable" style="display: none;">
    <button type="button" class="close" data-dismiss="alert">&times;</button>
  </div>
</c:if>

</t:layout>

<c:if test="${not empty pageContext.request.remoteUser}">

<script type="text/javascript" src='<c:url value="/modules/dagr/scripts/dag-list-reload-dags.js"/>'></script>

<script type="text/javascript">
  angular.module('ngAppDAGs', [
      'angular-loading-bar', 'LocalStorageModule'
  ]).config(function(cfpLoadingBarProvider) {
    cfpLoadingBarProvider.includeSpinner = true;
  }).config(function(localStorageServiceProvider) {
    localStorageServiceProvider.setPrefix('dagr');
  }).config(function($locationProvider) {
    $locationProvider.html5Mode({
      enabled      : true, 
      requireBase  : false,
      rewriteLinks : false
    });
  }).controller('goCtrl', function($scope, $window) {
    $scope.go = function() {
      $window.open('<c:url value="/api/geppaequo/stnemucod/v1/html/dags"/>', '_DAGsDirectory');
    } 
  }).controller('DAGsCtrl', function($scope, $http, localStorageService, $location) {
    $scope.dagInfos = [];
    $scope.curdag = undefined;

    var load = function() {
      $http({
        method : 'GET',
        url : "<c:url value='/api/dagr/v1/dags' />",
      }).then(function successCallback(response) {
        // cf. https://docs.angularjs.org/api/ng/service/$http
        // this callback will be called asynchronously
        // when the response is available
        $scope.dagInfos = response.data;
        $scope.curdag = localStorageService.get("dag");
      }, function errorCallback(response) {
        // called asynchronously if an error occurs
        // or server returns response with an error status.
        $scope.dagInfos = [];
        $scope.curdag = undefined;
      });
    }

    load();

    dagrReload('<c:url value="/"/>', function() {
      load();
    });
    
  });
</script>

</c:if>