;(function(){
  
  /////////////////////////////////////////////////////////////////////////////
  // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
  function tryParseJSON(hypotheticalJSON){
    try {
        var o = JSON.parse(hypotheticalJSON);

        // Handle non-exception-throwing cases:
        // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
        // but... JSON.parse(null) returns 'null', and typeof null === "object", 
        // so we must check for that, too.
        if (o && typeof o === "object" && o !== null) {
            return o;
        }
    } catch (e) { 
    }

    return false;
  };

  ///////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('dagWebsocket2', ['$websocket', function($websocket){
    
    var controller = ['$scope', '$interval', function ($scope, $interval) {
      if (!$scope.dagInfo) {
        return;
      }
      
      var thisScope = "RELEASE";
      
      $scope.ws2 = (function () {
        
        // Open a WebSocket connection
        var url  = $scope.jevaispasmefairechierWS + 'patata/' + $scope.dagInfo.name + '/patati/' + thisScope;
        
        window.log(thisScope, "opening dag websocket from", url);
        
        var dagWebsocketDataStream = $websocket(url);

        var collection = [];

        dagWebsocketDataStream.onClose(function() {
          window.log(thisScope, 'closing dag websocket');
          dagWebsocketDataStream = null;
        });

        dagWebsocketDataStream.onError(function() {
          window.log(thisScope, 'error in dag websocket');
          dagWebsocketDataStream = null;
        });
        
        dagWebsocketDataStream.onMessage(function(atmosphereMessage) {
          
          // window.log(thisScope, atmosphereMessage);
          
          if (atmosphereMessage.type == "message" && atmosphereMessage.data == 'X') {
            window.log(thisScope, 'received heartbeat');
            return;
          }

          var message = atmosphereMessage.data;
          var parsed = tryParseJSON(message)
          if (parsed && parsed.cleaner && parsed.cleaner.scope == thisScope) {
            if ($scope.dagInfo.scope == thisScope) {
              // visual update
              DAGRE_D3_HELPER.putTheStuffMan(parsed.cleaner.node.id, $scope.gimmethestuff, parsed.cleaner.state);
            }
            
            // the dag we are enclosed in may not have been yet initialized (e.g. hidden tab), $scope.nodeMap will not be here
            if (typeof $scope.nodeMap !== "undefined" && $scope.nodeMap != null) {
            
              var node = $scope.nodeMap[parsed.cleaner.node.id];
              
              if (typeof node !== "undefined" && node != null) {
                var cleaner  = $scope.dagInfo.nodeCleaners[thisScope][node.id];
                var oldState = cleaner.state;
                var newState = parsed.cleaner.state;
              
                if (true /*oldState != newState*/) {
                  window.log(thisScope, node.name, 'from', oldState, 'to', newState);
                  $scope.rebuild.setFeedback(node.name + ' changed from '+ oldState + ' to '+ newState);
                  // 
                  // CLEAN 
                  // DIRTY 
                  // CLEANING_ORDERED
                  // BEING_CLEANED
                  // CLEANED
                  // FAIL
                  // ABORTED
                  // UNCLEANABLE
                  // 
                  if (newState == 'BEING_CLEANED') {
                    cleaner.onCleaningStarted(parsed.cleaner.id);
                  } else if (newState == 'UNCLEANABLE') {
                    cleaner.onCleaningStopped();
                    cleaner.cleanStatusImgUrl = $scope.clean_uncleanable_svg_url;
                  } else if (oldState == 'BEING_CLEANED') {
                    cleaner.onCleaningStopped();
                    if (newState == "CLEAN" || newState == "CLEANED") { // no need to refresh snapshot if not clean
                      $scope.refreshSnapshot(node);
                      cleaner.cleanStatusImgUrl = $scope.clean_passing_svg_url;
                    } if (newState == "FAIL") {
                      cleaner.cleanStatusImgUrl = $scope.clean_failing_svg_url;
                    } if (newState == "ABORTED") {
                      cleaner.cleanStatusImgUrl = $scope.clean_aborted_svg_url;
                    }
                  }

                  cleaner.scope = thisScope;
                  cleaner.state = newState;
                }
                
              }
            }

            collection.push(parsed);
          } else {
            collection.push(message);
          }
        }); // dagWebsocketDataStream.onMessage
        
        var myTimer    = undefined;
        var states     = $scope.gimmethestuff;
        var stateIndex = 0;
        
        // https://gist.github.com/jed/982883
        var UUID = function b(
            a                  // placeholder
          ){
            return a           // if the placeholder was passed, return
              ? (              // a random number from 0 to 15
                a ^            // unless b is 8,
                Math.random()  // in which case
                * 16           // a random number from
                >> a/4         // 8 to 11
                ).toString(16) // in hexadecimal
              : (              // or otherwise a concatenated string:
                [1e7] +        // 10000000 +
                -1e3 +         // -1000 +
                -4e3 +         // -4000 +
                -8e3 +         // -80000000 +
                -1e11          // -100000000000,
                ).replace(     // replacing
                  /[018]/g,    // zeroes, ones, and eights with
                  b            // random hex digits
                )
          }

        startSendingRandomStateChanges = function() {
          if ( angular.isDefined(myTimer) ) return;

          var nodes  = $scope.topological;
          var uuid   = UUID();
          var sendor = function() {

            if (!dagWebsocketDataStream) return;
            
            var node = nodes[Math.floor(Math.random()*nodes.length)];

            var message = {
              cleaner : {
                node : {
                  id   : node.id,
                  name : node.name,
                },
                id    : uuid,
                scope : thisScope,
                state : states[++stateIndex%states.length]
              }
            }; 

            dagWebsocketDataStream.send( JSON.stringify( message ) );
          };

          myTimer = $interval(sendor, 500);
        };
        
        stopSendingRandomStateChanges = function() {
          if ( angular.isDefined(myTimer) ) {
            $interval.cancel(myTimer);
            myTimer = undefined;
          }
          collection.length = 0;
        }
        
        toggleSimulate = function() {
          if ($scope.topological.length > 0) {
            var cleaner = $scope.dagInfo.nodeCleaners[thisScope][$scope.topological[0].id];
            if (cleaner) {
              if (cleaner.state != 'BEING_CLEANED') {
                cleaner.state = 'BEING_CLEANED';
                if (cleaner.progress) cleaner.progress.startProgress(10000, 3333);
                window.log(thisScope, "start simulate");
              } else {
                cleaner.state = 'CLEAN';
                if (cleaner.progress) cleaner.progress.resetProgress();
                window.log(thisScope, "stop simulate");
              }
            } else {
              window.log("cannot find cleaner", $scope.dagInfo.nodeCleaners, thisScope, $scope.topological[0].id);
            }
          }
        };
        
        return {
          id : thisScope,
          show : false,
          collection : collection,
          toggleSimulate : toggleSimulate,
          startSendingRandomStateChanges : startSendingRandomStateChanges,
          stopSendingRandomStateChanges : stopSendingRandomStateChanges,
        }
      })();
      
    }]; // end of controller def
    
    return {
      restrict    : 'E',
      templateUrl : Geppaequo.contextPath + 'modules/dagr/templates/dag-websocket2.html',
      controller  : controller
    };
  }]);

})();
