;(function() {

  /////////////////////////////////////////////////////////////////////////////
  // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
  function tryParseJSON(hypotheticalJSON) {
    try {
      var o = JSON.parse(hypotheticalJSON);

      // Handle non-exception-throwing cases:
      // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
      // but... JSON.parse(null) returns 'null', and typeof null === "object", 
      // so we must check for that, too.
      if (o && typeof o === "object" && o !== null) {
        return o;
      }
    } catch (e) {
    }

    return false;
  }
  ;

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive(
      'dag',
      [
        function() {

          // 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
          var controller = [
              '$scope',
              'Restangular',
              '$websocket',
              function($scope, Restangular, $websocket) {

                $scope.dag = {};

                displayError = function(response, err, display) {
                  err = $scope.enhanceError(err, response);
                  display(err);
                }

                $scope.downloadDAG = function() {
                  window.location.href = $scope.dagInfo.downloadURL;
                }

                $scope.reloadDAG = function() {
                  dagReloadResource = Restangular.one('reload', $scope.dagInfo.name);
                  dagReloadResourcePromise = dagReloadResource.post();
                  dagReloadResourcePromise.then(function() { // 204 no content

                    window.location.reload(); // while waiting for : $scope.dagInfo.reload();

                    $scope.loaded = false;
                    $scope.loadOnce();
                    $('#tip').html("<i>" + $scope.dagInfo.name + "</i> reloaded!").show();
                  }, function(response) {
                    $('#tip').text(response.status + " - " + response.data.error).show();
                  });
                }

                // 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 
                $scope.loaded = false;
                $scope.loading = false;
                $scope.loadOnce = function() {

                  if (!$scope.dagInfo) {
                    return;
                  }

                  if ($scope.loaded || $scope.loading) {
                    return;
                  }
                  $scope.loading = true;

                  $scope.hideCleaner = !$scope.dagInfo.cleaner.urlobj.host;

                  var dagRestResource;
                  var dagRestResourcePromise;

                  dagRestResource = Restangular.one('dags', $scope.dagInfo.name);
                  if ($scope.dagInfo.subDagId) {
                    dagRestResource = dagRestResource.one('subs', $scope.dagInfo.subDagId);
                  }
                  dagRestResourcePromise = dagRestResource.get({
                    order : $scope.dagInfo.order
                  });

                  // 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3  
                  dagRestResourcePromise.then(function(dag) {

                    var nodeArray = [];

                    dag.nodes.forEach(function(node) {
                      if (node.clazz !== "cluster") {
                        nodeArray.push(node);
                      }
                    });

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    var getSubDags = function() {
                      // cf. http://stackoverflow.com/questions/13304543/javascript-sort-array-based-on-another-array
                      $scope.subDags = [];
                      var subDagsRestResource = Restangular.one('dags', $scope.dagInfo.name)
                                                           .one('subs');
                      subDagsRestResource.get().then(function(subs) {
                        subs.forEach(function(sub) {
                          sub.go = function() {
                            window.location.replace($scope.jevaispasmefairechierHTTP + "api/dagr/v1/dags/"+$scope.dagInfo.name+"/subs/"+sub.id);
                          };
                        });
                        $scope.subDags = subs;
                      });
                    }
                    getSubDags();
                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    var setTopo = function(topo) {
                      // cf. http://stackoverflow.com/questions/13304543/javascript-sort-array-based-on-another-array
                      $scope.topological = (function(items, sorted) {
                        var result = [];
                        sorted.forEach(function(key) {
                          var found = false;
                          items = items.filter(function(item) {
                            if (!found && item.id == key) {
                              result.push(item);
                              found = true;
                              return false;
                            } else {
                              return true;
                            }
                          });
                        });
                        return result;
                      }(nodeArray, topo));
                    }

                    // load topological sort
                    if (!dag.topologicalNodeIds) {
                      var topologicalSortRestResource = Restangular.one('dags', $scope.dagInfo.name)
                                                                   .one('topological');
                      topologicalSortRestResource.get().then(function(topo) {
                        setTopo(topo);
                        $scope.loaded = true;
                        $scope.loading = false;
                      });
                    } else {
                      setTopo(dag.topologicalNodeIds);
                      $scope.loaded = true;
                      $scope.loading = false;
                    }
                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 

                    var nodeMap = {};
                    nodeArray.forEach(function(node) {
                      nodeMap[node.id] = node;
                      node.selected = false;
                      node.predecessors = [];
                      node.successors = [];
                    });
                    $scope.nodeWhosePredecessorsShallBeShown = null;
                    $scope.nodeWhoseSuccessorsShallBeShown = null;
                    $scope.nodeMap = nodeMap;

                    var clusterCount = 0;

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    dag.nodes.forEach(function(node) {
 
                      node.dagName = dag.id.name;
                      
                      node.getCleaner = function () {
                        return $scope.dagInfo.nodeCleaners[$scope.dagInfo.scope][node.id];
                      };
                      
                      node.jobName = node.name;
                      if ( $scope.dagInfo.cleaner &&  $scope.dagInfo.cleaner.jobNameTemplate) {
                        var template = Handlebars.compile( $scope.dagInfo.cleaner.jobNameTemplate);
                        node.jobName = template({
                          node : node,
                          dag : dag
                        });
                      }

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // cluster ?
                      {
                        if (node.clazz == "cluster") {
                          clusterCount = clusterCount + 1;
                          if (!node.value) {
                            node.value = {};
                          }
                          node.value.clusterLabelPos = 'top';
                        }
                      } // cluster ?
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5
                      // get GAV
                      {
                        node.gav = gatcvs(node.value && node.value.gucrid ? node.value.gucrid : null);
                      }

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup short (artifactId) and medium (artifactId+version) and full (groupId+artifactId+version)labels
                      {

                        if (typeof node.value == "undefined" || node.value == null) {
                          node.value = {};
                        }

                        node.value.labelShort = node.name

                        if (node.gav.ok()) {
                          node.value.labelFull = node.gav.g + ' ' + node.gav.a + ' ' + node.gav.v;
                          node.value.labelMedium = node.gav.a + ' ' + node.gav.v;

                        } else {
                          node.value.labelFull = node.value.label || node.value.labelShort;

                          var name = node.value.labelFull;
                          var version = "";

                          var labelFullSplit = node.value.labelFull.split(' ');
                          if (labelFullSplit.length > 1) {
                            name = labelFullSplit.shift();
                            version = labelFullSplit.join(' ');
                          }

                          var shortName = name;
                          var lastDot = name.lastIndexOf('.');
                          if (lastDot != -1) {
                            shortName = name.substr(lastDot + 1);
                          }
                          node.value.labelMedium = shortName + ' ' + version;
                        }
                      } // setup short and medium and full labels
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup scm
                      {
                        node.value.giturl = parseGitUrl({
                          scm : node.value.scm,
                          commit : node.value.commit,
                          shortMessage : node.value.shortMessage,
                        });
                        if (node.value.branch) {
                          if (node.value.branch.match(/^[0-9a-f]{40}$/) != null) {
                            node.shortbranch = node.value.giturl.hash;
                          } else {
                            node.shortbranch = node.value.branch.replace(/^refs\/heads\//gi, "");
                          }
                        }
                      } // setup scm

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup gatcvs
                      {
                        if (node.gav.ok()) {
                          if (!node.value.scm) {
                            var shortgav = node.gav.g.replace(/net\.(.*)\.neo/g, "$1");
                            node.reponame = shortgav + "/" + node.gav.a;
                          } else {
                            node.reponame = node.value.giturl.slug;
                          }
                          node.repoid = node.reponame.replace(/\//g, "_");
                        } else {
                          node.gav = {
                            a : node.value.labelFull
                          };
                        }
                      } // setup gatcvs
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup jenkins 
                      if ($scope.dagInfo.cleaner && $scope.dagInfo.cleaner.type == "jenkins") {

                        node.slug = 'job' + "/" + node.jobName;
                        var lastBuildUrl = $scope.dagInfo.cleaner.url + "/" + node.slug + "/lastBuild/api/json";
                        var ajaxSettings = {
                          url : lastBuildUrl,
                          headers : {
                            'Accept' : 'application/json'
                          }
                        };
                        if ($scope.dagInfo.cleaner.authorizationHeader) {
                          ajaxSettings.beforeSend = function(request) {
                            request.setRequestHeader("Authorization", $scope.dagInfo.cleaner.authorizationHeader);
                          }
                        }
                        $.ajax(ajaxSettings).fail(function(data) {
                          node.foundJob = false;
                        }).done(function(data) {
                          node.foundJob = true;
                          // the true jenkins doc : https://github.com/jenkinsci/jenkins/blob/master/core/src/main/java/hudson/model/Result.java
                          // 
                          // SUCCESS
                          // UNSTABLE
                          // FAILURE
                          // NOT_BUILT
                          // ABORTED
                          // 

                          var cleaner = $scope.dagInfo.nodeCleaners[$scope.dagInfo.scope][node.id];
                          if (cleaner) {
                              if (data.result == "SUCCESS" || data.result == "UNSTABLE") {
                                cleaner.cleanStatusImgUrl = $scope.clean_passing_svg_url;
                              } else if (data.result == "FAILURE") {
                                cleaner.cleanStatusImgUrl = $scope.clean_failing_svg_url;
                              } else if (data.result == "ABORTED") {
                                cleaner.cleanStatusImgUrl = $scope.clean_aborted_svg_url;
                              } else if (data.result == "UNCLEANABLE") { // will never, ever, get this from state from jenkins
                                cleaner.cleanStatusImgUrl = $scope.clean_uncleanable_svg_url;
                              } else {
                                cleaner.cleanStatusImgUrl = $scope.clean_unknown_svg_url;
                                // cleaner.cleanStatusImgUrl = undefined;
                              }
                          }
                        });
                      }
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                      // setup travis 
                      if ($scope.dagInfo.cleaner && $scope.dagInfo.cleaner.type == "travis") {

                        var cleaner = $scope.dagInfo.nodeCleaners[$scope.dagInfo.scope][node.id];
                        if (node.value && node.value.giturl && node.value.giturl.slug) {
                          node.slug = node.value.giturl.slug;
                        } else {
                          node.slug = dag.id.name + "/" + node.jobName;
                        }
                        if (cleaner && $scope.dagInfo.cleaner.url && node.shortbranch) {
                          cleaner.cleanStatusImgUrl = $scope.dagInfo.cleaner.url + "/" + node.slug + ".svg?branch=" + node.shortbranch + "#" + (new Date().getTime().toString());
                        }
                        var travisURL;
                        if ($scope.dagInfo.cleaner.urlWorkAroundCORS) {
                          travisURL = $scope.jevaispasmefairechierHTTP + $scope.dagInfo.cleaner.urlWorkAroundCORS + "/repos/" + node.slug + "/branches";
                        }

                        if (travisURL) {
                          var ajaxSettings = {
                            url : travisURL,
                            crossDomain : true,
                            headers : {
                              'Accept' : 'application/vnd.travis-ci.2+json'
                            }
                          };
                          if ($scope.dagInfo.cleaner.authorizationHeader) {
                            ajaxSettings.beforeSend = function(request) {
                              request.setRequestHeader("Authorization", $scope.dagInfo.cleaner.authorizationHeader);
                            }
                          }
                          $.ajax(ajaxSettings).fail(function(data) {
                            node.travis = false;
                          }).done(function(data) {
                            node.travis = true;
                            //
                            var foundJob = null;
                            {
                              // search in commits array for the branch
                              var foundCommit = null;
                              {
                                for (var ccc = 0; ccc < data.commits.length; ccc++) {
                                  if (data.commits[ccc].branch == node.shortbranch) {
                                    foundCommit = data.commits[ccc].id;
                                    break;
                                  }
                                }
                              }
                              if (foundCommit != null) {
                                // search in branch array for the job
                                for (var bbb = 0; bbb < data.branches.length; bbb++) {
                                  if (data.branches[bbb].commit_id == foundCommit) {
                                    if (data.branches[bbb].job_ids.length) {
                                      foundJob = data.branches[bbb].job_ids[0];
                                      if (cleaner && !cleaner.cleanStatusImgUrl) {
                                        var jobState = data.branches[bbb].state;
                                        if (jobState == "passed" || jobState == "created" || jobState == "started") {
                                          cleaner.cleanStatusImgUrl = $scope.clean_passing_svg_url;
                                        } else if (jobState == "failed") {
                                          cleaner.cleanStatusImgUrl = $scope.clean_failing_svg_url;
                                        } else if (jobState == "canceled") {
                                          cleaner.cleanStatusImgUrl = $scope.clean_aborted_svg_url;
                                        } else {
                                          cleaner.cleanStatusImgUrl = $scope.clean_unknown_svg_url;
                                          // cleaner.cleanStatusImgUrl = undefined;
                                        }
                                      }
                                      break;
                                    }
                                  }
                                }
                              }
                            }
                            if (foundJob != null) {
                              node.foundJob = foundJob;
                            }
                          });
                        }
                      } // setup travis
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 

                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5
                      if ($scope.refreshSnapshot) $scope.refreshSnapshot(node);
                      if ($scope.refreshRelease ) $scope.refreshRelease(node);
                      // 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 
                    }); // dag.nodes.forEach

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    if (clusterCount > 1) {
                      // cf. http://tools.medialab.sciences-po.fr/iwanthue/
                      var colors = [
                          "#3CF7BD", "#D118AB", "#6E3904", "#A6BCE6", "#C2E12C", "#0A5BC6", "#E493AB", "#D6F3B7", "#316B7B", "#289870", "#53327D", "#9C1D1D"
                      ];
                      var color = 0;
                      dag.nodes.forEach(function(node) {
                        if (node.clazz == "cluster") {
                          node.value.style = "fill: " + colors[(color++) % colors.length];
                        }
                      });
                    } // if (clusterCount > 1 ) {

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    dag.links.forEach(function(edge) {
                      if (typeof edge.value === "undefined" || edge.value == null) {
                        edge.value = {};
                      }
                      if (edge.clazz) {
                        edge.value["class"] = edge.clazz;
                        edge.value.arrowheadClass = edge.clazz;
                      }
                      edge.value.lineInterpolate = 'basis';
                      edge.value.arrowhead = 'vee'; // 'normal'; //  

                      var clazz = (edge.clazz == "default" ? 'direct' : edge.clazz);
                      $scope.nodeMap[edge.u].successors.push({
                        id : $scope.nodeMap[edge.v].id,
                        name : $scope.nodeMap[edge.v].name,
                        clazz : clazz
                      });
                      $scope.nodeMap[edge.v].predecessors.push({
                        id : $scope.nodeMap[edge.u].id,
                        name : $scope.nodeMap[edge.u].name,
                        clazz : clazz
                      });

                    }); // dag.links.forEach(function(edge) {

                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 
                    $scope.askCleanerToclean = function(node) {
                      window.log("no cleaner");
                      return;
                    };
                    if ($scope.dagInfo.cleaner && ($scope.dagInfo.cleaner.type == "jenkins" || $scope.dagInfo.cleaner.type == "travis")) {
                      $scope.askCleanerToclean = function(node) {
                        var buildNode = Restangular .one('dags',  $scope.dagInfo.name)
                                                    .one('buses', $scope.dagInfo.scope)
                                                    .one('nodes', node.name);
                        buildNode.patch({}).then(function(json) {
                          window.log('request for cleaning of node ' + node.name + ' was accepted.');
                        }, function(response) {
                          displayError(response, 'unable to request cleaning of node ' + node.name, function(enhancedErrorText) {
                            $scope.rebuild.setError(enhancedErrorText);
                          });
                        });
                      }
                    }
                    // 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 

                    $scope.dag = dag;

                    ///////////////////////////////////////////////
                    var visibleNodes         = {}; // none means all
                    var visibleSelectedNodes = [];
                    $scope.disableSubButton  = true;

                    $scope.isVisible = function(node) {
                      if (_.isEmpty(visibleNodes)) {
                        return true;
                      }
                      return visibleNodes[node.id];
                    };
                    
                    hasClazz = function(node, clazz) {
                      if (_.isEmpty(visibleNodes)) {
                        return false;
                      }
                      return visibleNodes[node.id] == clazz;
                    };

                    $scope.nodeClasses = function(node) {
                      var classes = "";
                      if ($scope.isVisible(node)) {
                        classes = classes + " _visible_";
                      } else {
                        classes = classes + " _dimmed_";
                      }
                      if (hasClazz(node, 'direct')) {
                        classes = classes + " _direct_";
                      }
                      if (hasClazz(node, 'parent')) {
                        classes = classes + " _parent_";
                      }
                      if (node.selected) {
                        classes = classes + " _selected_";
                      }
                      return classes;
                    }

                    calcVisibleAndSelected = function() {
                      var set;
                      if (_.isEmpty(visibleNodes)) {
                        set = nodeArray;
                      } else {
                        set = _.filter(nodeArray, function(node) {
                          return visibleNodes[node.id] !== undefined;
                        });
                      }
                      visibleSelectedNodes = _.filter(
                          set, 
                          function(node) {
                            return node.selected;
                          }
                      );
                      $scope.disableSubButton = visibleSelectedNodes.length == 0 || visibleSelectedNodes.length == nodeArray.length;
                      return visibleSelectedNodes;
                    };

                    calcVisibleAndSelected();
                    
                    $scope.toggleAllVisibleNodes = function() {
                      var atLeastOne = visibleSelectedNodes.length > 0;
                      nodeArray.forEach(function(node) {
                        if ($scope.isVisible(node)) {
                          setSelected( node, !atLeastOne);
                        }
                      });
                      calcVisibleAndSelected();
                    };

                    setSelected = function(node, selected, noRefresh) {
                      node.selected = selected;
                      if (node.selected) {
                        DAGRE_D3_HELPER.putTheStuffMan( node.id, [], ["_selected_"] );
                      } else {
                        DAGRE_D3_HELPER.putTheStuffMan( node.id, ["_selected_"], [] );
                      }
                      if (!noRefresh) {
                        calcVisibleAndSelected();
                      }
                    };

                    $scope.toggleSelected = function(node) {
                      setSelected( node, !node.selected);
                    };
                    
                    $scope.back2dag = function() {
                      window.location.replace($scope.jevaispasmefairechierHTTP + "api/dagr/v1/dags/"+$scope.dagInfo.name);
                    };
                    
                    $scope.go2sub = function() {
                      // create subdag
                      var thisDag = Restangular.one('dags', $scope.dagInfo.name);
                      var selectedNodes = _.map(visibleSelectedNodes, 'name');
                      $scope.subdag = {};
                      thisDag.post('subs', selectedNodes, undefined, {
                        'Content-Type' : 'application/json'
                      }).then(function(subDagKey) {
                        window.log(subDagKey);
                        window.location.replace($scope.jevaispasmefairechierHTTP + "api/dagr/v1/dags/"+$scope.dagInfo.name+"/subs/"+subDagKey);
                      }, function(response) {
                        displayError(response, 'unable to create subDag for [' + selectedNodes + ']', function(enhancedErrorText) {
                          $scope.subdag.error = enhancedErrorText;
                        });
                      });                      
                    }

                    showPredecessors = function(node) {
                      visibleNodes = {}; // none means all
                      if (node) {
                        visibleNodes[node.id] = "checked";
                        node.predecessors.forEach(function(p) {
                          window.log('/' + node.name + '/', node.id, 'predecessor :', '/' + p.name + '/', p.id, '(' + p.clazz + ')');
                          visibleNodes[p.id] = p.clazz;
                        });
                      }
                      calcVisibleAndSelected();
                    };

                    $scope.togglePredecessors = function(node) {
                      $scope.nodeWhoseSuccessorsShallBeShown = null;
                      if (node == $scope.nodeWhosePredecessorsShallBeShown) {
                        $scope.nodeWhosePredecessorsShallBeShown = null;
                      } else {
                        $scope.nodeWhosePredecessorsShallBeShown = node;
                      }
                      showPredecessors($scope.nodeWhosePredecessorsShallBeShown);
                    };

                    showSuccessors = function(node) {
                      visibleNodes = {}; // none means all
                      if (node) {
                        visibleNodes[node.id] = "checked";
                        node.successors.forEach(function(p) {
                          window.log('/' + node.name + '/', node.id, 'predecessor :', '/' + p.name + '/', p.id, '(' + p.clazz + ')');
                          visibleNodes[p.id] = p.clazz;
                        });
                      }
                      calcVisibleAndSelected();
                    };

                    $scope.toggleSuccessors = function(node) {
                      $scope.nodeWhosePredecessorsShallBeShown = null;
                      if (node == $scope.nodeWhoseSuccessorsShallBeShown) {
                        $scope.nodeWhoseSuccessorsShallBeShown = null;
                      } else {
                        $scope.nodeWhoseSuccessorsShallBeShown = node;
                      }
                      showSuccessors($scope.nodeWhoseSuccessorsShallBeShown);
                    };

                    ///////////////////////////////////////////////

                    $scope.cleanNode = function(node) {
                      var setNodeStateRes = Restangular.one('dags',   $scope.dagInfo.name)
                                                       .one('buses',  $scope.dagInfo.scope)
                                                       .one('nodes',  node.name)
                                                       .one('states', 'CLEAN');

                      setNodeStateRes.patch({}, undefined, {
                        'Content-Type' : 'text/plain'
                      }).then(function(json) {
                        window.log('sent patch request to force node ' + node.name + ' state to CLEAN');
                      }, function(response) {
                        if (response.status == 304) {
                          window.log('node ' + node.name + ' was alread in CLEAN state - not modified');
                        } else {
                          window.log('faild to force node ' + node.name + ' to CLEAN state - not modified' + response.data.error);
                        }
                      });
                    };

                    $scope.cleanAllNodes = function() {
                      $scope.topological.forEach(function(node) {
                        $scope.cleanNode(node);
                      })
                    }
                    
                    DAGRE_D3_HELPER.renderGraph($scope.dag, $( "#theDagSVG" ), $scope.node_name_variant_index);

                  }); // dagRestResource.get().then
                  // 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3  

                } // $scope.loadOnce = function() {
                // 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 

                $scope.loadOnce();

              }
          ]; // controller definition
          // 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 

          return {
            restrict : 'E',
            controller : controller,
            link : function($scope, $element, attr) {
              $scope.$watch(attr.ngShow, function() {
                if (!attr.ngShow) {
                  return;
                }
                if (attr.ngShow) {
                  $scope.loadOnce();
                }
              });
            }
          };

        }
      ]); // angular.module('dagsApplication').directive('dag', [function(){

  /////////////////////////////////////////////////////////////////////////////
  function gatcvs(str) {
    var _this_ = {};

    function isok(x) {
      if (typeof x === "undefined" || x === null || x.length === 0) {
        return false;
      }
      return true;
    }

    // 
    // g    Group id of the artifact (theoretically optional, but Required in practice)
    // a    Artifact id of the artifact (Required)
    // t    Type of the artifact (Required)
    // c    Classifier of the artifact (Optional)
    // v    Version of the artifact (Required)
    // s    Scope of the artifact (Optional - one of 'compile', 'provided', 'runtime', 'test', 'system', 'import')
    // 
    // [r    Repository that the artifact is contained in (Required)] <-- not needed
    // 
    // str = "g:a:t:v:p:c:e";
    // 

    // verify that parameter is fine
    // if not, return an object that containing only a 'ok' function returning false.
    if (!isok(str)) {
      _this_.ok = function() {
        return false;
      }
      return _this_;
    }

    var arr = str.split(":");

    _this_.g = arr[0];
    _this_.a = arr[1];
    _this_.t = arr[2];

    if (isok(arr[5])) {
      // everything is defined
      _this_.c = arr[3];
      _this_.v = arr[4];
      _this_.s = arr[5];
    } else {
      // at least one of max two optionals missing
      if (!isok(arr[4])) {
        // both optionals missing
        _this_.v = arr[3];
      } else {
        // only one optional missing, which one ?
        // look if arr[4] contains a scope
        var scopes = [
            'compile', 'import', 'provided', 'runtime', 'system', 'test',
        ]; // this array IS and MUST be sorted
        if (-1 == _.sortedIndexOf(scopes, arr[4])) {
          // Scope missing
          _this_.c = arr[3];
          _this_.v = arr[4];
        } else {
          // Classifier missing
          _this_.v = arr[3];
          _this_.s = arr[4];
        }
      }
    }

    _this_.ok = function() {
      var mandatories = [
          _this_.g, _this_.a, _this_.t, _this_.v
      ];
      for (j = 0; j < mandatories.length; j++) {
        if (!isok(mandatories[j])) {
          return false;
        }
      }
      return true;
    }

    return _this_;

  } // function gatcvs(str)

})();
