<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" trimDirectiveWhitespaces="true"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>
<%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout"%>
<t:layout jsmodules="angular moment handlebars">

<script id="handlebars_messages" type="text/x-handlebars-template"><ul>{{#each this}}
  <li>
    <ul>{{#each this}}
      <li>
        <strong>{{@key}}</strong> 
        <ul>{{#each this}}
          <li>
            <ul>{{#each this}}
              <li>
                <span>{{@key}}:</span>
                <span>«&nbsp;<i>{{this}}</i>&nbsp;»</span>
              </li>
            {{/each}}</ul>
          </li>
        {{/each}}</ul>
      </li>
    {{/each}}</ul>
  </li>
{{/each}}</ul></script>

<style>
ul {
  list-style-type: none;
}

span#back_to_index {
  white-space: nowrap;
  overflow: hidden;
}

#alert ul {
  list-style-type: none;
  padding: 0;
}
</style>

<c:if test="${empty pageContext.request.remoteUser}">
  <div id="please_log_in" class="alert alert-info">
    <span class="label label-info">info</span>
    <span><a href="<c:url value='/modules/login.jsp'/>#/api/dagr/v1/dag-list"><span><i class="fa fa-sign-in"></i>&nbsp;Sign in</span></a> to get the list of DAGs</span>
  </div>
</c:if>

<c:if test="${not empty pageContext.request.remoteUser}">
  <div data-ng-app="ngAppDAGs" class="row">
    <div class="col-lg-12">
      <form class = "shorttoolbar toolbar toprightfloating"> 
        <button id="reload" type="button" class="btn btn-secondary">
          <span>
            reload DAGs
            <img id="ajaxLoading" src="<c:url value='/assets/images/animated_orange_refresh_22.png'/>" style="height: 18px; width: auto;">
          </span>
        </button>
      </form>
      <h2 style="display:inline-block;">all DAGs</h2>
    </div>

    <form data-ng-controller="DAGsCtrl">
      <ul class="unstyled col-lg-8">
        <li data-ng-repeat="dagInfo in dagInfos| orderBy:'name'" style="border-bottom: 1px dashed #999;">
          <a href="<c:url value='/api/dagr/v1/dags/'/>{{dagInfo.name}}">
            <span ng-style="{'font-weight' : ($parent.curdag == dagInfo.name ? 'bold' : 'inherit')}">{{dagInfo.label || dagInfo.name}}</span>
          </a>
        </li>
      </ul>
    </form>
  </div>

  <div class="btn-group btn-group-md" role="group" aria-label="...">
    <a type="button" class="btn btn-secondary" href='<c:url value="/api/geppaequo/stnemucod/v1/html/dags"/>' target="_dagInfos">
      DAGs directory
      <i class="fa fa-external-link" aria-hidden="true"></i>
    </a>
  </div>
  <div id="messages" style="padding: 1em 0 0 0;"></div>
  <div id="alert" class="alert alert-dismissable" style="display: none;">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
  </div>
</c:if>

</t:layout>

<c:if test="${not empty pageContext.request.remoteUser}">

<script type="text/javascript" src='<c:url value="/modules/dagr/scripts/dag-list-reload-dags.js"/>'></script>

<script type="text/javascript">
  angular.module('ngAppDAGs', [
      'angular-loading-bar', 'LocalStorageModule'
  ]).config(function(cfpLoadingBarProvider) {
    cfpLoadingBarProvider.includeSpinner = true;
  }).config(function(localStorageServiceProvider) {
    localStorageServiceProvider.setPrefix('dagr');
  }).controller('DAGsCtrl',

  function($scope, $http, localStorageService) {
    $scope.dagInfos = [];
    $scope.curdag = undefined;

    var load = function() {
      $http({
        method : 'GET',
        url : "<c:url value='/api/dagr/v1/dags' />",
      }).then(function successCallback(response) {
        // cf. https://docs.angularjs.org/api/ng/service/$http
        // this callback will be called asynchronously
        // when the response is available
        $scope.dagInfos = response.data;
        $scope.curdag = localStorageService.get("dag");
      }, function errorCallback(response) {
        // called asynchronously if an error occurs
        // or server returns response with an error status.
        $scope.dagInfos = [];
        $scope.curdag = undefined;
      });
    }

    load();

    dagrReload('<c:url value="/"/>', function() {
      load();
    });

  });
</script>

</c:if>