/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs.travis;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URLEncoder;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.geppaequo.config.geppaequo.GeppaequoConfig;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingBiFunction;

public class NodeCleanerTravis {
    private static final Logger log = LoggerFactory.getLogger(NodeCleanerTravis.class);
    final URI uri;
    final ThrowingBiFunction<Bus.Scope, Dag.Node, DagOnSteroids.NodeCleaner.NodeCleaningResult, DagOnSteroids.NodeCleaner.NodeCleanerException> cleaningFunction;

    public NodeCleanerTravis(String url, String token) {
        this.uri = URI.create(url);
        this.cleaningFunction = (scope, node) -> {
            Header[] headers = new Header[]{new BasicHeader("Authorization", "token \"" + token + "\""), new BasicHeader("Content-Type", "application/json"), new BasicHeader("Accept", "application/json"), new BasicHeader("Travis-API-Version", "3")};
            String path = this.calcPath((Dag.Node)node);
            String branch = "master";
            if (node.getValue().getBranch() != null && !node.getValue().getBranch().isEmpty()) {
                branch = node.getValue().getBranch();
            }
            String finalURL = this.uri + path;
            try {
                Request request = Request.Post((String)finalURL).setHeaders(headers).bodyString(Body.string(Body.Request.request(branch)), ContentType.APPLICATION_JSON);
                GeppaequoConfig config = (GeppaequoConfig)ConfigRegistry.CONFIG_REGISTRY.getConfig(GeppaequoConfig.class);
                String proxyIfNeeded = config.getProxyIfNeeded(this.uri.getHost());
                if (proxyIfNeeded != null) {
                    request = request.viaProxy(proxyIfNeeded);
                }
                Response response = request.execute();
                StatusLine statusLine = response.returnResponse().getStatusLine();
                log.debug("POST {} => status: {}", (Object)(this.uri + path), (Object)statusLine);
                return DagOnSteroids.NodeCleaner.NodeCleaningResult.from((Bus.Scope)scope, (int)statusLine.getStatusCode(), (String)statusLine.getReasonPhrase()).source(finalURL);
            }
            catch (Throwable t) {
                throw new DagOnSteroids.NodeCleaner.NodeCleanerException(finalURL, t);
            }
        };
    }

    private String calcPath(Dag.Node node) {
        if (node == null || node.getValue() == null || node.getValue().getScm() == null || node.getValue().getScm().isEmpty()) {
            throw new RuntimeException("no scm");
        }
        String slug = NodeCleanerTravis.getSlug(node.getValue().getScm());
        if (slug == null || slug.isEmpty()) {
            throw new RuntimeException("no slug");
        }
        return "/repo/" + slug + "/requests";
    }

    public ThrowingBiFunction<Bus.Scope, Dag.Node, DagOnSteroids.NodeCleaner.NodeCleaningResult, DagOnSteroids.NodeCleaner.NodeCleanerException> getCleaningFunction() {
        return this.cleaningFunction;
    }

    static String getSlug(String scm) {
        try {
            URI uri = URI.create(scm);
            String path = uri.getPath();
            path = path.replaceAll("^/(.*)\\.git", "$1");
            path = URLEncoder.encode(path, "UTF8");
            return path;
        }
        catch (Exception e) {
            log.debug("exception trying to get slug from {}: {}", (Object)scm, (Object)e.getMessage());
            return null;
        }
    }

    @JsonIgnoreProperties
    static class Body {
        static final ObjectMapper mapper = new ObjectMapper();
        @JsonProperty
        final Request request;

        static {
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }

        Body(Request request) {
            this.request = request;
        }

        public String toString() {
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                log.error(e.getMessage());
                return null;
            }
        }

        static Body body(Request request) {
            return new Body(request);
        }

        static String string(Request request) {
            return Body.body(request).toString();
        }

        static HttpEntity entity(Request request) {
            return new StringEntity(Body.string(request), ContentType.APPLICATION_JSON);
        }

        @JsonIgnoreProperties
        static class Request {
            @JsonProperty
            final String branch;

            Request(String branch) {
                this.branch = branch;
            }

            static Request request(String branch) {
                return new Request(branch);
            }
        }
    }
}

