/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs.jenkins;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.cache.ConcurrentMapTemplateCache;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.ws.rs.core.UriBuilder;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.geppaequo.config.geppaequo.GeppaequoConfig;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingBiFunction;

public class NodeCleanerJenkins {
    private static final Logger LOG = LoggerFactory.getLogger(NodeCleanerJenkins.class);
    private final URI uri;
    private final Executor executor;
    private final ThrowingBiFunction<Bus.Scope, Dag.Node, DagOnSteroids.NodeCleaner.NodeCleaningResult, DagOnSteroids.NodeCleaner.NodeCleanerException> cleaningFunction;
    private final HB hb = new HB();

    public NodeCleanerJenkins(String url, String token, Set<Map.Entry<String, String>> params, String athorizationHeader, String jobNameTemplate, String releaseNameTemplate, URI callback) {
        try {
            CloseableHttpClient httpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    return true;
                }
            }).build()).build();
            this.executor = Executor.newInstance((HttpClient)httpClient);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.uri = URI.create(url);
        this.cleaningFunction = (scope, node) -> {
            URI finalURL = null;
            try {
                String jobName = node.getName();
                if (scope.equals((Object)Bus.Scope.RELEASE)) {
                    if (releaseNameTemplate != null && !releaseNameTemplate.isEmpty()) {
                        jobName = this.hb.applyTemplateAsString(node.getDag(), node, releaseNameTemplate);
                    }
                } else if (scope.equals((Object)Bus.Scope.JOB) && jobNameTemplate != null && !jobNameTemplate.isEmpty()) {
                    jobName = this.hb.applyTemplateAsString(node.getDag(), node, jobNameTemplate);
                }
                UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.uri).path("job").path(jobName);
                if (token != null && !token.trim().isEmpty()) {
                    uriBuilder.queryParam("token", new Object[]{token});
                }
                if (params != null) {
                    uriBuilder.path("buildWithParameters");
                    for (Map.Entry entry : params) {
                        if (entry.getKey() == null || ((String)entry.getKey()).trim().isEmpty() || entry.getValue() == null || ((String)entry.getValue()).trim().isEmpty()) continue;
                        uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
                    }
                    if (node != null && node.getValue() != null && node.getValue().getGucrid() != null) {
                        Dag.Gucrid gucrid = Dag.Gucrid.create((String)node.getValue().getGucrid());
                        String releaseVersion = gucrid.getReleaseVersion().toString();
                        String developmentVersion = gucrid.getNextDevelopmentVersion().toString();
                        if (releaseVersion != null && !releaseVersion.trim().isEmpty()) {
                            uriBuilder.queryParam("releaseVersion", new Object[]{releaseVersion});
                        }
                        if (developmentVersion != null && !developmentVersion.trim().isEmpty()) {
                            uriBuilder.queryParam("developmentVersion", new Object[]{developmentVersion});
                        }
                    }
                    if (callback != null) {
                        uriBuilder.queryParam("statusCallbackURL", new Object[]{UriBuilder.fromUri((URI)callback).path("/api/dagr/v1/dags/" + NodeCleanerJenkins.doubleEncode(node.getDag().getName()) + "/buses/" + scope + "/nodes/" + NodeCleanerJenkins.doubleEncode(node.getName()) + "/events/")});
                    }
                } else {
                    uriBuilder.path("build");
                }
                finalURL = uriBuilder.build(new Object[0]);
                Request request = Request.Post((URI)finalURL).bodyForm((Iterable)Form.form().build());
                request.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                GeppaequoConfig config = (GeppaequoConfig)ConfigRegistry.CONFIG_REGISTRY.getConfig(GeppaequoConfig.class);
                String proxyIfNeeded = config.getProxyIfNeeded(this.uri.getHost());
                if (proxyIfNeeded != null) {
                    request = request.viaProxy(proxyIfNeeded);
                }
                if (athorizationHeader != null && !athorizationHeader.trim().isEmpty()) {
                    request.addHeader("Authorization", athorizationHeader);
                }
                Response response = this.executor.execute(request);
                StatusLine statusLine = response.returnResponse().getStatusLine();
                LOG.debug("POST {} => status: {}", (Object)finalURL, (Object)statusLine);
                return DagOnSteroids.NodeCleaner.NodeCleaningResult.from((Bus.Scope)scope, (int)statusLine.getStatusCode(), (String)statusLine.getReasonPhrase()).source(finalURL.toString());
            }
            catch (Exception e) {
                throw new DagOnSteroids.NodeCleaner.NodeCleanerException(finalURL, (Throwable)e);
            }
        };
    }

    public ThrowingBiFunction<Bus.Scope, Dag.Node, DagOnSteroids.NodeCleaner.NodeCleaningResult, DagOnSteroids.NodeCleaner.NodeCleanerException> getCleaningFunction() {
        return this.cleaningFunction;
    }

    private static String doubleEncode(String name) {
        try {
            String utf8 = Charsets.UTF_8.name();
            return URLEncoder.encode(URLEncoder.encode(name, utf8), utf8);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return name;
        }
    }

    public static class DagAndNode {
        public final Dag dag;
        public final Dag.Node node;

        private static DagAndNode get(Dag dag, Dag.Node node) {
            return new DagAndNode(dag, node);
        }

        private DagAndNode(Dag dag, Dag.Node node) {
            this.dag = dag;
            this.node = node;
        }

        public Dag getDag() {
            return this.dag;
        }

        public Dag.Node getNode() {
            return this.node;
        }
    }

    private static class HB {
        private final ConcurrentMapTemplateCache cache = new ConcurrentMapTemplateCache();
        private final Handlebars handlebars = new Handlebars();
        private final Parser parser = this.handlebars.getParserFactory().create(this.handlebars, "{{", "}}");

        private HB() {
        }

        private String applyTemplateAsString(Dag dag, Dag.Node node, String templateAsString) throws IOException {
            StringTemplateSource source = new StringTemplateSource("jobNameTemplate", templateAsString);
            Template template = this.cache.get((TemplateSource)source, this.parser);
            StringWriter writer = new StringWriter();
            template.apply((Object)DagAndNode.get(dag, node), (Writer)writer);
            ((Writer)writer).flush();
            return ((Object)writer).toString();
        }
    }
}

