/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.DagsSingleton;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.jaxrs.DagInfo;
import net.aequologica.neo.dagr.jaxrs.PATCH;
import net.aequologica.neo.dagr.jaxrs.jenkins.NodeCleanerJenkins;
import net.aequologica.neo.dagr.jaxrs.travis.NodeCleanerTravis;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.garance.SeriesSet;
import net.aequologica.neo.geppaequo.config.ConfigRegistry;
import net.aequologica.neo.geppaequo.config.geppaequo.GeppaequoConfig;
import org.glassfish.jersey.server.mvc.Viewable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;

@Singleton
@Path(value="/v1")
public class ResourceDags
implements Observer {
    public static final String RESOURCE_PATH = "/v1";
    public static final String __DAGS = "/dags/";
    public static final String __BUSES = "/buses/";
    public static final String __SUBS = "/subs/";
    public static final String __NODES = "/nodes/";
    public static final String __STATES = "/states/";
    public static final String __EVENTS = "/events/";
    public static final String _INFO = "/info";
    public static final String _JOURNAL = "/journal";
    public static final String _RELOAD = "/reload";
    public static final String _TOPOLOGICAL = "/topological";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDags.class);
    private static final String SIMPLENAME = ResourceDags.class.getSimpleName();
    private final GeppaequoConfig geppaequoConfig = (GeppaequoConfig)ConfigRegistry.CONFIG_REGISTRY.getConfig(GeppaequoConfig.class);
    private final DagsSingleton.Dags dags;
    private final Map<String, EnumMap<Bus.Scope, Subscription>> subscriptions;
    @Context
    private HttpServletRequest request;
    @Inject
    private SeriesSet garanceSeries;

    public ResourceDags() throws IOException {
        this.dags = DagsSingleton.INSTANCE.dags;
        this.subscriptions = new HashMap<String, EnumMap<Bus.Scope, Subscription>>();
        this.dags.addObserver((Observer)this);
    }

    @PostConstruct
    public void postConstruct() {
        ArrayList exceptions = new ArrayList();
        this.update((Observable)this.dags, exceptions);
    }

    @Override
    public void update(Observable o, Object arg) {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (!(o instanceof DagsSingleton.Dags) || !this.dags.equals(o)) {
                            return;
                        }
                        if (!(arg instanceof Boolean) || !((Boolean)arg).booleanValue()) break block8;
                        for (EnumMap<Bus.Scope, Subscription> dagSubscriptions : this.subscriptions.values()) {
                            for (Subscription thisSubscription : dagSubscriptions.values()) {
                                thisSubscription.unsubscribe();
                            }
                        }
                        this.subscriptions.clear();
                        break block9;
                    }
                    if (!(arg instanceof String)) break block10;
                    String dagName = (String)arg;
                    EnumMap<Bus.Scope, Subscription> dagSubscriptions = this.subscriptions.get(dagName);
                    for (Subscription thisSubscription : dagSubscriptions.values()) {
                        if (thisSubscription == null) continue;
                        thisSubscription.unsubscribe();
                        this.subscriptions.remove(dagName);
                    }
                    break block9;
                }
                if (!(arg instanceof Map.Entry)) break block11;
                Map.Entry thisDagEntry = (Map.Entry)arg;
                DagOnSteroids dagOnSteroids = this.dags.getDagOnSteroids(((String)thisDagEntry.getKey()).toString());
                if (dagOnSteroids == null) break block9;
                for (Map.Entry busEntry : dagOnSteroids.getBusEntries()) {
                    ((Collection)thisDagEntry.getValue()).addAll(this._initGaranceSubscription(dagOnSteroids, dagOnSteroids.getDag().getName(), busEntry));
                }
                ((Collection)thisDagEntry.getValue()).addAll(this._initProperties(dagOnSteroids));
                break block9;
            }
            if (arg instanceof Collection) {
                Collection exceptions = (Collection)arg;
                Collection dagOnSteroidss = this.dags.getDagOnSteroidss();
                for (DagOnSteroids dagOnSteroids : dagOnSteroidss) {
                    for (Map.Entry busEntry : dagOnSteroids.getBusEntries()) {
                        exceptions.add(ResourceDags.tuple(dagOnSteroids.getDag().getName(), this._initGaranceSubscription(dagOnSteroids, dagOnSteroids.getDag().getName(), busEntry)));
                    }
                    exceptions.add(ResourceDags.tuple(dagOnSteroids.getDag().getName(), this._initProperties(dagOnSteroids)));
                }
            }
        }
    }

    private Collection<Map.Entry<String, String>> _initGaranceSubscription(DagOnSteroids dagOnSteroids, String dagName, Map.Entry<Bus.Scope, Bus<Dag.Node>> busEntry) {
        ArrayList exceptions = Lists.newArrayList();
        try {
            Subscription subscription = busEntry.getValue().toObservable().filter(event -> event.getType().equals((Object)BusEvent.Type.CLEAN_OK)).map(event -> (Dag.Node)event.get()).subscribe(node -> {
                if (node != null && node.getId() != null && node.getDag() != null && node.getDag().getName() != null && dagOnSteroids.getDagCleaner((Bus.Scope)busEntry.getKey()).getNodeCleaner(node) != null && dagOnSteroids.getDagCleaner((Bus.Scope)busEntry.getKey()).getNodeCleaner(node).getDuration() != null) {
                    String key = String.valueOf(node.getDag().getName()) + "::" + busEntry.getKey() + "::" + node.getId();
                    Long duration = dagOnSteroids.getDagCleaner((Bus.Scope)busEntry.getKey()).getNodeCleaner(node).getDuration();
                    this.garanceSeries.put(key, (double)duration.longValue()).serialize();
                }
            });
            EnumMap<Bus.Scope, Object> dagSubscriptions = this.subscriptions.get(dagName);
            if (dagSubscriptions == null) {
                dagSubscriptions = new EnumMap(Bus.Scope.class);
                this.subscriptions.put(dagName, dagSubscriptions);
            }
            dagSubscriptions.put(busEntry.getKey(), (Object)subscription);
        }
        catch (Exception e) {
            exceptions.add(ResourceDags.tuple(e.getClass().getSimpleName(), e.getMessage()));
        }
        return exceptions;
    }

    private Collection<Map.Entry<String, String>> _initProperties(DagOnSteroids dagOnSteroids) {
        Map properties = dagOnSteroids.getProperties();
        if (properties == null) {
            return Collections.emptyList();
        }
        ArrayList exceptions = Lists.newArrayList();
        try {
            String dagCleanerType = (String)properties.get("type");
            String dagCleanerName = (String)properties.get("name");
            String dagCleanerUrl = (String)properties.get("url");
            String dagCleanerToken = (String)properties.get("token");
            String dagCleanerAuthorizationHeader = (String)properties.get("authorizationHeader");
            String dagCleanerJobNameTemplate = (String)properties.get("jobNameTemplate");
            String dagCleanerReleaseNameTemplate = (String)properties.get("releaseNameTemplate");
            String dagCleanerCallbackHost = (String)properties.get("callbackHost");
            if (dagOnSteroids != null && dagCleanerType != null && dagCleanerName != null && dagCleanerUrl != null && dagCleanerToken != null) {
                if (dagCleanerType.equals("jenkins")) {
                    Set<Map.Entry<String, String>> dagCleanerParams = this._getBuildParamsIfAny((String)properties.get("params"), exceptions);
                    URI callback = null;
                    if (this.request != null) {
                        String callbackURIAsString = this.request.getRequestURL().toString().replace(this.request.getRequestURI(), this.request.getContextPath());
                        UriBuilder uriBuilder = UriBuilder.fromUri((String)callbackURIAsString);
                        if (dagCleanerCallbackHost != null && !dagCleanerCallbackHost.trim().isEmpty()) {
                            uriBuilder = uriBuilder.host(dagCleanerCallbackHost);
                        }
                        callback = uriBuilder.build(new Object[0]);
                    }
                    dagOnSteroids.setCleaningFunction(new NodeCleanerJenkins(dagCleanerUrl, dagCleanerToken, dagCleanerParams, dagCleanerAuthorizationHeader, dagCleanerJobNameTemplate, dagCleanerReleaseNameTemplate, callback).getCleaningFunction());
                } else if (dagCleanerType.equals("travis")) {
                    String dagCleanerUrlProxy = (String)properties.get("urlProxy");
                    dagOnSteroids.setCleaningFunction(new NodeCleanerTravis(dagCleanerUrlProxy != null ? dagCleanerUrlProxy : dagCleanerUrl, dagCleanerToken).getCleaningFunction());
                }
            }
        }
        catch (Exception e) {
            exceptions.add(ResourceDags.tuple(e.getClass().getSimpleName(), e.getMessage()));
        }
        return exceptions;
    }

    private Set<Map.Entry<String, String>> _getBuildParamsIfAny(String dagCleanerParams, Collection<Map.Entry<String, String>> exceptions) {
        if (dagCleanerParams == null) {
            return null;
        }
        Set params = Collections.emptySet();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            params = (Set)objectMapper.readValue(dagCleanerParams, (TypeReference)new TypeReference<Set<Map.Entry<String, String>>>(){});
        }
        catch (IOException e) {
            exceptions.add(ResourceDags.tuple("params=" + dagCleanerParams, String.valueOf(e.getClass().getSimpleName()) + " - " + e.getMessage()));
        }
        return params;
    }

    @GET
    @Path(value="")
    @Produces(value={"text/plain"})
    public String pingGET() {
        return "pong";
    }

    @POST
    @Path(value="/reload")
    @Produces(value={"application/json"})
    public Response dagReloadAllPOST() {
        Collection allExceptions = this.dags.loadDags();
        return Response.status((Response.Status)Response.Status.OK).entity((Object)allExceptions).build();
    }

    @POST
    @Path(value="/reload/{dag}")
    @Produces(value={"application/json"})
    public Response dagReloadThisPOST(@PathParam(value="dag") String dagkey) {
        this._getDag(dagkey);
        Map.Entry thisDagLoadExceptions = this.dags.loadDag(dagkey);
        if (((Collection)thisDagLoadExceptions.getValue()).size() > 0) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)thisDagLoadExceptions).build();
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    @GET
    @Path(value="/dag-list")
    @Produces(value={"text/html"})
    public Viewable dagListGET_HTML() throws IOException {
        return new Viewable("/WEB-INF/dagr/dag-list");
    }

    @GET
    @Path(value="/dags/")
    @Produces(value={"application/json"})
    public List<DagInfo> dagInfosGET_JSON() throws IOException {
        return this.dags.getDagOnSteroidss().stream().map(d -> DagInfo.create(d)).collect(Collectors.toList());
    }

    @GET
    @Path(value="/dags/")
    @Produces(value={"text/html"})
    public Viewable dagsGET_HTML() throws IOException {
        return new Viewable("/WEB-INF/dagr/dag", this.dagInfosGET_JSON());
    }

    @GET
    @Path(value="/dags/{dag}")
    @Produces(value={"application/json"})
    public Dag dagGET_JSON(@PathParam(value="dag") String dagkey) throws IOException {
        return this._getDag(dagkey);
    }

    @GET
    @Path(value="/dags/{dag}/info")
    @Produces(value={"application/json"})
    public DagInfo dagInfoGET_JSON(@PathParam(value="dag") String dagkey) throws Exception {
        return this._getDagInfo(dagkey, null);
    }

    @GET
    @Path(value="/dags/{dag}")
    @Produces(value={"text/html"})
    public Viewable dagGET_HTML(@PathParam(value="dag") String dagkey) {
        try {
            DagInfo info = this._getDagInfo(dagkey, null);
            return new Viewable("/WEB-INF/dagr/dag", Arrays.asList(info));
        }
        catch (NotFoundException notFoundException) {
            return new Viewable("/WEB-INF/dagr/dag", (Object)Collections.EMPTY_LIST);
        }
    }

    @GET
    @Path(value="/dags/{dag}/subs/")
    @Produces(value={"application/json"})
    public Collection<Dag.SubDag> subDagsGET(@PathParam(value="dag") String dagkey) throws Exception {
        Dag dag = this._getDag(dagkey);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("dag /" + dagkey + "/ not found")).build());
        }
        return dag.getSubDags();
    }

    @POST
    @Path(value="/dags/{dag}/subs/")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String subDagPOST(Set<String> nodeNames, @PathParam(value="dag") String dagkey) throws Exception {
        Dag dag = this._getDag(dagkey);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("dag /" + dagkey + "/ not found")).build());
        }
        Dag.SubDag subDag = new Dag.SubDag(nodeNames);
        dag.addSubDag(subDag);
        return subDag.getId();
    }

    @GET
    @Path(value="/dags/{dag}/subs/{sub}")
    @Produces(value={"text/html"})
    public Viewable subDagGET_HTML(@PathParam(value="dag") String dagkey, @PathParam(value="sub") String subkey, @QueryParam(value="order") String order) throws Exception {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
        DagInfo info = this._getDagInfo(dagkey, subkey);
        dagOnSteroids.setSubDagId(subkey);
        return new Viewable("/WEB-INF/dagr/dag", Arrays.asList(info));
    }

    @GET
    @Path(value="/dags/{dag}/subs/{sub}")
    @Produces(value={"application/json"})
    public Dag subDagGET_JSON(@PathParam(value="dag") String dagkey, @PathParam(value="sub") String subkey, @QueryParam(value="order") String order) throws Exception {
        Dag dag = this._getDag(dagkey);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("dag [" + dagkey + "] not found")).build());
        }
        Dag.SubDag subDag = dag.getSubDag(subkey);
        if (subDag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("dag > sub [" + dagkey + " > " + subkey + "] not found")).build());
        }
        SortedSet nodeNames = subDag.getNodeNames();
        if (order != null) {
            if (order.equals("preds")) {
                return dag.predecessorsDag((Set)nodeNames);
            }
            if (order.equals("succs")) {
                return dag.successorsDag((Set)nodeNames);
            }
        }
        return dag.sub((Set)nodeNames);
    }

    @DELETE
    @Path(value="/dags/{dag}/subs/{sub}")
    public void subDagDELETE(@PathParam(value="dag") String dagkey, @PathParam(value="sub") String subkey) throws Exception {
        Dag dag = this._getDag(dagkey);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("dag [" + dagkey + "] not found")).build());
        }
        Dag.SubDag removeSubDag = dag.removeSubDag(subkey);
        if (removeSubDag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)Error.error("subgraph [" + subkey + "] for dag [" + dagkey + "] not found")).build());
        }
    }

    @GET
    @Path(value="/dags/{dag}/topological")
    @Produces(value={"application/json"})
    public List<String> topologicalGET_JSON(@PathParam(value="dag") String dagkey, @QueryParam(value="type") @DefaultValue(value="id") String type) throws Exception {
        Function transform;
        Dag dag = this._getDag(dagkey);
        Iterator topologicalOrderIterator = dag.getTopologicalOrderIterator();
        if (type == null || type.equals("id")) {
            transform = n -> n.getId();
        } else if (type.equals("name")) {
            transform = n -> n.getName();
        } else if (type.equals("gav")) {
            transform = node -> {
                Dag.NodeValue value = node.getValue();
                if (value == null) {
                    return node.getId();
                }
                String gucrid = value.getGucrid();
                if (gucrid == null || gucrid.length() == 0) {
                    return node.getId();
                }
                Iterable split = Splitter.on((char)':').split((CharSequence)gucrid);
                Iterator iterator = split.iterator();
                if (!iterator.hasNext()) {
                    return node.getId();
                }
                String cfr_ignored_0 = (String)iterator.next();
                if (!iterator.hasNext()) {
                    return node.getId();
                }
                String artifactId = (String)iterator.next();
                if (artifactId == null || artifactId.toString().length() == 0) {
                    return node.getId();
                }
                return artifactId;
            };
        } else {
            throw new InvalidParameterException("invalid parameter 'type' ('" + type + "') in query string. must be one of ['id' | 'name' | 'gav']; when not type parameter is given, type='id' is the default.");
        }
        return Lists.newArrayList((Iterator)Iterators.transform((Iterator)topologicalOrderIterator, (Function)transform));
    }

    @GET
    @Path(value="/dags/{dag}/journal")
    @Produces(value={"text/plain"})
    public String rebuildJournalDag_GET_TEXT_PLAIN(@PathParam(value="dag") String dagkey, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope) throws Exception {
        return this.rebuildJournalDagBus_GET_TEXT_PLAIN(dagkey, scope);
    }

    @GET
    @Path(value="/dags/{dag}/buses/{bus}/journal")
    @Produces(value={"text/plain"})
    public String rebuildJournalDagBus_GET_TEXT_PLAIN(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope) throws Exception {
        DagOnSteroids dagOnSteroids = this.dags.getDagOnSteroids(dagkey);
        if (dagOnSteroids == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagkey + "] not found").valueOf(MediaType.TEXT_PLAIN_TYPE)).build());
        }
        return dagOnSteroids.getDagCleaner(scope).getJournalAsString();
    }

    @DELETE
    @Path(value="/dags/{dag}")
    @Produces(value={"application/json"})
    public Response rebuildCancelDagDELETE(@PathParam(value="dag") String dagkey, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope) throws Exception {
        return this.rebuildCancelDagSubBusDELETE(dagkey, scope, null);
    }

    @DELETE
    @Path(value="/dags/{dag}/buses/{bus}")
    @Produces(value={"application/json"})
    public Response rebuildCancelDagBusDELETE(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope) throws Exception {
        return this.rebuildCancelDagSubBusDELETE(dagkey, scope, null);
    }

    @DELETE
    @Path(value="/dags/{dag}/subs/{sub}")
    @Produces(value={"application/json"})
    public Response rebuildCancelDagSubDELETE(@PathParam(value="dag") String dagkey, @PathParam(value="sub") String subkey, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope) throws Exception {
        return this.rebuildCancelDagSubBusDELETE(dagkey, scope, subkey);
    }

    @DELETE
    @Path(value="/dags/{dag}/buses/{bus}/subs/{sub}")
    @Produces(value={"application/json"})
    public Response rebuildCancelDagSubBusDELETE(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope, @PathParam(value="sub") String subkey) throws Exception {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
        DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
        String info = null;
        if (!dagCleaner.isRunning()) {
            info = "cleaning not running, nothing to cancel";
        } else {
            dagCleaner.cancel();
            info = !dagCleaner.isRunning() ? "cleaning cancelled (nb. node cleanings already ordered or currently running will continue until completion)" : "oooops, seems that cleaning could not be cancelled ... maybe retry ?";
        }
        return Response.ok((Object)Message.message(info)).build();
    }

    @PATCH
    @Path(value="/dags/{dag}")
    @Produces(value={"application/json"})
    public Response rebuildDag_PATCH(@PathParam(value="dag") String dagkey, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope, @QueryParam(value="onlyThisNodeAndSuccessors") String onlyThisNodeAndSuccessors) throws Exception {
        return this.rebuildDagBusSub_PATCH(dagkey, scope, null, onlyThisNodeAndSuccessors);
    }

    @PATCH
    @Path(value="/dags/{dag}/buses/{bus}")
    @Produces(value={"application/json"})
    public Response rebuildDagBus_PATCH(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope, @QueryParam(value="onlyThisNodeAndSuccessors") String onlyThisNodeAndSuccessors) throws Exception {
        return this.rebuildDagBusSub_PATCH(dagkey, scope, null, onlyThisNodeAndSuccessors);
    }

    @PATCH
    @Path(value="/dags/{dag}/subs/{sub}")
    @Produces(value={"application/json"})
    public Response rebuildDagSub_PATCH(@PathParam(value="dag") String dagkey, @PathParam(value="sub") String subkey, @QueryParam(value="onlyThisNodeAndSuccessors") String onlyThisNodeAndSuccessors, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope) throws Exception {
        return this.rebuildDagBusSub_PATCH(dagkey, scope, subkey, onlyThisNodeAndSuccessors);
    }

    @PATCH
    @Path(value="/dags/{dag}/buses/{bus}/subs/{sub}")
    @Produces(value={"application/json"})
    public Response rebuildDagBusSub_PATCH(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope, @PathParam(value="sub") String subkey, @QueryParam(value="onlyThisNodeAndSuccessors") String onlyThisNodeAndSuccessors) throws Exception {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
        try {
            DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
            dagCleaner.cleanFromInclusive(onlyThisNodeAndSuccessors, subkey);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Error.error(e.getMessage())).build());
        }
        return Response.created((URI)URI.create("journal")).status(Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="/dags/{dag}/nodes/")
    @Produces(value={"application/json"})
    public Collection<Dag.Node> dagNodesGET_JSON(@PathParam(value="dag") String dagkey) throws Exception {
        Dag dag = this._getDag(dagkey);
        return dag.getNodes();
    }

    @GET
    @Path(value="/dags/{dag}/nodes/{node}")
    @Produces(value={"application/json"})
    public Dag.Node dagNodeGET_JSON(@PathParam(value="dag") String dagkey, @PathParam(value="node") String node) throws Exception {
        return this._getDagAndNodeByName((String)dagkey, (String)node).node;
    }

    @GET
    @Path(value="/dags/{dag}/nodes/{node}/states/")
    @Produces(value={"application/json"})
    public DagOnSteroids.NodeCleaner.NodeState dagNodeStateGET_JSONfinal(@PathParam(value="dag") String dagkey, @PathParam(value="node") String nodename, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope) throws Exception {
        return this.dagNodeStateGET_JSONfinal(dagkey, scope, nodename);
    }

    @GET
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}/states/")
    @Produces(value={"application/json"})
    public DagOnSteroids.NodeCleaner.NodeState dagNodeStateGET_JSONfinal(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope, @PathParam(value="node") String nodename) throws Exception {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
        Dag.Node node = this.dagNodeGET_JSON(dagkey, nodename);
        return dagOnSteroids.getDagCleaner(scope).getNodeCleaner(node).getState();
    }

    @PATCH
    @Path(value="/dags/{dag}/nodes/{node}")
    @Produces(value={"application/json"})
    public Response dagNodeCleanPOST(@PathParam(value="dag") String dagkey, @PathParam(value="node") String node, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope) throws Exception {
        return this.dagNodeCleanBusPOST(dagkey, scope, node);
    }

    @PATCH
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}")
    @Produces(value={"application/json"})
    public Response dagNodeCleanBusPOST(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope, @PathParam(value="node") String node) throws Exception {
        DagAndNode dagAndNode = this._getDagAndNodeByName(dagkey, node);
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
        DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
        Bus bus = dagCleaner.getBus();
        DagOnSteroids.NodeCleaner.NodeCleaningResult cleanResult = dagOnSteroids.clean(scope, dagAndNode.node);
        if (cleanResult != null && cleanResult.asBoolean()) {
            this._sendBusEvent((Bus<Dag.Node>)bus, BusEvent.Type.CLEAN_ORDER_OK, dagAndNode.node);
            return Response.accepted().build();
        }
        this._sendBusEvent((Bus<Dag.Node>)bus, BusEvent.Type.CLEAN_ORDER_ERROR, dagAndNode.node);
        return Response.serverError().entity((Object)cleanResult).build();
    }

    @PATCH
    @Path(value="/dags/{dag}/nodes/{node}/states/{state}")
    @Produces(value={"application/json"})
    public Response dagNodeStatePATCH_JSON(@PathParam(value="dag") String dagkey, @PathParam(value="node") String node, @PathParam(value="state") DagOnSteroids.NodeCleaner.NodeState state, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope) throws Exception {
        return this.dagNodeStateBusPATCH_JSON(dagkey, scope, node, state);
    }

    @PATCH
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}/states/{state}")
    @Produces(value={"application/json"})
    public Response dagNodeStateBusPATCH_JSON(@PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope, @PathParam(value="node") String nodename, @PathParam(value="state") DagOnSteroids.NodeCleaner.NodeState newState) throws Exception {
        try {
            DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
            DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
            Bus bus = dagCleaner.getBus();
            Dag.Node node = this.dagNodeGET_JSON(dagkey, nodename);
            DagOnSteroids.NodeCleaner.NodeState currentState = dagOnSteroids.getDagCleaner(scope).getNodeCleaner(node).getState();
            if (currentState == null && newState == null || currentState != null && newState != null && newState.equals((Object)currentState)) {
                return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
            }
            dagOnSteroids.getDagCleaner(scope).getNodeCleaner(node).setState(newState);
            this._sendBusEvent((Bus<Dag.Node>)bus, BusEvent.Type.STATE_CHANGE_HACK, node);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception e) {
            LOG.error("[dagr " + SIMPLENAME + "] exception /{}/ logged and re-thrown", (Object)e.getMessage());
            throw e;
        }
    }

    @PATCH
    @Path(value="/dags/{dag}/nodes/{node}/events/{event}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response dagNodeEventSendPATCH(String cleanerId, @PathParam(value="dag") String dagkey, @PathParam(value="node") String node, @PathParam(value="event") BusEvent.Type eventType, @MatrixParam(value="bus") @DefaultValue(value="JOB") Bus.Scope scope) {
        return this.dagNodeEventBusSendPATCH(cleanerId, dagkey, scope, node, eventType);
    }

    @PATCH
    @Path(value="/dags/{dag}/buses/{bus}/nodes/{node}/events/{event}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response dagNodeEventBusSendPATCH(String cleanerId, @PathParam(value="dag") String dagkey, @PathParam(value="bus") Bus.Scope scope, @PathParam(value="node") String node, @PathParam(value="event") BusEvent.Type eventType) {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
        DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
        Bus bus = dagCleaner.getBus();
        DagAndNode dagAndNode = this._getDagAndNodeByName(dagkey, node);
        if (eventType.equals((Object)BusEvent.Type.CLEAN_STARTED)) {
            if (cleanerId != null && cleanerId.length() > 0) {
                dagOnSteroids.getDagCleaner(scope).getNodeCleaner(dagAndNode.node).setId(cleanerId);
            }
        } else if (eventType.equals((Object)BusEvent.Type.CLEAN_OK) || eventType.equals((Object)BusEvent.Type.CLEAN_ERROR) || eventType.equals((Object)BusEvent.Type.CLEAN_ABORTED)) {
            dagOnSteroids.getDagCleaner(scope).getNodeCleaner(dagAndNode.node).setId(null);
        }
        this._sendBusEvent((Bus<Dag.Node>)bus, eventType, dagAndNode.node);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private Dag _getDag(String dagkey) throws NotFoundException {
        String[] both = DagOnSteroids.parseName((String)dagkey);
        Dag dag = this.dags.getDAG(both[0]);
        if (dag == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagkey + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        return dag;
    }

    private DagInfo _getDagInfo(String dagkey, String subDagId) throws NotFoundException {
        DagOnSteroids dagOnSteroids = this._getDagOnSteroids(dagkey);
        dagOnSteroids.setSubDagId(subDagId);
        DagInfo info = DagInfo.create(dagOnSteroids);
        if (info == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("info for dag [" + dagkey + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        return info;
    }

    private DagOnSteroids _getDagOnSteroids(String dagkey) throws NotFoundException {
        DagOnSteroids dagOnSteroids = this.dags.getDagOnSteroids(dagkey);
        if (dagOnSteroids == null) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagkey + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        return dagOnSteroids;
    }

    private DagAndNode _getDagAndNodeByName(String dagkey, String nodeName) throws NotFoundException {
        Dag dag = this._getDag(dagkey);
        List nodes = dag.getNodesFromName(nodeName);
        if (nodes.size() == 0) {
            throw new NotFoundException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity(Error.error("dag [" + dagkey + "] node [" + nodeName + "] not found").valueOf(MediaType.APPLICATION_JSON_TYPE)).build());
        }
        if (nodes.size() > 1) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)("application error. Found multiple nodes with the same name [" + nodeName + "] in dag [" + dagkey + "]. This is not supported")).build());
        }
        return DagAndNode.dagAndNode(dag, (Dag.Node)nodes.get(0));
    }

    private void _sendBusEvent(Bus<Dag.Node> bus, BusEvent.Type eventType, Dag.Node node) {
        if (bus == null) {
            throw new RuntimeException("no bus");
        }
        LOG.debug("[dagr " + SIMPLENAME + "] sending event {}, owner_name/name='{}', branch='{}' to the bus", new Object[]{eventType, node.getName(), node.getValue() != null ? node.getValue().getBranch() : null});
        bus.send(eventType, node.getName(), node.getValue() != null ? node.getValue().getBranch() : null, this.request.getRequestURI().toString());
    }

    private static <T> Map.Entry<String, T> tuple(String a, T b) {
        return new AbstractMap.SimpleImmutableEntry<String, T>(a, b);
    }

    static class DagAndNode {
        final Dag dag;
        final Dag.Node node;

        static DagAndNode dagAndNode(Dag dag, Dag.Node node) {
            return new DagAndNode(dag, node);
        }

        private DagAndNode(Dag dag, Dag.Node node) {
            this.dag = dag;
            this.node = node;
        }
    }

    @JsonIgnoreProperties
    public static class Error {
        @JsonProperty
        final String error;

        public static Error error(String error) {
            return new Error(error);
        }

        public Error(String error) {
            this.error = error;
        }

        public Object valueOf(MediaType mediaType) {
            if (mediaType.equals((Object)"text/plain")) {
                return this.error;
            }
            if (mediaType.equals((Object)"application/json")) {
                return this;
            }
            return this.error;
        }
    }

    @JsonIgnoreProperties
    public static class Message {
        @JsonProperty
        final String message;

        public static Message message(String message) {
            return new Message(message);
        }

        public Message(String message) {
            this.message = message;
        }
    }
}

