/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jaxrs;

import java.util.HashMap;
import java.util.Map;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.model.Dag;

public class DagInfo {
    private final String name;
    private final String label;
    private final String url;
    private final String date;
    private final String subDagId;
    private final Map<String, String> cleanerProperties;
    private final Map<Bus.Scope, Map<String, DagOnSteroids.NodeCleaner>> scopedNodeCleaners;

    public static DagInfo create(DagOnSteroids dagOnSteroids) {
        Dag dag = dagOnSteroids.getDag();
        HashMap<Bus.Scope, Map<String, DagOnSteroids.NodeCleaner>> scopedNodeCleaners = new HashMap<Bus.Scope, Map<String, DagOnSteroids.NodeCleaner>>();
        for (Map.Entry en : dagOnSteroids.getDagCleaners().entrySet()) {
            HashMap<String, DagOnSteroids.NodeCleaner> nodeCleaners = new HashMap<String, DagOnSteroids.NodeCleaner>();
            scopedNodeCleaners.put((Bus.Scope)en.getKey(), nodeCleaners);
            DagOnSteroids.DagCleaner dagCleaner = (DagOnSteroids.DagCleaner)en.getValue();
            for (Dag.Node node : dag.getNodes()) {
                nodeCleaners.put(node.getId(), dagCleaner.getNodeCleaner(node));
            }
        }
        return new DagInfo(dag.getName(), dag.getLabel(), dag.getSource(), dag.getDate(), dagOnSteroids.getSubDagId(), dagOnSteroids.getProperties(), scopedNodeCleaners);
    }

    private DagInfo(String name, String label, String url, String date, String subDagId, Map<String, String> cleanerProperties, Map<Bus.Scope, Map<String, DagOnSteroids.NodeCleaner>> scopedNodeCleaners) {
        this.name = name;
        this.label = label;
        this.url = url;
        this.date = date;
        this.subDagId = subDagId;
        this.cleanerProperties = cleanerProperties;
        this.scopedNodeCleaners = scopedNodeCleaners;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDate() {
        return this.date;
    }

    public String getSubDagId() {
        return this.subDagId;
    }

    public Map<String, String> getCleanerProperties() {
        return this.cleanerProperties;
    }

    public Map<Bus.Scope, Map<String, DagOnSteroids.NodeCleaner>> getScopedNodeCleaners() {
        return this.scopedNodeCleaners;
    }
}

