package net.aequologica.neo.dagr.websocket;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import net.aequologica.neo.dagr.DagOnSteroids.NodeCleaner;

public final class DagSocketMessage{
    private NodeCleaner nodeCleaner;
    private long        time;

    public DagSocketMessage(){
        this(null);
    }

    @JsonCreator
    public DagSocketMessage(@JsonProperty("cleaner") final NodeCleaner cleaner){
        this.nodeCleaner = cleaner;
        this.time    = new Date().getTime();
    }

    @JsonProperty("cleaner") 
    public NodeCleaner getNodeCleaner(){
        return nodeCleaner;
    }

    public void setNodeCleaner(NodeCleaner cleaner){
        this.nodeCleaner = cleaner;
    }

    public long getTime(){
        return time;
    }

    public void setTime(long time){
        this.time = time;
    }

    @Override
    public String toString() {
        return "DagSocketMessage [cleaner=" + nodeCleaner + ", time=" + time + "]";
    }
}
