package net.aequologica.neo.dagr.jaxrs;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.DagOnSteroids.DagCleaner;
import net.aequologica.neo.dagr.DagOnSteroids.NodeCleaner;
import net.aequologica.neo.dagr.bus.Bus.Scope;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.Dag.Node;


public class DagInfo {
    // @formatter:off
    final private String              name;
    final private String              label;
    final private String              url;
    final private String              date;
    final private String              subDagId;
    final private Map<String, String> cleanerProperties;
    final private Map<Scope, Map<String, NodeCleaner>> scopedNodeCleaners;
    
    public static DagInfo create( DagOnSteroids dagOnSteroids ) {
        Dag dag = dagOnSteroids.getDag();
        Map<Scope, Map<String, NodeCleaner>> scopedNodeCleaners = new HashMap<>();
        for (Entry<Scope, DagCleaner> en : dagOnSteroids.getDagCleaners().entrySet()) {
            Map<String, NodeCleaner> nodeCleaners = new HashMap<>();
            scopedNodeCleaners.put(en.getKey(), nodeCleaners);
            DagCleaner dagCleaner = en.getValue();
            for (Node node : dag.getNodes()) {
                nodeCleaners.put(node.getId(), dagCleaner.getNodeCleaner(node));
            }
        }
        return new DagInfo(
                dag.getName(), 
                dag.getLabel(), 
                dag.getSource(), 
                dag.getDate(), 
                dagOnSteroids.getSubDagId(), 
                dagOnSteroids.getProperties(),
                scopedNodeCleaners);
    }
    
    private DagInfo(final String              name, 
                    final String              label, 
                    final String              url, 
                    final String              date, 
                    final String              subDagId, 
                    final Map<String, String> cleanerProperties,
                    final Map<Scope, Map<String, NodeCleaner>> scopedNodeCleaners) {
        this.name               = name;
        this.label              = label;
        this.url                = url;
        this.date               = date;
        this.subDagId           = subDagId;
        this.cleanerProperties  = cleanerProperties;
        this.scopedNodeCleaners = scopedNodeCleaners; 
    }

    public String               getName             () { return name;     }
    public String               getLabel            () { return label;    }
    public String               getUrl              () { return url;      }
    public String               getDate             () { return date;     }
    public String               getSubDagId         () { return subDagId; }
    public Map<String, String>  getCleanerProperties() { return cleanerProperties; }
    public Map<Scope, Map<String, NodeCleaner>> getScopedNodeCleaners() { return this.scopedNodeCleaners; }

    // @formatter:on
}