package net.aequologica.neo.dagr.jaxrs;

import javax.ws.rs.ApplicationPath;

import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.mvc.jsp.JspMvcFeature;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;

import net.aequologica.neo.dagr.jaxrs.github.ResourceGithub;
import net.aequologica.neo.dagr.jaxrs.travis.ResourceTravis;

@ApplicationPath(Application.APP_PATH)
public class Application extends ResourceConfig {
    
    public final static String APP_PATH = "/api/dagr";

    public Application() {

        register(LoggingFeature.class);
        register(JspMvcFeature.class);
        register(JacksonJsonProvider.class);

        register(NodeCleanerExceptionMapper.class);
        
        register(ResourceDags.class);
        register(ResourceGithub.class);
        register(ResourceTravis.class);
    }

}
