;(function(){

  angular.module('dagsApplication', [ 
                                      'angular-loading-bar', 
                                      'angular-websocket', 
                                      'frapontillo.bootstrap-switch',
                                      'humanReadableSnapshots', 
                                      'LocalStorageModule', 
                                      'mwl.confirm', 
                                      'restangular', 
                                      'ui.bootstrap', 
                                    ]);
  
  /////////////////////////////////////////////////////////////////////////////
  // http://stackoverflow.com/questions/3710204/how-to-check-if-a-string-is-a-valid-json-string-in-javascript-without-using-try
  function tryParseJSON(hypotheticalJSON){
    try {
        var o = JSON.parse(hypotheticalJSON);

        // Handle non-exception-throwing cases:
        // Neither JSON.parse(false) or JSON.parse(1234) throw errors, hence the type-checking,
        // but... JSON.parse(null) returns 'null', and typeof null === "object", 
        // so we must check for that, too.
        if (o && typeof o === "object" && o !== null) {
            return o;
        }
    } catch (e) { 
    }

    return false;
  };

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').config(function(RestangularProvider) {
    RestangularProvider.setBaseUrl(Geppaequo.contextPath + 'api/dagr/v1');
  });
  
  // second Restangular service that uses api/quintessence
  angular.module('dagsApplication').factory('AetherRestangular', function(Restangular) {
    return Restangular.withConfig(function(RestangularConfigurer) {
      RestangularConfigurer.setBaseUrl(Geppaequo.contextPath + 'api/quintessence/v1');
    });
  });  
  
  // third Restangular service that uses api/garance
  angular.module('dagsApplication').factory('GaranceRestangular', function(Restangular) {
    return Restangular.withConfig(function(RestangularConfigurer) {
      RestangularConfigurer.setBaseUrl(Geppaequo.contextPath + 'api/garance/v1');
    });
  });  
  
  angular.module('dagsApplication').config(function (localStorageServiceProvider) {
    localStorageServiceProvider
      .setPrefix('dagr');
  });  
  
  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('dagCleaner', [function(){
    
    var controller = ['$scope', 'Restangular', 
              function($scope,   Restangular) {
      
      $scope.isRelease= false;
      
    }];
    
    return {
      restrict     : 'E',
      templateUrl  : Geppaequo.contextPath + 'modules/dagr/templates/dag-cleaner.html',
      controller   : controller,
      controllerAs : 'ctrl',
    };
  }]);

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('dagTopological', [function(){
    
    var controller = ['$scope', 'Restangular', '$timeout',
              function($scope,   Restangular,   $timeout) {
      
      $scope.mouseenter = function(dagId) {
        var $node = $('g.node#'+dagId);
        // cf. http://stackoverflow.com/questions/8638621/jquery-svg-why-cant-i-addclass 
        $node.attr('class', function(index, classNames) {
          return classNames + ' HOVER';
        });
      };
      
      $scope.mouseleave = function(dagId) {
        var $node = $('g.node#'+dagId);
        // cf. http://stackoverflow.com/questions/8638621/jquery-svg-why-cant-i-addclass 
        $node.attr('class', function(index, classNames) {
          return classNames.replace('HOVER', '');
        });
      };

      // type ahead
      var substringMatcher = function() {
        return function findMatches(q, cb) {
          var matches, substringRegex;

          // an array that will be populated with substring matches
          matches = [];

          // regex used to determine if a string contains the substring `q`
          substrRegex = new RegExp(q, 'i');

          // iterate through the pool of strings and for any string that
          // contains the substring `q`, add it to the `matches` array
          $.each(_.map($scope.topological, 'name'), function(i, str) {
            if (substrRegex.test(str)) {
              matches.push(str);
            }
          });

          cb(matches);
        };
      };
      
      $('input.typeahead#node').typeahead({
        hint        : true,
        highlight   : true,
        minLength   : 0,
      },
      {
        name        : 'nodes',
        limit       : 1000,
        source      : substringMatcher() 
      });
      // end type ahead
      
      $scope.enhanceError = function(err, response) {
        if (response.data) {
          if (response.data.error) {
            err = err + ': ' + response.data.error;
          } else if (response.data.status) {
            err = err + ': ' + response.data.status;
            if (response.data.reason) {
              err = err + ' "' + response.data.reason + '"';
            }
            if (response.data.source) {
              err = err + ' < ' + response.data.source;
            }
          }
        }
        window.log(err);
        return err;
      }

      $scope.rebuild = (function() {
        
          var parse = function(name) {
            var regExp    = /^(.*)\/subs\/(.*)$/;
            var dagAndSub = regExp.exec(name);
            if (dagAndSub && dagAndSub.length==3) {
              return {
                dagName : dagAndSub[1],
                subKey  : dagAndSub[2],
              }
            } else {
              return {
                dagName : name,
                subKey  : undefined,
              }
            }
          } 

          var promise;
          
          var clearFeedback = function() { 
            $scope.rebuild.feedback    = undefined;
            $scope.rebuild.hasFeedback = false;
            promise = undefined;
          };
          var setFeedback = function(message) {
            $scope.rebuild.feedback    = message;
            $scope.rebuild.hasFeedback = message ? true : false;
            if (promise) {
              $timeout.cancel(promise);
              promise = undefined;
            }
            if (message) {
              promise = $timeout(clearFeedback, 3000);
            }
          };
          var clearError = function() { 
            $scope.rebuild.error    = undefined;
            $scope.rebuild.hasError = false;
          };
          var setError = function(message) {
            $scope.rebuild.error    = message;
            $scope.rebuild.hasError = message ? true : false;            
          };
          
          function getRest(dagIdName) {
            var dagAndSub = parse(dagIdName);
            var rest = Restangular.one('dags',  dagAndSub.dagName)
                                  .one('buses',  $scope.dagInfo.scope);
            if (dagAndSub.subKey) {
              rest = rest.one('subs',  dagAndSub.subKey);
            }
            return rest;
          }

          var start = function () {
            var queryParams = {};
            var fromNode = $('input.typeahead#node').val(); // impossible d'expliquer � Mr. angular de bien vouloir parler avec Mrs. typeahead
            if (fromNode) {
              queryParams = {onlyThisNodeAndSuccessors: fromNode};
            }
            var rest = getRest($scope.dag.id.name);
            rest.patch({}, queryParams).then(
              function(json)    {
                var msg = 'cleaning started' + (fromNode ? ' from node ' + fromNode : '');
                setFeedback(msg);
              },
              function(response) {
                setError(response.data.error || response.data || response);
              }
            );
          };
          
          var cancel = function () {
            var rest = getRest($scope.dag.id.name);
            rest.remove().then(
              function(json)    {
                setFeedback(json.message);
              },
              function(response) {
                setError(response.data.error || response.data || response);
              }
            );
          };

          return {
            start       : start       ,
            cancel      : cancel      ,
            hasFeedback : undefined   ,
            feedback    : undefined   ,
            setFeedback : setFeedback ,
            hasError    : undefined   ,
            error       : undefined   ,
            setError    : setError    ,
            clearError  : clearError  ,
          }
      })();
      
    }];
    
    return {
      restrict     : 'E',
      templateUrl  : Geppaequo.contextPath + 'modules/dagr/templates/dag-topological.html',
      controller   : controller,
      controllerAs : 'ctrl',
    };
  }]);

  /////////////////////////////////////////////////////////////////////////////
  angular.module('dagsApplication').directive('dagSvg', [function(){
    
    function link(scope, element, attrs) {

      scope.$watch('dag', function () {
        if (scope.dag && scope.dag.id && scope.dag.id.name) {
          // scope.g = DAGRE_D3_HELPER.renderGraph(scope.dag, element, scope.node_name_variant_index);
        }
      }, true);


      scope.$watch('node_name_variant_index', function (newValue, oldValue, scope) {
        scope.g = DAGRE_D3_HELPER.renderGraph(scope.dag, element, newValue);
      }, true);

      scope.$watch('dagInfo.hideSVG', function (newValue, oldValue, scope) {
        if (!newValue) {
          // cf. http://stackoverflow.com/questions/12304291/angularjs-how-to-run-additional-code-after-angularjs-has-rendered-a-template
          scope.$evalAsync(function() {
            // window.log("scope.$watch(", 'dagInfo.hideSVG', newValue, oldValue, scope, ") called !");
          });
        }
      }, true);
    }
    
    return {
      restrict    : 'E',
      templateUrl : Geppaequo.contextPath + 'modules/dagr/templates/dag-svg.html',
      link        : link,
    };
  }]);
  
  /////////////////////////////////////////////////////////////////////////////
  // cf. http://jsfiddle.net/jaredwilli/SfJ8c/
  angular.module('dagsApplication').directive('resize', function ($window) {
    return function (scope, element) {
        var w = angular.element($window);
        scope.getWindowDimensions = function () {
            return {
              'h': w.height(),
              'w': w.width()
            };
        };
        scope.$watch(scope.getWindowDimensions, function (newValue, oldValue) {
          // not used, I know; maybe should be passed as parameter of the resizeGraph ?
          scope.windowHeight = newValue.h;
          scope.windowWidth  = newValue.w;

          if (scope.dagInfo && scope.dagInfo.active) {
            DAGRE_D3_HELPER.resizeGraph(scope.g, element);
          }
        }, true);

        w.bind('resize', function () {
            scope.$apply();
        });
    }
  });
  
  /////////////////////////////////////////////////////////////////////////////
  angular.module('humanReadableSnapshots', []).filter('humanreadable', function($sce) {
    return function(input, str) {

      var ret = (input || '').toString();
      
      var array = ret.split('-');
      if (array.length > 2) {
        var date = moment(array[array.length-2], "YYYYMMDD.HHmmss");
        if (date.isValid()) {
          ret = date.format('YYYY-MM-DD HH:mm');
        }
      }
      return $sce.trustAsHtml(ret);
    };
  });  
  
  
  angular.module('dagsApplication').factory('theTimer', ['$interval', function($interval) {
    
    var TheTimer = (function() {
      var map = new Object();
      var timer = null;
      return {
        add : function(nodeId, progress) {
          map[nodeId] = progress;
          if (_.size(map) > 0 && timer == null) {
            timer = $interval(function() {
              var count = 0;
              for (key in map) {
                count = count + 1;
                if (_.isFunction(map[key].updateProgress)) {
                  map[key].updateProgress();
                } else {
                  window.log("updateProgress is not a function", map[key].updateProgress);
                }
              }
              window.log('theTimer is monitoring', count, 'cleans');
            }, 1000);
          }
        },
        remove : function(nodeId) {
          delete map[nodeId];
          if (_.size(map) == 0 && timer != null) {
            $interval.cancel(timer);
            timer = null;
          }
        }
      };
    });

    return new TheTimer();
  }]);
  
  
})();

