var dagrReload = function(contextPath, callback) {
  var handlebars_messages   = $("#handlebars_messages").html();
  var handlebars_messages_template = Handlebars.compile(handlebars_messages);

  var format = 'MMMM Do YYYY, h:mm:ss a';
  
  $('#reload').click(function() {
    $(".alert-warning").empty();
    $.ajax({
        url:          contextPath + 'api/dagr/v1/reload',
        type:         'POST',
        cache:        false,
        contentType:  false,
        processData:  false
    }).done(function( data, textStatus, jqXHR ) {
      var now = moment().format(format);
      var hasWarnings = false;
      var $messages = "";
      
      if (data) {
        for (let i = 0; i < data.length; i++) {
          var datum = data[i];
          for (key in datum) {
            var value = datum[key];
            if (value === null || value === undefined || value.length === 0) {
              data.splice(i--, 1);
            } else {
              hasWarnings = true;
            }
          }
        }
        if (data.length > 0 ) {
          var $messages = handlebars_messages_template(data);
        }
      }
      $("#messages").empty();
      var alert_class   = hasWarnings ? "alert-warning"          : "alert-success" ;
      var alert_message = hasWarnings ? "reloaded with warnings" : "reloaded"      ;
      $( "#alert" ).clone()
                   .addClass(alert_class)
                   .append("["+textStatus+"] <small>"+now+"</small>&nbsp;<strong>"+alert_message+"!</strong>")
                   .append($messages)
                   .show()
                   .appendTo( "#messages" );
      if (callback) {
        callback();
      }
    }).fail(function( jqXHR, textStatus, errorThrown ) {
      var now = moment().format(format);
      $("#messages").empty();

      var errorText = "["+textStatus+"] "+now+"| <strong>oops!</strong> something wrong happened while sending a POST to [" +this.url + "]. Error:' '"+ errorThrown + "'";
      
      if ((jqXHR.status / 100) == 5) {
        // unexpected server error
        var extractBody = /<body[^>]*>((.|[\n\r])*)<\/body>/im;
        var match = extractBody.exec(jqXHR.responseText);
        if (match && match.length >0) {
          errorText = match[1];
        }
      }
      $( "#alert" ).clone()
                   .addClass("alert-warning")
                   .show()
                   .append(errorText)
                   .insertAfter( "#messages" );
    }).always(function( data_jqXHR, textStatus, jqXHR_errorThrown ) {
      // window.log("always");
    });
  });
};
