<%@page import="net.aequologica.neo.dagr.DagOnSteroids"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" trimDirectiveWhitespaces="true" %>
<%@ page import="net.aequologica.neo.geppaequo.webjars.WebJar" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="t" uri="http://net.aequologica.neo/jsp/jstl/layout" %>
<%  
net.aequologica.neo.geppaequo.servlet.ZeroUtils.HostContextUserAccountAndApp(request);
%>
<%
  Boolean isWizard = request.isUserInRole("wizard") || request.isUserInRole("BUILTIN\\Administrators");
  request.setAttribute("isGeppaequoWizard", isWizard);
%>
<t:layout  jsmodules="angular modernizr datatables moment typeahead handlebars">

<c:if test="${not empty requestScope.userInfo.id}">

<base href="<c:url value='/modules/dagr/index.jsp' />">
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/dags.css'        />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/graph.css'       />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/topo.css'        />"></link>
<link rel="stylesheet" type="text/css" href="<c:url value='/modules/dagr/style/progress.css'    />"></link>

<link rel="stylesheet" type="text/css" href="<c:url value='<%=WebJar.locate("bootstrap3/bootstrap-switch.css") %>' />" />

<style>
.aetherInProgress {
    background: url("<c:url value='/assets/images/animated_gray_refresh_22.gif'/>") no-repeat right center;
    color: gray;
}
</style>

<style type="text/css">

[data-toggle ='tooltip'] {
  vertical-align: top;
}

.tt-query {
  -webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
     -moz-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
          box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
}

.tt-hint {
  color: #999
}

.tt-menu {
  width: 12rem;
  margin-top: .2rem;
  padding: 0;
  background-color: #fff;
  border: 1px solid #ccc;
  border: 1px solid rgba(0, 0, 0, 0.2);
  -webkit-border-radius: 4px;
     -moz-border-radius: 4px;
          border-radius: 4px;
  -webkit-box-shadow: 0 5px 10px rgba(0,0,0,.2);
     -moz-box-shadow: 0 5px 10px rgba(0,0,0,.2);
          box-shadow: 0 5px 10px rgba(0,0,0,.2);
}

.tt-suggestion {
  padding: 3px 20px;
  line-height: 24px;
}

.tt-suggestion.tt-cursor,.tt-suggestion:hover {
  color: #fff;
  background-color: #0097cf;

}

.tt-suggestion p {
  margin: 0;
}
</style>

</c:if> <%-- no user --%>
 
<c:if test="${empty requestScope.userInfo.id}">
<section id="login">
  <a href='<c:url value="/modules/login.jsp"/>#/api/dagr/v1/dags'
     role="button" 
     class="btn btn-sm btn-primary-outline">
     <span><i class="fa fa-sign-in"></i>&nbsp;Sign in</span>
  </a>
</section>
</c:if>

<c:if test="${not empty requestScope.userInfo.id}">
<div id="container" ng-app="dagsApplication">

  <section ng-controller="dagInfoController">

    <div ng-hide="dagInfo">
        <h1>No DAG found</h1>
        <div><a href="<c:url value='/modules/dagr/dag-list.jsp'/>">DAG list</a></div>
    </div>
    
    <dag ng-show="dagInfo">
        <div>
          <form id    = "dagToolbar" 
                class = "shorttoolbar toolbar toprightfloating"> 
            <span id          = "tip"
                  style       = "display:none; color: black; font-size:smaller;"
                  class       = "alert alert-info">
            </span>
            <button id        = "toggleSVG" 
                  data-tip    = "toggle svg display"
                  type        = "button" 
                  class       = "tip btn btn-secondary btn-sm btn-secondary"
                  ng-click    = "toggleSVG()">
              <i class="fa fa-file-image-o" ></i>
            </button>
            <button id        = "nodeNameVariantLegend" 
                  data-tip    = ""
                  type        = "button" 
                  class       = "tip btn btn-secondary btn-sm btn-secondary"
                  ng-click    = "bumpNodeNameVariantIndex()">
              <i class="fa {{node_name_variant_icons[node_name_variant_index]}}" ></i>
            </button>
            <button ng-hide   = "{{hideOnOffLine}}"
                  id          = "online" 
                  data-tip    = "online / offline"
                  type        = "button" 
                  class       = "connection {{connection ? 'on' : 'off'}} tip btn btn-secondary btn-sm btn-secondary"
                  ng-click    = "toggleConnection()">
              <i class="fa {{connection ? 'fa-link' : 'fa-chain-broken'}} " ></i>
            </button>
            <%--a    id          = "daglist"
                  data-tip    = "dag list"
                  href        = "<c:url value='/modules/dagr/dag-list.jsp'/>"
                  type        = "button" 
                  class       = "tip btn btn-secondary btn-sm btn-secondary">
              <i class="fa fa-list" /></i>
            </a  --%>
            <button id        = "reloadDAG" 
                  data-tip    = "reload  /<i>{{dagInfo.name}}</i>/ dag"
                  type        = "button" 
                  class       = "tip btn btn-secondary btn-sm btn-secondary"
                  data-id     = "{{dagInfo.name}}" 
                  ng-click    = "reloadDAG()">
              <i class="fa fa-refresh" ></i>
            </button>
            <button id        = "download" 
                  data-tip    = "download /<i>{{dagInfo.name}}</i>/ dag"
                  type        = "button" 
                  class       = "tip btn btn-secondary btn-sm btn-secondary"
                  data-id     = "{{dagInfo.name}}" 
                  ng-click    = "downloadDAG()">
              <i class="fa fa-download"></i>
            </button>
          </form>
        </div>
        
        <div style="margin:0 0 .5rem 0; display:inline-block;">
          <h3>
            <span>{{dagInfo.label}}</span>
            <span class="btn-group" style="font-size:16px;">
              <button   type            = "button" 
                        class           = "btn btn-sm btn-secondary dropdown-toggle" 
                        data-toggle     = "dropdown" 
                        aria-haspopup   = "true" 
                        aria-expanded   = "false" 
                        style           = "padding-left: .2rem;">
              </button>
              <span class="dropdown-menu">
              </span>
            </span>
          </h3>
          <span style="font-size:11px; color:darkgray;">{{dagInfo.date || "Ø"}}</span>
        </div>
        
        <dag-svg id="theDagSVG" resize ng-hide="dagInfo.hideSVG"></dag-svg>
        
        <dag-cleaner ng-hide="hideCleaner"></dag-cleaner>

        <dag-topological></dag-topological>
        
        <dag-websocket></dag-websocket>

        <dag-websocket2></dag-websocket2>

    </dag>
  
  </section>
</div>
</c:if>

</t:layout>

<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("d3.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dagre-d3.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/angular-websocket.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("dist/restangular.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("ui-bootstrap-tpls.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("angular-bootstrap-confirm.min.js")%>' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("bootstrap-switch.js")%>'    />" ></script>
<script type="text/javascript" charset="utf8" src="<c:url value='<%=WebJar.locate("angular-bootstrap-switch.js")%>' />"></script>

<script type="text/javascript" charset="utf8" src="<c:url value='/assets/scripts/url.js'/>" ></script>

<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/giturl.ct.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dagre-d3-helper.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dags.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag-directive.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag-websocket-directive.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/dag-websocket-directive2.js' />"></script>
<script type="text/javascript" charset="utf8" src="<c:url value='/modules/dagr/scripts/node-progress-directive.js' />"></script>


<script type="text/javascript">

<%-- cf. https://github.com/cpettitt/dagre-d3/issues/202 --%>
SVGElement.prototype.getTransformToElement = SVGElement.prototype.getTransformToElement || function(elem) {
  return elem.getScreenCTM().inverse().multiply(this.getScreenCTM());
};

var getNodeNameVariantLegend;

(function(){
  angular.module('dagsApplication').controller('dagInfoController', 
      [        '$scope', 'localStorageService', 'loadAllDagsService', 'AetherRestangular', '$timeout', '$sce', 
       function($scope ,  localStorageService ,  loadAllDagsService,   AetherRestangular,   $timeout,   $sce) {

    // utility
    function formatDate(theDate) {
      return theDate ? moment.utc(theDate).format("dddd, MMMM Do YYYY, H:mm z") : '';
    }
        
    // ------------------------- from java to javascript ------------------------- 

    $scope.gimmethestuff = "<%= net.aequologica.neo.dagr.DagOnSteroids.NodeCleaner.NodeState.gimmethestuff()%>".split(' ');
    $scope.scopeJOB      = "<%= net.aequologica.neo.dagr.bus.Bus.Scope.JOB.toString()%>";
    $scope.scopeRELEASE  = "<%= net.aequologica.neo.dagr.bus.Bus.Scope.RELEASE.toString()%>";
    
    // localhostName will be used later by garance to compute the node key
    $scope.localhostName = "${applicationScope.geppaequo.localhostName}";
    
    var jevaispasmefairechier = '<c:if test="${pageContext.request.secure}">s</c:if>://${pageContext.request.serverName}:${pageContext.request.serverPort}'+Geppaequo.contextPath;
    $scope.jevaispasmefairechierWS   = 'ws'+jevaispasmefairechier;
    $scope.jevaispasmefairechierHTTP = 'http'+jevaispasmefairechier;
    
    $scope.magicien = false;
    <c:if test='${isGeppaequoWizard}'>
    $scope.magicien = true;
    </c:if>
    
    // ------ from java to javascript most inportant thingy : dagInfo ------------------------- 
    // dagInfo
    var dagInfos = [<c:forEach items="${model}" var="_dagInfo_" varStatus="status">
      {
        id            : 'dag_${status.count}',
        name          : '${_dagInfo_.name}',
        label         : '<c:if test="${empty _dagInfo_.label}">${_dagInfo_.name}</c:if><c:if test="${not empty _dagInfo_.label}">${_dagInfo_.label}</c:if>',
        downloadURL   : '<c:url value="/api/geppaequo/stnemucod/v1/document/dags/${_dagInfo_.name}"/>',
        reloadInfoURL : '<c:url value="/api/dagr/v1/dags/${_dagInfo_.name}/info"/>',
        source        : '${_dagInfo_.url}',
        subDagId      : '${_dagInfo_.subDagId}',
        date          : formatDate('${_dagInfo_.date}'),

        ////////// BEGIN cleaner
        cleaner       : {
          <c:forEach items="${_dagInfo_.cleanerProperties}" var="entry"> ${entry.key}: '${entry.value}',
          </c:forEach>
        },
        scope : "JOB",
        nodeCleaners : {
          <c:forEach items="${_dagInfo_.scopedNodeCleaners}" var="entry"> ${entry.key}: {
            <c:forEach items="${entry.value}" var="nc"> ${nc.key}: { state : '${nc.value.state}' }, 
            </c:forEach>
            },
          </c:forEach>
        },
        ////////// END cleaner
      },</c:forEach>
    ];
    
    dagInfos.sort(function(a, b) {
      // cf. http://stackoverflow.com/questions/51165/how-do-you-do-string-comparison-in-javascript
      return a.name.localeCompare(b.name);
    });

    // ------------------------- select dagInfo ------------------------- 
    var curdag = localStorageService.get("dag");
    
    var dagInfo = _.find(dagInfos, function(dagInfo) { return dagInfo.name == curdag; });
    
    if (!dagInfo && dagInfos.length > 0) {
      dagInfo = dagInfos[0];
    }

    if (!dagInfo) {
      $scope.dagInfo = undefined;
      localStorageService.remove("dag");
      return;
    } else {
      localStorageService.set("dag", dagInfo.name);
      var cursco = localStorageService.get(dagInfo.name+".scope");
      if (cursco && (cursco=="JOB" || cursco=="RELEASE")) {
        dagInfo.scope = cursco;
      }
    } 

    // ------------------------- habemus dagInfo ------------------------- 
    // vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv

    // init dagInfo 
    (function initDagInfo(di){
      di.parseCleanerURL = function () {
        if (di.cleaner) {
          di.cleaner.urlobj = {host:undefined}; // in case anything goes wrong
          if (di.cleaner.url) {
            try {
              di.cleaner.urlobj = new URL(di.cleaner.url);
            } catch(err) {
                window.log("cannot parse as URL, fallback on non-parsed value", di.cleaner.url, err);
                di.cleaner.urlobj = {host:di.cleaner.url};
            }
          }
        }  
      }
      di.parseCleanerURL ();
      di.fromNode = undefined;

      // NOT FINISHED
      di.reload = function () {
        alert("dagInfo reload not yet finished - doing my best");
      };

      di.onChangeCleanerScope = function() {
        window.log("cleaner scope changed", $scope.dagInfo.scope);
        localStorageService.set(dagInfo.name+".scope", $scope.dagInfo.scope);
        _.forOwn(di.nodeCleaners[di.scope], function(nodeCleaner, nodeId) { 
          DAGRE_D3_HELPER.putTheStuffMan(nodeId, $scope.gimmethestuff, nodeCleaner.state);
        });
      };
      
      di.thisIsNotASub = typeof di.subDagId              !== "string" || 
                                di.subDagId               ==  null     || 
                                di.subDagId.trim().length == 0;
      di.thisIsASub    = !di.thisIsNotASub;

    })(dagInfo);
    
    $scope.dagInfo = dagInfo;
    
    // fill dags dropdown thru a worker - fancy, isn't it ?
    (function fillDropdown(){
      loadAllDagsService.doWork();
      $('.dropdown-toggle').dropdownHover();
    })();
 
    // prepare aether requests
    (function prepareAetherRequests(SCOPE){
      var snapshotServer = {
          name        : "${applicationScope.quintessence.snapshotRepo.name}",
          baseURL     : "${applicationScope.quintessence.snapshotRepo.uri}"
      };
      var releaseServer = {
          name        : "${applicationScope.quintessence.releaseRepo.name}",
          baseURL     : "${applicationScope.quintessence.releaseRepo.uri}"
      };
        
      SCOPE.snapshotServer = snapshotServer;
      SCOPE.releaseServer  = releaseServer;
      SCOPE.connection     = localStorageService.get('connection');
      SCOPE.toggleConnection = function() {
        SCOPE.connection = !SCOPE.connection;
        localStorageService.set('connection', SCOPE.connection);
        location.reload(); 
      };

      SCOPE.refreshSnapshot = function(node) {
        if (!SCOPE.connection) {
          return;
        }
        node.resolvingSnapshot = "aetherInProgress";
        $timeout(function() { // give some time to angular to refresh the background
          var snapshotRes = AetherRestangular.one('repositories', SCOPE.snapshotServer.name)
                                              .one('groups'      , node.gav.g                )
                                              .one('artifacts'   , node.gav.a                )
                                              .one('versions'    , '[,)'                     )
                                              .one('extensions'  , 'pom'                     );

          snapshotRes.get().then(function(aetherJson) {
            node.resolvingSnapshot = "";
            node.resolvedSnapshot = $sce.trustAsHtml(aetherJson.version);
          }, function(response) {
            node.resolvingSnapshot = "";
            // cf. http://stackoverflow.com/questions/21919533/using-html-entities-within-angular-strings
            node.resolvedSnapshot = $sce.trustAsHtml("&#8709;");
          });
        }, 1000);
      }

      SCOPE.refreshRelease = function(node) {
        if (!SCOPE.connection) {
          return;
        }
        node.resolvingRelease = "aetherInProgress";
        $timeout(function() { // give some time to angular to refresh the background
          var releaseRes = AetherRestangular.one('repositories' , SCOPE.releaseServer.name )
                                            .one('groups'       , node.gav.g                )
                                            .one('artifacts'    , node.gav.a                )
                                            .one('versions'     , '[,)'                     )
                                            .one('extensions'   , 'pom'                     );

          releaseRes.get().then(function(aetherJson) {
            node.resolvingRelease = "";
            node.resolvedRelease = $sce.trustAsHtml(aetherJson.version);
          }, function(response) {
            node.resolvingRelease = "";
            // cf. http://stackoverflow.com/questions/21919533/using-html-entities-within-angular-strings
            node.resolvedRelease = $sce.trustAsHtml("&#8709;");
          });
        }, 1000);
      }

    })($scope);

    // prepare build vignettes
    (function prepareVignettes(SCOPE){
      SCOPE.clean_passing_svg_url = '<c:url value="/modules/dagr/images/clean_passing.svg"/>';
      SCOPE.clean_failing_svg_url = '<c:url value="/modules/dagr/images/clean_failing.svg"/>';
      SCOPE.clean_aborted_svg_url = '<c:url value="/modules/dagr/images/clean_aborted.svg"/>';
      SCOPE.clean_uncleanable_svg_url = '<c:url value="/modules/dagr/images/clean_uncleanable.svg"/>';
      SCOPE.clean_unknown_svg_url = '<c:url value="/modules/dagr/images/clean_unknown.svg"/>';
    })($scope);

    // prepare node name variants
    (function prepareNodeNameVariants(SCOPE){
      SCOPE.node_name_variant_icons = [ "fa-minus",
                                        "fa-plus",
                                        "fa-asterisk" ];
      SCOPE.node_name_variant_legend = ["( <b>short -</b> | medium + | full * ) label",
                                        "( short - | <b>medium +</b> | full * ) label",
                                        "( short - | medium + | <b>full *</b> ) label" ];
      
      var node_name_variant_index = localStorageService.get('node_name_variant_index');
      if (typeof node_name_variant_index === "undefined" || node_name_variant_index == null) {
              node_name_variant_index = 0;
      }
      SCOPE.node_name_variant_index = node_name_variant_index % SCOPE.node_name_variant_icons.length;
      SCOPE.getNodeNameVariantLegend = getNodeNameVariantLegend = function() {
        return  SCOPE.node_name_variant_legend[ SCOPE.node_name_variant_index];
      }
      
      SCOPE.bumpNodeNameVariantIndex = function() {
      SCOPE.node_name_variant_index = (SCOPE.node_name_variant_index + 1) % SCOPE.node_name_variant_icons.length;
        localStorageService.set('node_name_variant_index', SCOPE.node_name_variant_index);
      }
    })($scope);
    
    // prepare svg show/hide
    (function prepareSVGToggle(SCOPE){
      var hideSVG = localStorageService.get('hideSVG');
      if (typeof hideSVG !== "undefined" && hideSVG != null && hideSVG) {
        SCOPE.dagInfo.hideSVG = true;
      } else {
        SCOPE.dagInfo.hideSVG = false;
      }

      SCOPE.toggleSVG = function() {
        SCOPE.dagInfo.hideSVG = !SCOPE.dagInfo.hideSVG;
        localStorageService.set('hideSVG', SCOPE.dagInfo.hideSVG);
      }
    })($scope);

  }]);
  
  // http://stackoverflow.com/a/16730809/1070215
  angular.module('dagsApplication').factory("loadAllDagsService",['$q',function($q){

    var worker = new Worker('<c:url value="/modules/dagr/scripts/"/>'+'load-all-dags-worker.js');
    var defer = $q.defer();
    worker.addEventListener('message', function(e) {
      // console.log('Worker said: ', e.data);
      var $dm = $('h3 .dropdown-menu');
      $dm.empty();
      e.data.sort(function(a, b) {
        // cf. http://stackoverflow.com/questions/51165/how-do-you-do-string-comparison-in-javascript
        return a.name.localeCompare(b.name);
      });
      
      _.forEach(e.data, function(dagInfo) {
        $dm.append($('<a class="dropdown-item">').attr({href:"<c:url value='/api/dagr/v1/dags/'/>"+dagInfo.name}).text(dagInfo.label || dagInfo.name));
      });
      defer.resolve(e.data);
    }, false);

    return {
        doWork : function(){
            defer = $q.defer();
            worker.postMessage({
              url : "<c:url value='/api/dagr/v1/dags' />"
            }); // Send data to our worker. 
            return defer.promise;
        }
    };
  }]);
  
})();

</script>

<script type="text/javascript">
  $(document).ready(function(){
    
    // tooltips
    $('form.shorttoolbar#dagToolbar [id="nodeNameVariantLegend"]').on( 'click', function() {
      $('form.shorttoolbar#dagToolbar span#tip').html(getNodeNameVariantLegend());
    });
    var $tip = $('form.shorttoolbar#dagToolbar span#tip');
    $('form.shorttoolbar#dagToolbar [type="button"].tip').hover(
        function() {
          if ($(this).attr('id') == "nodeNameVariantLegend") {
            $tip.html(getNodeNameVariantLegend());
          } else {
            $tip.html($(this).data("tip"));
          }
          $tip.show();
        }, function() {
          $tip.empty().hide();
        }
    );
    
    $('#toggleSocketIFrame').on('click', function(event){
      event.preventDefault();
      $('#dagsocket').toggle();
    })
    
  });

</script>
