/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.aequologica.neo.dagr.DagBerk;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.document.DocumentHelper;
import net.aequologica.neo.geppaequo.document.impl.DocumentHelperFactory;
import net.aequologica.neo.serioulizer.Serioulizer;
import net.aequologica.neo.serioulizer.jackson.SeriousReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Dags
extends Observable {
    @Inject
    private Serioulizer serioulizer;
    private SeriousReaderWriter<Dag> serializer;
    private final Logger log = LoggerFactory.getLogger(Dags.class);
    private final FileSystem fileSystem = FileSystems.getDefault();
    private final String DAGS_DIRECTORY = "/dags";
    private final DocumentHelper documentHelper = DocumentHelperFactory.DOCUMENTHELPERFACTORY.getDocumentHelper();
    private final Lock lockOnIO = new ReentrantLock();
    private final Map<String, DagOnSteroids> map = new HashMap<String, DagOnSteroids>();

    Dags() {
    }

    @PostConstruct
    void postConstruct() {
        this.serializer = new SeriousReaderWriter((TypeReference)new TypeReference<Dag>(){}, this.serioulizer);
        this.loadDags();
        DagBerk.PROFOND_DESESPOIR.cdiEstDeLaMerdeEnPot(this);
    }

    public Set<String> getDagNames() {
        return this.map.keySet();
    }

    public Collection<DagOnSteroids> getDagOnSteroidss() {
        return this.map.values();
    }

    public List<Dag> getDAGs() {
        return this.map.values().stream().map(b -> b.getDag()).collect(Collectors.toList());
    }

    public DagOnSteroids getDagOnSteroids(String dagkey) {
        return this.map.get(dagkey);
    }

    public Dag getDAG(String dagkey) {
        DagOnSteroids dagOnSteroids = this.map.get(dagkey);
        return dagOnSteroids == null ? null : dagOnSteroids.getDag();
    }

    public Bus<Dag.Node, Scope> getBus(String dagkey, Scope scope) {
        DagOnSteroids dagOnSteroids = this.map.get(dagkey);
        if (dagOnSteroids == null) {
            return null;
        }
        DagOnSteroids.DagCleaner dagCleaner = dagOnSteroids.getDagCleaner(scope);
        if (dagCleaner == null) {
            return null;
        }
        return dagCleaner.getBus();
    }

    public Collection<Map.Entry<String, Collection<Map.Entry<String, String>>>> loadDags() {
        this.lockOnIO.lock();
        try {
            List<Path> sources;
            ArrayList<Map.Entry<String, Collection<Map.Entry<String, String>>>> allExceptions = new ArrayList<Map.Entry<String, Collection<Map.Entry<String, String>>>>();
            this.setChanged();
            this.notifyObservers(Boolean.TRUE);
            this.map.clear();
            try {
                sources = this.privateGetDagSources();
            }
            catch (Exception e) {
                ArrayList<Map.Entry<String, String>> bigError = new ArrayList<Map.Entry<String, String>>();
                bigError.add(this.tuple(e.getClass().getSimpleName(), e.getMessage()));
                allExceptions.add(this.tuple("", bigError));
                ArrayList<Map.Entry<String, Collection<Map.Entry<String, String>>>> arrayList = allExceptions;
                this.lockOnIO.unlock();
                return arrayList;
            }
            for (Path source : sources) {
                PathMatcher matcher = this.fileSystem.getPathMatcher("regex:^.*\\.(properties|yml|hbs|gitmodules|xml|pom)$");
                if (matcher.matches(source.getFileName())) continue;
                allExceptions.add(this.privateLoadDag(null, source));
            }
            this.setChanged();
            this.notifyObservers(allExceptions);
            ArrayList<Map.Entry<String, Collection<Map.Entry<String, String>>>> arrayList = allExceptions;
            return arrayList;
        }
        finally {
            this.lockOnIO.unlock();
        }
    }

    public Map.Entry<String, Collection<Map.Entry<String, String>>> loadDag(String dagName) {
        this.lockOnIO.lock();
        try {
            Path source;
            this.setChanged();
            this.notifyObservers(dagName);
            Dag dag = this.getDAG(dagName);
            if (dag != null) {
                source = Paths.get(dag.getSource(), new String[0]);
            } else {
                try {
                    source = this.privateLocateSourceWithDagName(dagName);
                }
                catch (IOException e) {
                    ArrayList<Map.Entry<String, String>> exceptions = new ArrayList<Map.Entry<String, String>>();
                    exceptions.add(this.tuple(e.getClass().getSimpleName(), e.getMessage()));
                    Map.Entry<String, Collection<Map.Entry<String, String>>> entry = this.tuple(dagName, exceptions);
                    this.lockOnIO.unlock();
                    return entry;
                }
            }
            Map.Entry<String, Collection<Map.Entry<String, String>>> thisDagExceptions = this.privateLoadDag(dagName, source);
            this.setChanged();
            this.notifyObservers(thisDagExceptions);
            Map.Entry<String, Collection<Map.Entry<String, String>>> entry = thisDagExceptions;
            return entry;
        }
        finally {
            this.lockOnIO.unlock();
        }
    }

    private Map.Entry<String, Collection<Map.Entry<String, String>>> privateLoadDag(String dagName, Path source) {
        if (source == null) {
            throw new IllegalArgumentException("source must be not null");
        }
        ArrayList<Map.Entry<String, String>> exceptions = new ArrayList<Map.Entry<String, String>>();
        try {
            Dag dag = (Dag)this.serializer.read(source);
            dag.setSource(source.toString());
            if (dagName == null) {
                dagName = dag.getName();
            }
            this.map.remove(dagName);
            int indexJsonExtension = source.toString().lastIndexOf(".json");
            Path sourceWithoutJSONExtensionIFAny = indexJsonExtension > 0 ? Paths.get(source.toString().substring(0, indexJsonExtension), new String[0]) : source;
            PropertiesAndExceptions aliasesPAE = new PropertiesAndExceptions();
            aliasesPAE.load(Paths.get(sourceWithoutJSONExtensionIFAny + ".aliases.properties", new String[0]));
            if (aliasesPAE.exceptions != null && aliasesPAE.exceptions.size() > 0) {
                exceptions.addAll(aliasesPAE.exceptions);
            }
            PropertiesAndExceptions cleanerPAE = new PropertiesAndExceptions();
            cleanerPAE.load(Paths.get(sourceWithoutJSONExtensionIFAny + ".cleaner.properties", new String[0]));
            if (cleanerPAE.exceptions != null && cleanerPAE.exceptions.size() > 0) {
                exceptions.addAll(cleanerPAE.exceptions);
            }
            this.loadSubs(dag);
            this.map.put(dag.getName(), new DagOnSteroids(dag, aliasesPAE.properties, cleanerPAE.properties));
        }
        catch (Exception e) {
            exceptions.add(this.tuple(e.getClass().getSimpleName(), e.getMessage()));
        }
        return this.tuple(dagName != null ? dagName : source.getFileName().toString(), exceptions);
    }

    public Path saveSub(Dag dag, String subDagId, String description) throws IOException {
        Path path = Paths.get("/dags", dag.getName(), "subs", String.valueOf(description) + "__" + subDagId);
        List nodes = dag.getNodes(subDagId).stream().map(n -> n.getName()).collect(Collectors.toList());
        Collections.sort(nodes);
        StringWriter sw = new StringWriter();
        for (String node : nodes) {
            sw.write(node);
            sw.write(10);
        }
        this.documentHelper.write(path, Serioulizer.createStream((String)sw.toString()));
        return path;
    }

    private void loadSubs(Dag dag) throws IOException {
        List subs = Collections.emptyList();
        try {
            subs = this.documentHelper.list(Paths.get("/dags", dag.getName(), "subs"));
        }
        catch (Exception ignored) {
            return;
        }
        for (Path sub : subs) {
            String nodeNamesAsString = Serioulizer.read((InputStream)this.documentHelper.getInputStream(sub));
            HashSet<String> nodeNames = new HashSet<String>(Arrays.asList(nodeNamesAsString.split("\n")));
            dag.registerSubDag(nodeNames);
        }
    }

    void packageDumpDag(Path path, Dag dag) throws IOException {
        this.serializer.write(path, (Object)dag);
    }

    private <T> Map.Entry<String, T> tuple(String a, T b) {
        return new AbstractMap.SimpleImmutableEntry<String, T>(a, b);
    }

    private Path privateLocateSourceWithDagName(String dagName) throws IOException {
        List<Path> sources = this.privateGetDagSources();
        for (Path source : sources) {
            Dag dag = (Dag)this.serializer.read(source);
            if (!dag.getName().equals(dagName)) continue;
            return source;
        }
        List collect = sources.stream().map(s -> s.getFileName().toString()).collect(Collectors.toList());
        throw new IOException("no dag with name /" + dagName + "/ found in " + collect);
    }

    private List<Path> privateGetDagSources() throws IOException {
        List potentials = this.documentHelper.list(Paths.get("/dags", new String[0]));
        ArrayList<Path> sources = new ArrayList<Path>();
        PathMatcher extExclude = this.fileSystem.getPathMatcher("regex:^.*\\.(properties|yml|hbs|gitmodules|xml|pom|txt)$");
        PathMatcher dirExclude = this.fileSystem.getPathMatcher("regex:^.*[\\/\\\\]+(subs)[\\/\\\\]+.*$");
        for (Path source : potentials) {
            if (extExclude.matches(source.getFileName()) || dirExclude.matches(source)) continue;
            sources.add(source);
        }
        return sources;
    }

    private class PropertiesAndExceptions {
        Map<String, String> properties;
        final Collection<Map.Entry<String, String>> exceptions = new ArrayList<Map.Entry<String, String>>();

        private PropertiesAndExceptions() {
        }

        void load(Path propertiesPath) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream inputStream = Dags.this.documentHelper.getInputStream(propertiesPath);){
                    if (inputStream == null) {
                        throw new IOException("no [" + propertiesPath + "] in document service");
                    }
                    try {
                        Properties properties = new Properties();
                        properties.load(new InputStreamReader(inputStream, "UTF-8"));
                        this.properties = properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
                    }
                    catch (Exception accumulated) {
                        this.exceptions.add(Dags.this.tuple(propertiesPath.getFileName().toString(), String.valueOf(accumulated.getClass().getSimpleName()) + " - " + accumulated.getMessage()));
                        this.properties = null;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ignored) {
                Dags.this.log.info("ignored exception {} {}", (Object)ignored.getClass().getSimpleName(), (Object)ignored.getMessage());
                this.properties = null;
            }
        }
    }
}

