/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.pivovarit.function.ThrowingBiFunction;
import de.skuzzle.semantic.Version;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.aequologica.neo.dagr.BusImpl;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.model.Dag;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DagOnSteroids {
    private static final Logger LOG = LoggerFactory.getLogger(DagOnSteroids.class);
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static final String SIMPLENAME = DagOnSteroids.class.getSimpleName();
    ThrowingBiFunction<Map.Entry<Scope, Boolean>, Dag.Node, NodeCleaner.NodeCleaningResult, NodeCleaner.NodeCleanerException> cleaningFunction = (b, n) -> NodeCleaner.NodeCleaningResult.undefined((Scope)((Object)((Object)b.getKey())));
    private final Dag dag;
    private final Map<String, String> properties;
    private final EnumMap<Scope, String> nameTemplates;
    private final EnumMap<Scope, DagCleaner> dagCleaners;
    public final Dag.Bumper bumper;
    private Optional<String> subDagId;
    private static final Pattern DAGNAMECONTAINSSUB = Pattern.compile("(.*)%2Fsubs%2(.*)");

    public DagOnSteroids(Dag dag, Map<String, String> nodeAliases, Map<String, String> properties) {
        this.dag = dag;
        this.dagCleaners = new EnumMap(Scope.class);
        this.nameTemplates = new EnumMap(Scope.class);
        this.properties = properties != null ? properties : Collections.emptyMap();
        Scope[] scopeArray = Scope.values();
        int n2 = scopeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Scope scope = scopeArray[n3];
            this.dagCleaners.put(scope, new DagCleaner(new BusImpl(this, scope)));
            this.nameTemplates.put(scope, "{{node.name}}-" + scope.toString());
            ++n3;
        }
        Map<String, String> nameTemplatesFromProperties = DagOnSteroids.parseMap(this.properties.get("nameTemplates"));
        for (Map.Entry<String, String> e : nameTemplatesFromProperties.entrySet()) {
            this.nameTemplates.put(Scope.valueOf(e.getKey()), e.getValue());
        }
        if (nodeAliases != null) {
            for (Dag.Node node : dag.getNodes()) {
                node.setAlias(nodeAliases.get(node.getName()));
            }
        }
        this.bumper = new Dag.Bumper(this.properties.get("bumps"));
        this.subDagId = Optional.ofNullable(null);
    }

    public Dag getDag() {
        return this.dag;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public EnumMap<Scope, String> getNameTemplates() {
        return this.nameTemplates;
    }

    public String getSubDagId() {
        return this.subDagId.orElse(null);
    }

    public void setSubDagId(String subDagId) {
        this.subDagId = subDagId != null && this.dag.getSubDag(subDagId) != null ? Optional.ofNullable(subDagId) : Optional.ofNullable(null);
    }

    public List<Map.Entry<Scope, Bus<Dag.Node, Scope>>> getBusEntries() {
        return this.dagCleaners.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<Scope, Bus<Dag.Node, Scope>>((Scope)((Object)((Object)e.getKey())), ((DagCleaner)e.getValue()).getBus())).collect(Collectors.toList());
    }

    public EnumMap<Scope, DagCleaner> getDagCleaners() {
        return this.dagCleaners;
    }

    public DagCleaner getDagCleaner(Scope scope) {
        return this.dagCleaners.get((Object)scope);
    }

    public ThrowingBiFunction<Map.Entry<Scope, Boolean>, Dag.Node, NodeCleaner.NodeCleaningResult, NodeCleaner.NodeCleanerException> getCleaningFunction() {
        return this.cleaningFunction;
    }

    public void setCleaningFunction(ThrowingBiFunction<Map.Entry<Scope, Boolean>, Dag.Node, NodeCleaner.NodeCleaningResult, NodeCleaner.NodeCleanerException> cleaningFunction) {
        this.cleaningFunction = cleaningFunction;
    }

    public NodeCleaner.NodeCleaningResult clean(Scope scope, Dag.Node node, Boolean skipRelease) throws NodeCleaner.NodeCleanerException {
        if (this.cleaningFunction == null) {
            throw new NodeCleaner.NodeCleanerException("no cleaningFunction defined in enclosing dag");
        }
        return (NodeCleaner.NodeCleaningResult)this.cleaningFunction.apply(new AbstractMap.SimpleImmutableEntry<Scope, Boolean>(scope, skipRelease), (Object)node);
    }

    static void safeWrite(DagCleaner.Journal journal, String entry) {
        LOG.debug(entry);
        if (journal == null) {
            return;
        }
        journal.write(entry);
    }

    public static List<Dag.Node> getNodesFromNameAndBranchContains(Dag dag, String nodeName, String branchSubstring) {
        LinkedList<Dag.Node> ret = new LinkedList<Dag.Node>();
        for (Dag.Node node : dag.getNodesFromName(nodeName)) {
            if (!DagOnSteroids.containsBranchSubstring(node, branchSubstring)) continue;
            ret.add(node);
        }
        LOG.debug("found {} nodes with nodeName='{}' and branch='{}' in dag '{}'", new Object[]{ret.size(), nodeName, branchSubstring, dag.getName()});
        return ret;
    }

    private static boolean containsBranchSubstring(Dag.Node node, String branchSubstring) {
        String nodeBranch = node != null && node.getValue() != null && node.getValue().getBranch() != null ? node.getValue().getBranch() : null;
        if (nodeBranch == null && branchSubstring == null) {
            return true;
        }
        if (nodeBranch == null && branchSubstring == null) {
            return false;
        }
        return nodeBranch.contains(branchSubstring);
    }

    public static String[] parseName(String dagName) {
        Matcher dagNameContainsSub = DAGNAMECONTAINSSUB.matcher(dagName);
        if (dagNameContainsSub.matches()) {
            return new String[]{dagNameContainsSub.group(1), dagNameContainsSub.group(2)};
        }
        String[] stringArray = new String[2];
        stringArray[0] = dagName;
        return stringArray;
    }

    private static String formatMap(Map<String, String> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        return Joiner.on((String)",").withKeyValueSeparator("=").join(map);
    }

    private static Map<String, String> parseMap(String formattedMap) {
        if (formattedMap == null || formattedMap.length() == 0) {
            return Collections.emptyMap();
        }
        return Splitter.on((String)",").withKeyValueSeparator("=").split((CharSequence)formattedMap);
    }

    public NodeNameVersion getCurrent(Dag.Node node, boolean range) {
        if (node != null && node.getName() != null && !node.getName().trim().isEmpty() && node.getValue() != null) {
            String gucridAsString = node.getValue().getGucrid();
            if (gucridAsString == null || gucridAsString.trim().isEmpty()) {
                return null;
            }
            Dag.Gucrid gucrid = Dag.Gucrid.create((String)gucridAsString);
            if (gucrid == null || gucrid.getVersion() == null || !gucrid.getVersion().isPresent()) {
                return null;
            }
            String v = ((String)gucrid.getVersion().get()).toString();
            if (range) {
                v = "[," + v + "]";
            }
            return NodeNameVersion.create(node.getName(), v);
        }
        return null;
    }

    public Collection<NodeNameVersion> getCurrents(boolean range) {
        ArrayList<NodeNameVersion> currentNodeNameVersions = new ArrayList<NodeNameVersion>();
        for (Dag.Node node : this.getDag().getNodes()) {
            NodeNameVersion nodeNameVersion = this.getCurrent(node, range);
            if (nodeNameVersion == null) continue;
            currentNodeNameVersions.add(nodeNameVersion);
        }
        return currentNodeNameVersions;
    }

    public NodeNameVersion getNext(Dag.Node node, boolean range, boolean allowSnapshots, boolean forbidSnapshotFromRelease) {
        if (node != null && node.getName() != null && !node.getName().trim().isEmpty() && node.getValue() != null) {
            String gucridAsString = node.getValue().getGucrid();
            if (gucridAsString == null || gucridAsString.trim().isEmpty()) {
                return null;
            }
            Dag.Gucrid gucrid = Dag.Gucrid.create((String)gucridAsString);
            if (gucrid == null || gucrid.getSemanticVersion() == null || !gucrid.getSemanticVersion().isPresent()) {
                return null;
            }
            Dag.Bump bump = this.bumper.fromNodeName(node.getName());
            if (bump == null) {
                return null;
            }
            Version releaseVersion = gucrid.getReleaseVersion();
            if (releaseVersion == null) {
                return null;
            }
            Version nextDevelopmentVersion = gucrid.getNextDevelopmentVersion(bump);
            if (nextDevelopmentVersion == null) {
                return null;
            }
            String v = !allowSnapshots || forbidSnapshotFromRelease && !gucridAsString.contains("-SNAPSHOT") ? releaseVersion.toString() : nextDevelopmentVersion.toString();
            if (range) {
                v = "[," + v + "]";
            }
            return NodeNameVersion.create(node.getName(), v);
        }
        return null;
    }

    public Collection<NodeNameVersion> getNexts(boolean range, boolean allowSnapshots) {
        ArrayList<NodeNameVersion> nextNodeNameVersions = new ArrayList<NodeNameVersion>();
        for (Dag.Node node : this.getDag().getNodes()) {
            NodeNameVersion nodeNameVersion = this.getNext(node, range, allowSnapshots, true);
            if (nodeNameVersion == null) continue;
            nextNodeNameVersions.add(nodeNameVersion);
        }
        return nextNodeNameVersions;
    }

    public final class DagCleaner {
        private final Bus<Dag.Node, Scope> bus;
        private final Map<Dag.Node, NodeCleaner> nodeCleanerMap;
        private Journal journal;
        private Subscription subscription;
        private String sub;
        private final Set<Dag.Node> nodesToBeSmudgedSkipRelease;

        public DagCleaner(Bus<Dag.Node, Scope> bus) {
            this.bus = bus;
            this.nodesToBeSmudgedSkipRelease = bus.getScope().equals((Object)Scope.RELEASE) ? new HashSet<Dag.Node>() : Collections.emptySet();
            this.nodeCleanerMap = new HashMap<Dag.Node, NodeCleaner>();
            for (Dag.Node node : DagOnSteroids.this.dag.getNodes()) {
                this.nodeCleanerMap.put(node, new NodeCleaner(this.bus.getScope(), node, NodeCleaner.NodeState.UNKNOWN));
            }
        }

        public Bus<Dag.Node, Scope> getBus() {
            return this.bus;
        }

        public String getSub() {
            return this.sub;
        }

        public NodeCleaner getNodeCleaner(Dag.Node node) {
            return this.nodeCleanerMap.get(node);
        }

        public void cleanAll() {
            this.cleanSubDag(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanSubDag(String subDagKey) {
            if (DagOnSteroids.this.getCleaningFunction() == null) {
                throw new RuntimeException("No cleaner defined. Check configuration.");
            }
            if (this.journal == null) {
                this.journal = new Journal();
            } else if (this.journal.state.equals((Object)State.RUNNING)) {
                throw new RuntimeException("Cleaning already running: Wait for completion, or cancel it and retry.");
            }
            this.sub = subDagKey;
            Set nodesToInclude = DagOnSteroids.this.dag.getNodes(subDagKey).stream().filter(n -> !n.getClazz().equals("cluster")).map(n -> n.getName()).collect(Collectors.toSet());
            Journal journal = this.journal;
            synchronized (journal) {
                this.journal.raz();
                DagOnSteroids.safeWrite(this.journal, "start first round");
                HashSet<Dag.Node> nodesToBeSmudged = new HashSet<Dag.Node>();
                HashSet<Dag.Node> nodesToBeMagicCleaned = new HashSet<Dag.Node>();
                if (this.bus.getScope().equals((Object)Scope.RELEASE)) {
                    this.nodesToBeSmudgedSkipRelease.clear();
                }
                for (Dag.Node node : DagOnSteroids.this.dag.getTopologicalNodes()) {
                    if (node.getValue() != null && node.getValue().getGucrid() != null && !node.getValue().getGucrid().contains("SNAPSHOT")) {
                        nodesToBeMagicCleaned.add(node);
                        this.explainMagicClean(node, "not a snapshot", node.getValue().getGucrid().toString());
                        continue;
                    }
                    if (!nodesToInclude.contains(node.getName())) {
                        nodesToBeMagicCleaned.add(node);
                        this.explainMagicClean(node, "not in sub dag", nodesToInclude.toString());
                        continue;
                    }
                    nodesToBeSmudged.add(node);
                }
                if (this.bus.getScope().equals((Object)Scope.RELEASE)) {
                    for (Dag.Node smudged : nodesToBeSmudged) {
                        Iterator bfi = DagOnSteroids.this.dag.getBreadthFirstIterator(smudged);
                        while (bfi.hasNext()) {
                            Dag.Node succ = (Dag.Node)bfi.next();
                            if (!nodesToBeMagicCleaned.contains(succ)) continue;
                            nodesToBeMagicCleaned.remove(succ);
                            this.nodesToBeSmudgedSkipRelease.add(succ);
                        }
                    }
                }
                this.bus.send(BusEvent.Type.MAGIC_CLEAN, nodesToBeMagicCleaned, SIMPLENAME);
                this.bus.send(BusEvent.Type.SMUDGE, nodesToBeSmudged, SIMPLENAME);
                this.bus.send(BusEvent.Type.SMUDGE, this.nodesToBeSmudgedSkipRelease, SIMPLENAME);
                for (Dag.Node node : DagOnSteroids.this.dag.getTopologicalNodes()) {
                    DagOnSteroids.safeWrite(this.journal, String.format("set node /%s/ state to %s", new Object[]{node.getName(), this.getNodeCleaner(node).getState()}));
                }
                this.bus.toObservable().filter(event -> event.getType().equals((Object)BusEvent.Type.CLEAN_STARTED) || event.getType().equals((Object)BusEvent.Type.CLEAN_OK) || event.getType().equals((Object)BusEvent.Type.CLEAN_ERROR) || event.getType().equals((Object)BusEvent.Type.CLEAN_ABORTED)).subscribe(event -> {
                    Dag.Node node = (Dag.Node)event.get();
                    DagOnSteroids.safeWrite(this.journal, String.format("received event %s on node /%s/ from [ %s ]", new Object[]{event.getType(), node.getName(), event.getSource()}));
                    if (this.journal != null && !this.journal.state.equals((Object)State.RUNNING)) {
                        DagOnSteroids.safeWrite(this.journal, String.format("Cleaning is not running (state=%s), doing nothing.", this.journal.state.toString()));
                        return;
                    }
                    if (event.getType().equals((Object)BusEvent.Type.CLEAN_OK)) {
                        this.queue();
                    } else if (event.getType().equals((Object)BusEvent.Type.CLEAN_ERROR) || event.getType().equals((Object)BusEvent.Type.CLEAN_ABORTED)) {
                        this.error((Dag.Node)event.get());
                    }
                    this.ifAllNodesAreCleanThenDone();
                });
                this.queue();
            }
        }

        private void explainMagicClean(Dag.Node node, String reason, String optional) {
            DagOnSteroids.safeWrite(this.journal, String.format("set node /%s/ state to %s: %s%s", new Object[]{node.getName(), NodeCleaner.NodeState.CLEAN, reason, optional != null ? " - " + optional : ""}));
        }

        public String getJournalAsString() {
            if (this.journal != null) {
                return this.journal.toString();
            }
            return "nothing to read";
        }

        public void done() {
            try {
                DagOnSteroids.this.clean(this.bus.getScope(), null, null);
                DagOnSteroids.safeWrite(this.journal, "ordered closing of cleaning process");
            }
            catch (NodeCleaner.NodeCleanerException e) {
                DagOnSteroids.safeWrite(this.journal, String.format("exception while ordering closing of cleaning process in scope &s : %s", new Object[]{this.bus.getScope(), e.getMessage()}));
                throw new RuntimeException(e);
            }
            if (this.subscription != null) {
                this.subscription.cancel();
                this.subscription = null;
            }
            if (this.journal != null) {
                this.journal.done();
            }
        }

        public void error(Dag.Node error) {
            if (this.subscription != null) {
                this.subscription.cancel();
                this.subscription = null;
            }
            if (this.journal != null) {
                this.journal.error(error);
                this.journal.close();
            }
        }

        public void cancel() {
            if (this.subscription != null) {
                this.subscription.cancel();
                this.subscription = null;
            }
            if (this.journal != null) {
                this.journal.cancel();
            }
        }

        private void ifAllNodesAreCleanThenDone() {
            if (this.journal == null) {
                return;
            }
            if (!this.journal.state.equals((Object)State.RUNNING)) {
                return;
            }
            int doneCount = 0;
            String subDag = this.bus.getScope().equals((Object)Scope.RELEASE) ? null : DagOnSteroids.this.getSubDagId();
            Collection nodesSubSet = DagOnSteroids.this.dag.getNodes(subDag);
            for (Dag.Node node : nodesSubSet) {
                NodeCleaner.NodeState state = this.getNodeCleaner(node).getState();
                if (state == null || !state.oneOf(NodeCleaner.NodeState.CLEAN, NodeCleaner.NodeState.CLEANED)) continue;
                ++doneCount;
            }
            if (doneCount == nodesSubSet.size()) {
                this.done();
            }
        }

        private void orderCleaningOfNode(Dag.Node node, Boolean skipRelease) {
            NodeCleaner.NodeCleaningResult result;
            try {
                result = DagOnSteroids.this.clean(this.bus.getScope(), node, skipRelease);
            }
            catch (Exception e) {
                URI source = null;
                if (e instanceof NodeCleaner.NodeCleanerException) {
                    source = ((NodeCleaner.NodeCleanerException)e).getSource();
                }
                LOG.error("ordering cleaning of node /{}/ failed with exception \"{}\". (caught exception is not rethrown but cleanNode function will return not zero + exception message). source={}", new Object[]{node.getName(), e.getMessage(), source});
                result = NodeCleaner.NodeCleaningResult.fromException(this.bus.getScope(), e, source);
            }
            if (result != null && result.asBoolean()) {
                this.bus.send(BusEvent.Type.CLEAN_ORDER_OK, Collections.singletonList(node), SIMPLENAME);
                DagOnSteroids.safeWrite(this.journal, String.format("ordered cleaning of node /%s/ (%s)", node.getName(), result.getURI()));
            } else {
                String error = result == null ? "null result" : String.valueOf(result.getStatus()) + " " + result.getReason();
                this.bus.send(BusEvent.Type.CLEAN_ORDER_ERROR, Collections.singletonList(node), error);
                DagOnSteroids.safeWrite(this.journal, String.format("cannot order cleaning of node /%s/: %s [%s]", node.getName(), error, result.getURI()));
            }
        }

        private void queue() {
            DagOnSteroids.safeWrite(this.journal, "start inpecting queue");
            for (Dag.Node node : DagOnSteroids.this.dag.getTopologicalNodes()) {
                NodeCleaner.NodeState thisState = this.getNodeCleaner(node).getState();
                if (!thisState.oneOf(NodeCleaner.NodeState.DIRTY)) continue;
                Collection predecessors = DagOnSteroids.this.dag.predecessorsOf(node);
                int doneCount = 0;
                int errorCount = 0;
                for (Dag.Node pred : predecessors) {
                    NodeCleaner.NodeState predState = this.getNodeCleaner(pred).getState();
                    if (predState == null || !predState.oneOf(NodeCleaner.NodeState.CLEAN, NodeCleaner.NodeState.CLEANED)) continue;
                    ++doneCount;
                }
                if (doneCount != predecessors.size()) continue;
                if (predecessors.size() == 0) {
                    DagOnSteroids.safeWrite(this.journal, String.format("node /%s/ is %s and has no predecessor : time to clean it, isn't it?", new Object[]{node.getName(), thisState}));
                } else {
                    DagOnSteroids.safeWrite(this.journal, String.format("node /%s/ is %s and all its predecessors (%d) are DONE (with %d error(s)) : time to clean it, isn't it?", new Object[]{node.getName(), thisState, doneCount, errorCount}));
                }
                this.orderCleaningOfNode(node, this.nodesToBeSmudgedSkipRelease.contains(node));
            }
            DagOnSteroids.safeWrite(this.journal, "done inpecting queue");
        }

        public State getState() {
            if (this.journal == null) {
                return null;
            }
            return this.journal.state;
        }

        class Journal
        implements Closeable {
            private State state;
            private ByteArrayOutputStream baos;
            private BufferedWriter writer;

            Journal() {
                this.raz();
            }

            void raz() {
                DagCleaner.this.bus.send(BusEvent.Type.INITIALIZE, Collections.emptyList(), SIMPLENAME);
                this.state = State.RUNNING;
                this.baos = new ByteArrayOutputStream();
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.baos, StandardCharsets.UTF_8));
            }

            void write(String entry) {
                try {
                    this.writer.newLine();
                    this.writer.write(FMT.format(new Date()));
                    this.writer.write(" [");
                    this.writer.write(Thread.currentThread().getName());
                    this.writer.write("] ");
                    this.writer.write(entry);
                    this.writer.flush();
                }
                catch (IOException e) {
                    LOG.warn("ignored exception {}", (Object)e.getMessage());
                }
            }

            void done() {
                this.write("done!");
                this.state = State.DONE;
                this.close();
            }

            void cancel() {
                this.write("cancelled by external action");
                this.state = State.CANCELLED;
                this.close();
            }

            void error(Dag.Node node) {
                this.write("node [ " + node.getName() + " ]");
            }

            @Override
            public void close() {
                for (Dag.Node node : DagOnSteroids.this.dag.getTopologicalNodes()) {
                    this.write("node /" + node.getName() + "/ state is " + DagCleaner.this.getNodeCleaner(node).getState().toString());
                }
                DagCleaner.this.bus.send(BusEvent.Type.TERMINATE, Collections.emptyList(), SIMPLENAME);
            }

            public String toString() {
                return String.valueOf(this.state.toString()) + "\n" + new String(this.baos.toByteArray(), StandardCharsets.UTF_8);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NodeCleaner {
        @JsonProperty
        private UUID id;
        @JsonProperty
        private final Dag.Node node;
        @JsonProperty
        private final Scope scope;
        @JsonProperty
        private NodeState state;
        @JsonIgnore
        private Long start;
        @JsonIgnore
        private Long stop;

        @JsonCreator
        public NodeCleaner(@JsonProperty(value="scope") Scope scope, @JsonProperty(value="node") Dag.Node node, @JsonProperty(value="state") NodeState state) {
            this.node = node;
            this.scope = scope;
            this.state = state;
        }

        public String getId() {
            return this.id == null ? null : this.id.toString();
        }

        public void setId(String id) {
            if (id == null) {
                this.id = null;
                if (this.start != null) {
                    this.stop = new Date().getTime();
                }
            } else {
                this.start = new Date().getTime();
                this.stop = null;
                if (id.matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")) {
                    this.id = UUID.fromString(id);
                }
            }
        }

        @JsonIgnore
        public Dag.Node getNode() {
            return this.node;
        }

        public NodeState getState() {
            return this.state;
        }

        public void setState(NodeState state) {
            this.state = state;
        }

        public Long getDuration() {
            if (this.start == null) {
                return null;
            }
            if (this.stop == null) {
                return new Date().getTime() - this.start;
            }
            return this.stop - this.start;
        }

        public static class NodeCleanerException
        extends Exception {
            private static final long serialVersionUID = -3468108554682441131L;
            public final URI source;

            public NodeCleanerException() {
                this((URI)null);
            }

            public NodeCleanerException(String arg0, Throwable arg1, boolean arg2, boolean arg3) {
                this(null, arg0, arg1, arg2, arg3);
            }

            public NodeCleanerException(String arg0, Throwable arg1) {
                this(null, arg0, arg1);
            }

            public NodeCleanerException(String arg0) {
                this(null, arg0);
            }

            public NodeCleanerException(Throwable arg0) {
                this((URI)null, arg0);
            }

            public NodeCleanerException(URI source, String arg0, Throwable arg1, boolean arg2, boolean arg3) {
                super(NodeCleanerException.addSourceToMessage(arg0, source), arg1, arg2, arg3);
                this.source = source;
            }

            public NodeCleanerException(URI source, String arg0, Throwable arg1) {
                super(NodeCleanerException.addSourceToMessage(arg0, source), arg1);
                this.source = source;
            }

            public NodeCleanerException(URI source, String arg0) {
                super(NodeCleanerException.addSourceToMessage(arg0, source));
                this.source = source;
            }

            public NodeCleanerException(URI source, Throwable arg0) {
                super(NodeCleanerException.sourceAsMessage(source), arg0);
                this.source = source;
            }

            public NodeCleanerException(URI source) {
                super(NodeCleanerException.sourceAsMessage(source));
                this.source = source;
            }

            public URI getSource() {
                return this.source;
            }

            private static final String addSourceToMessage(String message, URI source) {
                return String.valueOf(message) + (source != null ? " - source: " + source.toString() : "");
            }

            private static final String sourceAsMessage(URI source) {
                return source != null ? "source: " + source.toString() : "";
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class NodeCleaningResult {
            private final Scope scope;
            private final int status;
            private final String reason;
            private final URI uri;

            @JsonCreator
            public NodeCleaningResult(@JsonProperty(value="bus") Scope scope, @JsonProperty(value="status") int status, @JsonProperty(value="reason") String reason, @JsonProperty(value="uri") URI uri) {
                this.scope = scope;
                this.status = status;
                this.reason = reason;
                this.uri = uri;
            }

            public Scope getScope() {
                return this.scope;
            }

            public int getStatus() {
                return this.status;
            }

            public String getReason() {
                return this.reason;
            }

            public URI getURI() {
                return this.uri;
            }

            @JsonIgnore
            public boolean asBoolean() {
                return this.status == 0 || this.status / 100 == 2;
            }

            public static NodeCleaningResult undefined(Scope c) {
                return new NodeCleaningResult(c, -1, "undefined", null);
            }

            public static NodeCleaningResult fromException(Scope c, Exception e, URI uri) {
                String msg = String.valueOf(e.getClass().getSimpleName()) + "| " + e.getMessage();
                if (e.getCause() != null) {
                    msg = String.valueOf(msg) + "\n(cause:" + e.getCause().getClass().getSimpleName() + "| " + e.getCause().getMessage() + ")";
                }
                return new NodeCleaningResult(c, -1, msg, uri);
            }

            public static NodeCleaningResult ok(Scope c, URI uri) {
                return new NodeCleaningResult(c, 0, "", uri);
            }

            public static NodeCleaningResult from(Scope c, int status, String reason, URI uri) {
                return new NodeCleaningResult(c, status, reason, uri);
            }
        }

        public static enum NodeState {
            UNKNOWN,
            CLEAN,
            DIRTY,
            CLEANING_ORDERED,
            BEING_CLEANED,
            UNCLEANABLE,
            CLEANED,
            FAIL,
            ABORTED;


            public boolean oneOf(NodeState ... others) {
                NodeState[] nodeStateArray = others;
                int n = others.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeState other = nodeStateArray[n2];
                    if (this.equals((Object)other)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }
    }

    @JsonIgnoreProperties
    public static class NodeNameVersion {
        @JsonProperty
        public final String name;
        @JsonProperty
        public final String version;

        public static NodeNameVersion create(String name, String version) {
            return new NodeNameVersion(name, version);
        }

        public NodeNameVersion(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }

    public static enum State {
        RUNNING,
        DONE,
        CANCELLED;

    }
}

