package net.aequologica.neo.dagr.bus;

/**  
 *   +-----------+
 *   |   CLEAN   |   +------------ MAGIC_CLEAN
 *   +-----------+
 *   
 *   +-----------+
 *   |   DIRTY   |   +------------ SMUDGE
 *   +-----------+
 *   
 *   no state change +------------ CLEAN_ORDER_ERROR
 *   
 *   +----------------------+
 *   |   CLEANING_ORDERED   | +--- CLEAN_ORDER_OK
 *   +----------------------+
 *   
 *   +-------------------+
 *   |   BEING_CLEANED   | +------ CLEAN_STARTED
 *   +-------------------+
 *   
 *   +-------------+
 *   |   CLEANED   | +------------ CLEAN_OK
 *   +-------------+
 *   
 *   +-----------+
 *   |   FAIL    | +-------------- CLEAN_ERROR
 *   +-----------+
 *   
 *   +--------------+
 *   |   ABORTED    | +----------- CLEAN_ABORTED
 *   +--------------+
 *   
 *   +--------+
 *   |   *    | +----------------- STATE_CHANGE_HACK
 *   +--------+
 *   
 */  

public interface BusEvent<T> {
    
    public static enum Type {
      INITIALIZE,
        STATE_CHANGE_HACK, 
        MAGIC_CLEAN, 
        SMUDGE, 
        CLEAN_ORDER_OK,
        CLEAN_ORDER_ERROR,
        CLEAN_STARTED,
        CLEAN_OK,
        CLEAN_WARNING,
        CLEAN_ERROR,
        CLEAN_ABORTED,
      TERMINATE,
    }
    
    Type getType();
    
    T get();
    
    String getSource();

}
