/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.Collection;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.Scope;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.model.Dag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BusImpl
implements Bus<Dag.Node, Scope> {
    private static final Logger LOG = LoggerFactory.getLogger(BusImpl.class);
    private final Subject<BusEvent<Dag.Node>> nodeBus = PublishSubject.create();
    private final DagOnSteroids dagOnSteroids;
    private final Scope scope;

    BusImpl(DagOnSteroids dagOnSteroids, Scope scope) {
        this.dagOnSteroids = dagOnSteroids;
        this.scope = scope;
        LOG.debug("[bus {}] created bus for dag {}", (Object)scope, (Object)dagOnSteroids.getDag().getName());
    }

    @Override
    public Scope getScope() {
        return this.scope;
    }

    @Override
    public void send(final BusEvent.Type type, Collection<Dag.Node> nodes, final String source) {
        try {
            DagOnSteroids.NodeCleaner.NodeState newState = type.equals((Object)BusEvent.Type.MAGIC_CLEAN) ? DagOnSteroids.NodeCleaner.NodeState.CLEAN : (type.equals((Object)BusEvent.Type.SMUDGE) ? DagOnSteroids.NodeCleaner.NodeState.DIRTY : (type.equals((Object)BusEvent.Type.CLEAN_ORDER_OK) ? DagOnSteroids.NodeCleaner.NodeState.CLEANING_ORDERED : (type.equals((Object)BusEvent.Type.CLEAN_ORDER_ERROR) ? DagOnSteroids.NodeCleaner.NodeState.UNCLEANABLE : (type.equals((Object)BusEvent.Type.CLEAN_STARTED) ? DagOnSteroids.NodeCleaner.NodeState.BEING_CLEANED : (type.equals((Object)BusEvent.Type.CLEAN_ERROR) ? DagOnSteroids.NodeCleaner.NodeState.FAIL : (type.equals((Object)BusEvent.Type.CLEAN_ABORTED) ? DagOnSteroids.NodeCleaner.NodeState.ABORTED : (type.equals((Object)BusEvent.Type.CLEAN_OK) ? DagOnSteroids.NodeCleaner.NodeState.CLEANED : DagOnSteroids.NodeCleaner.NodeState.UNKNOWN)))))));
            for (final Dag.Node node : nodes) {
                DagOnSteroids.NodeCleaner.NodeState previousState = this.dagOnSteroids.getDagCleaner(this.scope).getNodeCleaner(node).getState();
                if (previousState != null && previousState.equals((Object)newState)) continue;
                this.dagOnSteroids.getDagCleaner(this.scope).getNodeCleaner(node).setState(newState);
                LOG.debug("[bus {}:{}] about to notify observers that state of node /{}/ with id {} has changed from {} to {} due to event {} from source \"{}\"", new Object[]{this.dagOnSteroids.getDag().getName(), this.scope, node.getName(), node.getId(), previousState, this.dagOnSteroids.getDagCleaner(this.scope).getNodeCleaner(node).getState(), type, source});
                this.nodeBus.onNext((Object)new BusEvent<Dag.Node>(){

                    @Override
                    public BusEvent.Type getType() {
                        return type;
                    }

                    @Override
                    public String getSource() {
                        return source;
                    }

                    @Override
                    public Dag.Node get() {
                        return node;
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("[bus {}:{}] exception {} logged and re-thrown - type: {}, nodes: {}, source: {}", new Object[]{this.dagOnSteroids.getDag().getName(), this.scope, e.getMessage(), type, nodes, source});
            throw e;
        }
    }

    @Override
    public Observable<BusEvent<Dag.Node>> toObservable() {
        return this.nodeBus;
    }
}

