package net.aequologica.neo.dagr.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

import net.aequologica.neo.geppaequo.cmis.ECMHelper;
import net.aequologica.neo.geppaequo.document.DocumentHelper;

public final class DagDocumentSerializer extends DagAbstractSerializer {
    @Override
    public void write(Path path, Dag dag) throws IOException {
        final byte[] bytes = this.objectMapper.writeValueAsBytes(dag); // "Encoding used will be UTF-8."
        DocumentHelper.write(path, ECMHelper.createStream(bytes, "application/json"));
    }

    @Override
    public Dag read(Path path) throws IOException {
        try (final InputStream inputStream = DocumentHelper.getInputStream(path)) {
            if (inputStream == null) {
                throw new FileNotFoundException(path.toString());
            }
            Dag dag = read(inputStream);
            dag.setSource(path.toString());
            return dag;
        }
    }
}
