/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import java.util.List;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.model.Dag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

class NodeBus
implements Bus<Dag.Node> {
    private static final Logger LOG = LoggerFactory.getLogger(NodeBus.class);
    private final Subject<BusEvent<Dag.Node>, BusEvent<Dag.Node>> nodeBus = new SerializedSubject((Subject)PublishSubject.create());
    private final DagOnSteroids dagOnSteroids;
    private final Bus.Scope scope;

    NodeBus(DagOnSteroids dagOnSteroids, Bus.Scope scope) {
        this.dagOnSteroids = dagOnSteroids;
        this.scope = scope;
        LOG.debug("[bus {}] created bus for dag {}", (Object)scope, (Object)dagOnSteroids.getDag().getName());
    }

    @Override
    public Bus.Scope getScope() {
        return this.scope;
    }

    @Override
    public void send(final BusEvent.Type type, String nodeName, String branch, final String source) {
        try {
            DagOnSteroids.NodeCleaner.NodeState newState = type.equals((Object)BusEvent.Type.MAGIC_CLEAN) ? DagOnSteroids.NodeCleaner.NodeState.CLEAN : (type.equals((Object)BusEvent.Type.SMUDGE) ? DagOnSteroids.NodeCleaner.NodeState.DIRTY : (type.equals((Object)BusEvent.Type.CLEAN_ORDER_OK) ? DagOnSteroids.NodeCleaner.NodeState.CLEANING_ORDERED : (type.equals((Object)BusEvent.Type.CLEAN_ORDER_ERROR) ? DagOnSteroids.NodeCleaner.NodeState.UNCLEANABLE : (type.equals((Object)BusEvent.Type.CLEAN_STARTED) ? DagOnSteroids.NodeCleaner.NodeState.BEING_CLEANED : (type.equals((Object)BusEvent.Type.CLEAN_ERROR) ? DagOnSteroids.NodeCleaner.NodeState.FAIL : (type.equals((Object)BusEvent.Type.CLEAN_ABORTED) ? DagOnSteroids.NodeCleaner.NodeState.ABORTED : (type.equals((Object)BusEvent.Type.CLEAN_OK) ? DagOnSteroids.NodeCleaner.NodeState.CLEANED : null)))))));
            List<Dag.Node> nodes = DagOnSteroids.getNodesFromNamedAndBranchContains(this.dagOnSteroids.getDag(), nodeName, branch);
            LOG.debug("[bus {}] found {} nodes with nodeName='{}' and branch='{}' in dag '{}'", new Object[]{this.scope, nodes.size(), nodeName, branch, this.dagOnSteroids.getDag().getName()});
            for (final Dag.Node node : nodes) {
                DagOnSteroids.NodeCleaner.NodeState previousState = this.dagOnSteroids.getDagCleaner(this.scope).getNodeCleaner(node).getState();
                if (!(newState == null || previousState != null && previousState.equals((Object)newState))) {
                    this.dagOnSteroids.getDagCleaner(this.scope).getNodeCleaner(node).setState(newState);
                }
                LOG.debug("[bus {}] about to notify observers that state of node {} ({}) changed from {} to {}", new Object[]{this.scope, node.getName(), node.getId(), previousState, this.dagOnSteroids.getDagCleaner(this.scope).getNodeCleaner(node).getState()});
                this.nodeBus.onNext((Object)new BusEvent<Dag.Node>(){

                    @Override
                    public BusEvent.Type getType() {
                        return type;
                    }

                    @Override
                    public String getSource() {
                        return source;
                    }

                    @Override
                    public Dag.Node get() {
                        return node;
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error("[bus {}] exception {} logged and re-thrown", (Object)this.scope, (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public Observable<BusEvent<Dag.Node>> toObservable() {
        return this.nodeBus;
    }
}

