/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.aequologica.neo.dagr.DagOnSteroids;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.DagDocumentSerializer;
import net.aequologica.neo.geppaequo.document.DocumentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DagsSingleton {
    INSTANCE;

    public final Dags dags = new Dags();

    public static class Dags
    extends Observable {
        private static final Logger log = LoggerFactory.getLogger(Dags.class);
        private static final FileSystem fileSystem = FileSystems.getDefault();
        private static final DagDocumentSerializer serializer = new DagDocumentSerializer();
        private static final String DAGS_DIRECTORY = "/dags";
        private final Lock lockOnIO = new ReentrantLock();
        private final Map<String, DagOnSteroids> map = new HashMap<String, DagOnSteroids>();

        Dags() {
            this.loadDags();
        }

        public Set<String> getDagNames() {
            return this.map.keySet();
        }

        public Collection<DagOnSteroids> getDagOnSteroidss() {
            return this.map.values();
        }

        public List<Dag> getDAGs() {
            return this.map.values().stream().map(b -> b.getDag()).collect(Collectors.toList());
        }

        public DagOnSteroids getDagOnSteroids(String dagkey) {
            return this.map.get(dagkey);
        }

        public Dag getDAG(String dagkey) {
            DagOnSteroids dagOnSteroids = this.map.get(dagkey);
            return dagOnSteroids == null ? null : dagOnSteroids.getDag();
        }

        public Bus<Dag.Node> getBus(String dagName, Bus.Scope scope) {
            return this.getDagOnSteroids(dagName).getDagCleaner(scope).getBus();
        }

        public Collection<Map.Entry<String, Collection<Map.Entry<String, String>>>> loadDags() {
            this.lockOnIO.lock();
            try {
                List<Path> sources;
                ArrayList<Map.Entry<String, Collection<Map.Entry<String, String>>>> allExceptions = new ArrayList<Map.Entry<String, Collection<Map.Entry<String, String>>>>();
                this.setChanged();
                this.notifyObservers(Boolean.TRUE);
                this.map.clear();
                try {
                    sources = this.privateGetDagSources();
                }
                catch (Exception e) {
                    ArrayList<Map.Entry<String, String>> bigError = new ArrayList<Map.Entry<String, String>>();
                    bigError.add(Dags.tuple(e.getClass().getSimpleName(), e.getMessage()));
                    allExceptions.add(Dags.tuple("", bigError));
                    ArrayList<Map.Entry<String, Collection<Map.Entry<String, String>>>> arrayList = allExceptions;
                    this.lockOnIO.unlock();
                    return arrayList;
                }
                for (Path source : sources) {
                    PathMatcher matcher = fileSystem.getPathMatcher("regex:^.*\\.(properties|yml|hbs|gitmodules|xml|pom)$");
                    if (matcher.matches(source.getFileName())) continue;
                    allExceptions.add(this.privateLoadDag(null, source));
                }
                this.setChanged();
                this.notifyObservers(allExceptions);
                ArrayList<Map.Entry<String, Collection<Map.Entry<String, String>>>> arrayList = allExceptions;
                return arrayList;
            }
            finally {
                this.lockOnIO.unlock();
            }
        }

        public Map.Entry<String, Collection<Map.Entry<String, String>>> loadDag(String dagName) {
            this.lockOnIO.lock();
            try {
                Path source;
                this.setChanged();
                this.notifyObservers(dagName);
                Dag dag = this.getDAG(dagName);
                if (dag != null) {
                    source = Paths.get(dag.getSource(), new String[0]);
                } else {
                    try {
                        source = this.privateLocateSourceWithDagName(dagName);
                    }
                    catch (IOException e) {
                        ArrayList<Map.Entry<String, String>> exceptions = new ArrayList<Map.Entry<String, String>>();
                        exceptions.add(Dags.tuple(e.getClass().getSimpleName(), e.getMessage()));
                        Map.Entry<String, Collection<Map.Entry<String, String>>> entry = Dags.tuple(dagName, exceptions);
                        this.lockOnIO.unlock();
                        return entry;
                    }
                }
                Map.Entry<String, Collection<Map.Entry<String, String>>> thisDagExceptions = this.privateLoadDag(dagName, source);
                this.setChanged();
                this.notifyObservers(thisDagExceptions);
                Map.Entry<String, Collection<Map.Entry<String, String>>> entry = thisDagExceptions;
                return entry;
            }
            finally {
                this.lockOnIO.unlock();
            }
        }

        private Map.Entry<String, Collection<Map.Entry<String, String>>> privateLoadDag(String dagName, Path source) {
            if (source == null) {
                throw new IllegalArgumentException("source must be not null");
            }
            ArrayList<Map.Entry<String, String>> exceptions = new ArrayList<Map.Entry<String, String>>();
            try {
                Dag dag = serializer.read(source);
                if (dagName == null) {
                    dagName = dag.getName();
                }
                this.map.remove(dagName);
                dag.setSource(source.toString());
                PropertiesAndExceptions aliasesPAE = new PropertiesAndExceptions();
                aliasesPAE.load(Paths.get(source + ".aliases.properties", new String[0]));
                if (aliasesPAE.exceptions != null && aliasesPAE.exceptions.size() > 0) {
                    exceptions.addAll(aliasesPAE.exceptions);
                }
                PropertiesAndExceptions cleanerPAE = new PropertiesAndExceptions();
                cleanerPAE.load(Paths.get(source + ".cleaner.properties", new String[0]));
                if (cleanerPAE.exceptions != null && cleanerPAE.exceptions.size() > 0) {
                    exceptions.addAll(cleanerPAE.exceptions);
                }
                this.map.put(dag.getName(), new DagOnSteroids(dag, aliasesPAE.properties, cleanerPAE.properties));
            }
            catch (Exception e) {
                exceptions.add(Dags.tuple(e.getClass().getSimpleName(), e.getMessage()));
            }
            return Dags.tuple(dagName != null ? dagName : source.getFileName().toString(), exceptions);
        }

        public Bus<Dag.Node> getBusFromGithubRepository(String repo) {
            throw new UnsupportedOperationException();
        }

        public Bus<Dag.Node> getBusFromTravis(String owner_name, Object object) {
            throw new UnsupportedOperationException();
        }

        public String getDagFromGithubRepository(String repo) {
            throw new UnsupportedOperationException();
        }

        static void packageDumpDag(Path path, Dag dag) throws IOException {
            serializer.write(path, dag);
        }

        private static <T> Map.Entry<String, T> tuple(String a, T b) {
            return new AbstractMap.SimpleImmutableEntry<String, T>(a, b);
        }

        private Path privateLocateSourceWithDagName(String dagName) throws IOException {
            List<Path> sources = this.privateGetDagSources();
            for (Path source : sources) {
                Dag dag = serializer.read(source);
                if (!dag.getName().equals(dagName)) continue;
                return source;
            }
            List collect = sources.stream().map(s -> s.getFileName().toString()).collect(Collectors.toList());
            throw new IOException("no dag with name /" + dagName + "/ found in " + collect);
        }

        private List<Path> privateGetDagSources() throws IOException {
            List potentials = DocumentHelper.list((Path)Paths.get(DAGS_DIRECTORY, new String[0]));
            ArrayList<Path> sources = new ArrayList<Path>();
            PathMatcher matcher = fileSystem.getPathMatcher("regex:^.*\\.(properties|yml|hbs|gitmodules|xml|pom)$");
            for (Path source : potentials) {
                if (matcher.matches(source.getFileName())) continue;
                sources.add(source);
            }
            return sources;
        }

        private class PropertiesAndExceptions {
            Map<String, String> properties;
            final Collection<Map.Entry<String, String>> exceptions = new ArrayList<Map.Entry<String, String>>();

            private PropertiesAndExceptions() {
            }

            void load(Path propertiesPath) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (InputStream inputStream = DocumentHelper.getInputStream((Path)propertiesPath);){
                        if (inputStream == null) {
                            throw new IOException("no [" + propertiesPath + "] in document service");
                        }
                        try {
                            Properties properties = new Properties();
                            properties.load(new InputStreamReader(inputStream, "UTF-8"));
                            this.properties = properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
                        }
                        catch (Exception accumulated) {
                            this.exceptions.add(Dags.tuple(propertiesPath.getFileName().toString(), String.valueOf(accumulated.getClass().getSimpleName()) + " - " + accumulated.getMessage()));
                            this.properties = null;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ignored) {
                    log.info("ignored exception {} {}", (Object)ignored.getClass().getSimpleName(), (Object)ignored.getMessage());
                    this.properties = null;
                }
            }
        }
    }
}

