/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.aequologica.neo.dagr.NodeBus;
import net.aequologica.neo.dagr.bus.Bus;
import net.aequologica.neo.dagr.bus.BusEvent;
import net.aequologica.neo.dagr.model.Dag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingBiFunction;
import rx.Subscription;

public class DagOnSteroids {
    private static final Logger LOG = LoggerFactory.getLogger(DagOnSteroids.class);
    private static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private static final String SIMPLENAME = DagOnSteroids.class.getSimpleName();
    ThrowingBiFunction<Bus.Scope, Dag.Node, NodeCleaner.NodeCleaningResult, NodeCleaner.NodeCleanerException> cleaningFunction = (b, n) -> NodeCleaner.NodeCleaningResult.undefined(b);
    private final Dag dag;
    private final Map<String, String> properties;
    private final EnumMap<Bus.Scope, DagCleaner> dagCleaners;
    private Optional<String> subDagId;
    private static final Pattern DAGNAMECONTAINSSUB = Pattern.compile("(.*)%2Fsubs%2(.*)");

    public DagOnSteroids(Dag dag, Map<String, String> nodeAliases, Map<String, String> properties) {
        this.dag = dag;
        this.dagCleaners = new EnumMap(Bus.Scope.class);
        this.properties = properties != null ? properties : Collections.emptyMap();
        Bus.Scope[] scopeArray = Bus.Scope.values();
        int n2 = scopeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Bus.Scope scope = scopeArray[n3];
            this.dagCleaners.put(scope, new DagCleaner(new NodeBus(this, scope)));
            ++n3;
        }
        if (nodeAliases != null) {
            for (Dag.Node node : dag.getNodes()) {
                node.setAlias(nodeAliases.get(node.getName()));
            }
        }
        this.subDagId = Optional.ofNullable(null);
    }

    public Dag getDag() {
        return this.dag;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getSubDagId() {
        return this.subDagId.orElse(null);
    }

    public void setSubDagId(String subDagId) {
        this.subDagId = Optional.ofNullable(subDagId);
    }

    public List<Map.Entry<Bus.Scope, Bus<Dag.Node>>> getBusEntries() {
        return this.dagCleaners.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry<Bus.Scope, Bus<Dag.Node>>((Bus.Scope)((Object)((Object)e.getKey())), ((DagCleaner)e.getValue()).getBus())).collect(Collectors.toList());
    }

    public EnumMap<Bus.Scope, DagCleaner> getDagCleaners() {
        return this.dagCleaners;
    }

    public DagCleaner getDagCleaner(Bus.Scope scope) {
        return this.dagCleaners.get((Object)scope);
    }

    public ThrowingBiFunction<Bus.Scope, Dag.Node, NodeCleaner.NodeCleaningResult, NodeCleaner.NodeCleanerException> getCleaningFunction() {
        return this.cleaningFunction;
    }

    public void setCleaningFunction(ThrowingBiFunction<Bus.Scope, Dag.Node, NodeCleaner.NodeCleaningResult, NodeCleaner.NodeCleanerException> cleaningFunction) {
        this.cleaningFunction = cleaningFunction;
    }

    public NodeCleaner.NodeCleaningResult clean(Bus.Scope scope, Dag.Node node) throws NodeCleaner.NodeCleanerException {
        if (node == null) {
            throw new NodeCleaner.NodeCleanerException("no enclosing node");
        }
        if (this.cleaningFunction == null) {
            throw new NodeCleaner.NodeCleanerException("no cleaningFunction defined in enclosing dag");
        }
        return (NodeCleaner.NodeCleaningResult)this.cleaningFunction.apply((Object)scope, (Object)node);
    }

    public static List<Dag.Node> getNodesFromNamedAndBranchContains(Dag dag, String nodeName, String branchSubstring) {
        LinkedList<Dag.Node> ret = new LinkedList<Dag.Node>();
        for (Dag.Node node : dag.getNodesFromName(nodeName)) {
            if (!DagOnSteroids.containsBranchSubstring(node, branchSubstring)) continue;
            ret.add(node);
        }
        return ret;
    }

    private static boolean containsBranchSubstring(Dag.Node node, String branchSubstring) {
        String nodeBranch = node != null && node.getValue() != null && node.getValue().getBranch() != null ? node.getValue().getBranch() : null;
        if (nodeBranch == null && branchSubstring == null) {
            return true;
        }
        if (nodeBranch == null && branchSubstring == null) {
            return false;
        }
        return nodeBranch.contains(branchSubstring);
    }

    public static String[] parseName(String dagName) {
        Matcher dagNameContainsSub = DAGNAMECONTAINSSUB.matcher(dagName);
        if (dagNameContainsSub.matches()) {
            return new String[]{dagNameContainsSub.group(1), dagNameContainsSub.group(2)};
        }
        String[] stringArray = new String[2];
        stringArray[0] = dagName;
        return stringArray;
    }

    public final class DagCleaner {
        private final Bus<Dag.Node> bus;
        private final boolean failFast;
        private final boolean treatErrorsAsWarnings;
        private final Map<Dag.Node, NodeCleaner> nodeCleanerMap;
        private Journal journal;
        private Subscription subscription;

        public DagCleaner(Bus<Dag.Node> bus) {
            this.bus = bus;
            this.failFast = DagOnSteroids.this.properties.get("failFast") == null ? true : Boolean.valueOf((String)DagOnSteroids.this.properties.get("failFast"));
            this.treatErrorsAsWarnings = DagOnSteroids.this.properties.get("treatErrorsAsWarnings") == null ? false : Boolean.valueOf((String)DagOnSteroids.this.properties.get("treatErrorsAsWarnings"));
            this.nodeCleanerMap = new HashMap<Dag.Node, NodeCleaner>();
            for (Dag.Node node : DagOnSteroids.this.dag.getNodes()) {
                this.nodeCleanerMap.put(node, new NodeCleaner(this.bus.getScope(), node, NodeCleaner.NodeState.UNKNOWN));
            }
        }

        public Bus<Dag.Node> getBus() {
            return this.bus;
        }

        public NodeCleaner getNodeCleaner(Dag.Node node) {
            return this.nodeCleanerMap.get(node);
        }

        public void cleanAll() {
            this.cleanFromInclusive(null);
        }

        public void cleanFromInclusive(String onlyThisNodeAndSuccessors) {
            this.cleanFromInclusive(onlyThisNodeAndSuccessors, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanFromInclusive(String onlyThisNodeAndSuccessors, String subDagKey) {
            if (DagOnSteroids.this.getCleaningFunction() == null) {
                throw new RuntimeException("No cleaner defined. Check configuration.");
            }
            if (this.journal == null) {
                this.journal = new Journal();
            } else if (this.journal.isRunning()) {
                throw new RuntimeException("Cleaning already running. Wait for completion or cancel it before retrying.");
            }
            Set nodesToInclude = DagOnSteroids.this.dag.getNodes(subDagKey).stream().map(n -> n.getName()).collect(Collectors.toSet());
            Journal journal = this.journal;
            synchronized (journal) {
                this.journal.raz();
                this.journal.write("start first round");
                Dag.Node startNode = null;
                if (onlyThisNodeAndSuccessors != null) {
                    List nodesNamedAs = DagOnSteroids.this.dag.getNodesFromName(onlyThisNodeAndSuccessors);
                    if (nodesNamedAs.size() == 0) {
                        throw new RuntimeException("Cannot start cleaning: node /" + onlyThisNodeAndSuccessors + "/ not found");
                    }
                    if (nodesNamedAs.size() == 1) {
                        startNode = (Dag.Node)nodesNamedAs.get(0);
                    } else {
                        throw new RuntimeException("Cannot start cleaning: more than one node found with name /" + onlyThisNodeAndSuccessors + "/");
                    }
                }
                SortedSet successorsOf = null;
                for (Dag.Node node : DagOnSteroids.this.dag.getTopologicalNodes()) {
                    String branch;
                    String string = branch = node.getValue() != null ? node.getValue().getBranch() : null;
                    if (startNode != null && successorsOf == null) {
                        if (node.getName().equals(startNode.getName())) {
                            successorsOf = DagOnSteroids.this.dag.successorsOf(startNode).stream().map(n -> n.getName()).collect(Collectors.toCollection(() -> new TreeSet()));
                        } else {
                            this.bus.send(BusEvent.Type.MAGIC_CLEAN, node.getName(), branch, SIMPLENAME);
                            this.explainMagicClean(node, "topologically before start node", "(startnode=/" + startNode.getName() + "/)");
                            continue;
                        }
                    }
                    if (node.getValue() != null && node.getValue().getGucrid() != null && !node.getValue().getGucrid().contains("SNAPSHOT")) {
                        this.bus.send(BusEvent.Type.MAGIC_CLEAN, node.getName(), branch, SIMPLENAME);
                        this.explainMagicClean(node, "not a snapshot", node.getValue().getGucrid().toString());
                    } else if (!nodesToInclude.contains(node.getName())) {
                        this.bus.send(BusEvent.Type.MAGIC_CLEAN, node.getName(), branch, SIMPLENAME);
                        this.explainMagicClean(node, "not in sub dag", nodesToInclude.toString());
                    } else if (startNode != null && successorsOf != null && !startNode.getName().equals(node.getName()) && !successorsOf.contains(node.getName())) {
                        this.bus.send(BusEvent.Type.MAGIC_CLEAN, node.getName(), branch, SIMPLENAME);
                        this.explainMagicClean(node, "not start node or one of its successors", "(startnode=/" + startNode.getName() + "/)");
                    } else {
                        this.bus.send(BusEvent.Type.SMUDGE, node.getName(), branch, SIMPLENAME);
                    }
                    this.journal.write(String.format("set node /%s/ state to %s", new Object[]{node.getName(), this.getNodeCleaner(node).getState()}));
                }
                this.bus.toObservable().filter(event -> event.getType().equals((Object)BusEvent.Type.CLEAN_STARTED) || event.getType().equals((Object)BusEvent.Type.CLEAN_OK) || event.getType().equals((Object)BusEvent.Type.CLEAN_ERROR) || event.getType().equals((Object)BusEvent.Type.CLEAN_ABORTED)).subscribe(event -> {
                    Dag.Node node = (Dag.Node)event.get();
                    if (this.journal != null) {
                        this.journal.write(String.format("received event %s on node /%s/ from [ %s ]", new Object[]{event.getType(), node.getName(), event.getSource()}));
                        if (!this.journal.state.equals((Object)State.RUNNING)) {
                            this.journal.write(String.format("Cleaning is not running (state=%s), doing nothing.", this.journal.state.toString()));
                            return;
                        }
                    }
                    if (event.getType().equals((Object)BusEvent.Type.CLEAN_OK)) {
                        this.queue();
                    } else if (event.getType().equals((Object)BusEvent.Type.CLEAN_ERROR) || event.getType().equals((Object)BusEvent.Type.CLEAN_ABORTED)) {
                        this.error((Dag.Node)event.get());
                        if (this.treatErrorsAsWarnings) {
                            this.queue();
                        }
                    }
                    this.ifAllNodesAreCleanThenDone();
                });
                this.queue();
                this.journal.write("first round done");
            }
        }

        private void explainMagicClean(Dag.Node node, String reason, String optional) {
            this.journal.write(String.format("set node /%s/ state to %s: %s%s", new Object[]{node.getName(), NodeCleaner.NodeState.CLEAN, reason, optional != null ? " - " + optional : ""}));
        }

        public boolean isRunning() {
            if (this.journal == null) {
                return false;
            }
            return this.journal.isRunning();
        }

        public String getJournalAsString() {
            if (this.journal != null) {
                return this.journal.toString();
            }
            return "nothing to read";
        }

        public void done() {
            if (this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
            if (this.journal != null) {
                this.journal.done();
            }
        }

        public void error(Dag.Node error) {
            if (this.failFast && this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
            if (this.journal != null) {
                this.journal.error(error);
                if (this.failFast) {
                    this.journal.close();
                }
            }
        }

        public void cancel() {
            if (this.subscription != null) {
                this.subscription.unsubscribe();
                this.subscription = null;
            }
            if (this.journal != null) {
                this.journal.cancel();
            }
        }

        private void ifAllNodesAreCleanThenDone() {
            if (this.journal == null) {
                return;
            }
            if (!this.journal.state.equals((Object)State.RUNNING)) {
                return;
            }
            int doneCount = 0;
            Set nodesSubSet = DagOnSteroids.this.dag.getNodes(DagOnSteroids.this.getSubDagId());
            for (Dag.Node node : nodesSubSet) {
                NodeCleaner.NodeState state = this.getNodeCleaner(node).getState();
                if (state == null) continue;
                if (state.oneOf(NodeCleaner.NodeState.CLEAN, NodeCleaner.NodeState.CLEANED)) {
                    ++doneCount;
                    continue;
                }
                if (!this.treatErrorsAsWarnings || !state.oneOf(NodeCleaner.NodeState.FAIL, NodeCleaner.NodeState.ABORTED, NodeCleaner.NodeState.UNCLEANABLE)) continue;
                ++doneCount;
            }
            if (doneCount == nodesSubSet.size()) {
                this.done();
            }
        }

        private void orderCleaningOfNode(Dag.Node node) {
            String branch;
            NodeCleaner.NodeCleaningResult result;
            try {
                result = DagOnSteroids.this.clean(this.bus.getScope(), node);
            }
            catch (Exception e) {
                LOG.error("ordering cleaning of node /" + node.getName() + "/ failed. (caught exception is not rethrown but cleanNode function will return not zero + exception message)", (Throwable)e);
                result = NodeCleaner.NodeCleaningResult.fromException(this.bus.getScope(), e);
            }
            String string = branch = node.getValue() != null ? node.getValue().getBranch() : null;
            if (result != null && result.asBoolean()) {
                this.bus.send(BusEvent.Type.CLEAN_ORDER_OK, node.getName(), branch, SIMPLENAME);
                if (this.journal != null) {
                    this.journal.write(String.format("ordered cleaning of node /%s/", node.getName()));
                }
            } else {
                String error = result == null ? "null result" : String.valueOf(result.getStatus()) + " " + result.getReason();
                this.bus.send(BusEvent.Type.CLEAN_ORDER_ERROR, node.getName(), branch, error);
                if (this.journal != null) {
                    this.journal.write(String.format("cannot order cleaning of node /%s/: %s [%s]", node.getName(), result == null ? "null result" : String.valueOf(result.getStatus()) + " " + result.getReason(), result.getSource()));
                }
            }
        }

        private void queue() {
            if (this.journal != null) {
                this.journal.write("start inpecting queue");
            }
            for (Dag.Node node : DagOnSteroids.this.dag.getTopologicalNodes()) {
                NodeCleaner.NodeState thisState = this.getNodeCleaner(node).getState();
                if (!thisState.oneOf(NodeCleaner.NodeState.DIRTY)) continue;
                List predecessors = DagOnSteroids.this.dag.predecessorsOf(node);
                int doneCount = 0;
                int errorCount = 0;
                for (Dag.Node pred : predecessors) {
                    NodeCleaner.NodeState predState = this.getNodeCleaner(pred).getState();
                    if (predState == null) continue;
                    if (predState.oneOf(NodeCleaner.NodeState.CLEAN, NodeCleaner.NodeState.CLEANED)) {
                        ++doneCount;
                        continue;
                    }
                    if (!this.treatErrorsAsWarnings || !predState.oneOf(NodeCleaner.NodeState.FAIL, NodeCleaner.NodeState.ABORTED, NodeCleaner.NodeState.UNCLEANABLE)) continue;
                    ++doneCount;
                    ++errorCount;
                }
                if (doneCount != predecessors.size()) continue;
                if (this.journal != null) {
                    this.journal.write(String.format("node /%s/ is %s and all its predecessors (%d) are DONE (with %d error(s)) : time to clean it, isn't it?", new Object[]{node.getName(), thisState, doneCount, errorCount}));
                }
                this.orderCleaningOfNode(node);
            }
            if (this.journal != null) {
                this.journal.write("done inpecting queue");
            }
        }

        class Journal
        implements Closeable {
            private State state;
            private ByteArrayOutputStream baos;
            private BufferedWriter writer;
            private String results;

            Journal() {
                this.raz();
            }

            void raz() {
                this.state = State.RUNNING;
                this.results = null;
                this.baos = new ByteArrayOutputStream();
                this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)this.baos, StandardCharsets.UTF_8));
            }

            void write(String entry) {
                try {
                    LOG.debug(entry);
                    this.writer.newLine();
                    this.writer.write(FMT.format(new Date()));
                    this.writer.write(" (");
                    this.writer.write(DagCleaner.this.bus.getScope().toString());
                    this.writer.write(")");
                    this.writer.write(" [");
                    this.writer.write(Thread.currentThread().getName());
                    this.writer.write("] ");
                    this.writer.write(entry);
                    this.writer.flush();
                }
                catch (IOException e) {
                    LOG.warn("ignored exception {}", (Object)e.getMessage());
                }
            }

            boolean isRunning() {
                return this.state.equals((Object)State.RUNNING);
            }

            boolean isDone() {
                return this.state.equals((Object)State.DONE);
            }

            void done() {
                this.write("done!");
                this.state = State.DONE;
                this.close();
            }

            boolean isCanceled() {
                return this.state.equals((Object)State.CANCELLED);
            }

            void cancel() {
                this.write("cancelled by external action");
                this.state = State.CANCELLED;
                this.close();
            }

            void error(Dag.Node node) {
                this.write("node [ " + node.getName() + " ] in error");
            }

            @Override
            public void close() {
                for (Dag.Node node : DagOnSteroids.this.dag.getTopologicalNodes()) {
                    this.write("node /" + node.getName() + "/ state is " + DagCleaner.this.getNodeCleaner(node).toString());
                }
                this.results = this.toString();
                try {
                    this.writer.close();
                }
                catch (IOException e) {
                    LOG.warn("ignored exception {}", (Object)e.getMessage());
                }
            }

            public String toString() {
                if (this.results != null) {
                    return this.results;
                }
                return String.valueOf(this.state.toString()) + new String(this.baos.toByteArray(), StandardCharsets.UTF_8);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NodeCleaner {
        @JsonProperty
        private UUID id;
        @JsonProperty
        private final Dag.Node node;
        @JsonProperty
        private final Bus.Scope scope;
        @JsonProperty
        private NodeState state;
        @JsonIgnore
        private Long start;
        @JsonIgnore
        private Long stop;

        @JsonCreator
        public NodeCleaner(@JsonProperty(value="scope") Bus.Scope scope, @JsonProperty(value="node") Dag.Node node, @JsonProperty(value="state") NodeState state) {
            this.node = node;
            this.scope = scope;
            this.state = state;
        }

        public String getId() {
            return this.id == null ? null : this.id.toString();
        }

        public void setId(String id) {
            if (id == null) {
                this.id = null;
                if (this.start != null) {
                    this.stop = new Date().getTime();
                }
            } else {
                this.start = new Date().getTime();
                this.stop = null;
                if (id.matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")) {
                    this.id = UUID.fromString(id);
                }
            }
        }

        @JsonIgnore
        public Dag.Node getNode() {
            return this.node;
        }

        public NodeState getState() {
            return this.state;
        }

        public void setState(NodeState state) {
            this.state = state;
        }

        public Long getDuration() {
            if (this.start == null) {
                return null;
            }
            if (this.stop == null) {
                return new Date().getTime() - this.start;
            }
            return this.stop - this.start;
        }

        public static class NodeCleanerException
        extends Exception {
            private static final long serialVersionUID = -3468108554682441131L;
            public final URI source;

            public NodeCleanerException() {
                this((URI)null);
            }

            public NodeCleanerException(String arg0, Throwable arg1, boolean arg2, boolean arg3) {
                this(null, arg0, arg1, arg2, arg3);
            }

            public NodeCleanerException(String arg0, Throwable arg1) {
                this(null, arg0, arg1);
            }

            public NodeCleanerException(String arg0) {
                this(null, arg0);
            }

            public NodeCleanerException(Throwable arg0) {
                this((URI)null, arg0);
            }

            public NodeCleanerException(URI source, String arg0, Throwable arg1, boolean arg2, boolean arg3) {
                super(NodeCleanerException.addSourceToMessage(arg0, source), arg1, arg2, arg3);
                this.source = source;
            }

            public NodeCleanerException(URI source, String arg0, Throwable arg1) {
                super(NodeCleanerException.addSourceToMessage(arg0, source), arg1);
                this.source = source;
            }

            public NodeCleanerException(URI source, String arg0) {
                super(NodeCleanerException.addSourceToMessage(arg0, source));
                this.source = source;
            }

            public NodeCleanerException(URI source, Throwable arg0) {
                super(NodeCleanerException.sourceAsMessage(source), arg0);
                this.source = source;
            }

            public NodeCleanerException(URI source) {
                super(NodeCleanerException.sourceAsMessage(source));
                this.source = source;
            }

            private static final String addSourceToMessage(String message, URI source) {
                return String.valueOf(message) + (source != null ? " - source: " + source.toString() : "");
            }

            private static final String sourceAsMessage(URI source) {
                return source != null ? "source: " + source.toString() : "";
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static class NodeCleaningResult {
            private final Bus.Scope scope;
            private final int status;
            private final String reason;
            private String source;

            @JsonCreator
            public NodeCleaningResult(@JsonProperty(value="bus") Bus.Scope scope, @JsonProperty(value="status") int status, @JsonProperty(value="reason") String reason) {
                this.scope = scope;
                this.status = status;
                this.reason = reason;
            }

            public Bus.Scope getScope() {
                return this.scope;
            }

            public int getStatus() {
                return this.status;
            }

            public String getReason() {
                return this.reason;
            }

            public String getSource() {
                return this.source;
            }

            public void setSource(String source) {
                this.source = source;
            }

            @JsonIgnore
            public NodeCleaningResult source(String source) {
                this.setSource(source);
                return this;
            }

            @JsonIgnore
            public boolean asBoolean() {
                return this.status == 0 || this.status / 100 == 2;
            }

            public static NodeCleaningResult undefined(Bus.Scope c) {
                return new NodeCleaningResult(c, -1, "undefined");
            }

            public static NodeCleaningResult fromException(Bus.Scope c, Exception e) {
                return new NodeCleaningResult(c, -1, e.getMessage());
            }

            public static NodeCleaningResult ok(Bus.Scope c) {
                return new NodeCleaningResult(c, 0, "");
            }

            public static NodeCleaningResult from(Bus.Scope c, int status, String reason) {
                return new NodeCleaningResult(c, status, reason);
            }
        }

        public static enum NodeState {
            UNKNOWN,
            CLEAN,
            DIRTY,
            CLEANING_ORDERED,
            BEING_CLEANED,
            UNCLEANABLE,
            CLEANED,
            FAIL,
            ABORTED;


            public static String gimmethestuff() {
                return Joiner.on((String)" ").join((Object[])NodeState.values()).toString();
            }

            public boolean oneOf(NodeState ... others) {
                NodeState[] nodeStateArray = others;
                int n = others.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeState other = nodeStateArray[n2];
                    if (this.equals((Object)other)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        }
    }

    private static enum State {
        RUNNING,
        DONE,
        CANCELLED;

    }
}

