/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.net.MediaType;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Singleton;
import net.aequologica.neo.dagr.jgrapht.DagJGraphT;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.DagDocumentSerializer;
import net.aequologica.neo.geppaequo.cmis.ECMHelper;
import net.aequologica.neo.geppaequo.document.DocumentHelper;

@Singleton
public class Dags {
    private static DagDocumentSerializer serializer = new DagDocumentSerializer();
    private final Map<String, Dag> dagmap;
    private final Map<String, DagJGraphT> graphmap;
    private final SetMultimap<String, String> user2dags;
    private final SetMultimap<String, String> dag2users;
    private final Path userDagTuplesPath;
    private final ObjectMapper mapper;
    private final Lock lockOnIO = new ReentrantLock();

    public Dags() {
        this.userDagTuplesPath = Paths.get("/.dagr/userdagtuples.json", new String[0]);
        this.mapper = new ObjectMapper();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.dagmap = new HashMap<String, Dag>();
        this.graphmap = new HashMap<String, DagJGraphT>();
        this.user2dags = HashMultimap.create();
        this.dag2users = HashMultimap.create();
        this.load();
    }

    public Collection<Dag> getDAGs() {
        return this.dagmap.values();
    }

    public Set<String> getDAGKeys() {
        return this.dagmap.keySet();
    }

    public Dag getDAG(String dagkey) {
        return this.dagmap.get(dagkey);
    }

    public DagJGraphT getDagJGraphT(String dagkey) {
        return this.graphmap.get(dagkey);
    }

    public List<Dag> getUserDAGs(String username) {
        Set thisUserDags = this.user2dags.get((Object)username);
        ArrayList<Dag> ret = new ArrayList<Dag>(thisUserDags.size());
        for (String dagkey : thisUserDags) {
            Dag dag = this.dagmap.get(dagkey);
            if (dag == null) continue;
            ret.add(dag);
        }
        return ret;
    }

    public List<Dag.Node> getNodesByScmAndBranch(String scm, String branch) {
        LinkedList<Dag.Node> ret = new LinkedList<Dag.Node>();
        Collection<Dag> dags = this.dagmap.values();
        for (Dag dag : dags) {
            List nodes = dag.getNodes();
            for (Dag.Node node : nodes) {
                if (node.getValue() == null || node.getValue().getScm() == null || node.getValue().getBranch() == null || -1 == node.getValue().getScm().indexOf(scm) || -1 == node.getValue().getBranch().indexOf(branch)) continue;
                ret.add(node);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map.Entry<String, String>> load() {
        this.lockOnIO.lock();
        try {
            List sources;
            Path path = Paths.get("/dags", new String[0]);
            ArrayList exceptions = Lists.newArrayList();
            this.dagmap.clear();
            this.graphmap.clear();
            try {
                sources = DocumentHelper.list((Path)path);
            }
            catch (Exception e) {
                exceptions.add(new AbstractMap.SimpleImmutableEntry<String, String>(path.toString(), e.getClass().getSimpleName() + " - " + e.getMessage()));
                ArrayList arrayList = exceptions;
                this.lockOnIO.unlock();
                return arrayList;
            }
            for (Path source : sources) {
                try {
                    Dag tmpDag;
                    String lowerCase = source.getFileName().toString().toLowerCase();
                    if (lowerCase.endsWith(this.userDagTuplesPath.getFileName().toString()) || (tmpDag = serializer.read(source)) == null) continue;
                    Dag dag = new DagJGraphT(tmpDag).detectAndFlagTransitiveEdges();
                    dag.setSource(source.toString());
                    String dagkey = source.getFileName().toString();
                    dag.setKey(dagkey);
                    this.dagmap.put(dagkey, dag);
                    this.graphmap.put(dagkey, new DagJGraphT(dag));
                }
                catch (Exception e) {
                    exceptions.add(new AbstractMap.SimpleImmutableEntry<String, String>(source.toString(), e.getClass().getSimpleName() + " - " + e.getMessage()));
                }
            }
            try {
                this.readUserDagTuples(this.userDagTuplesPath);
            }
            catch (IOException e) {
                exceptions.add(new AbstractMap.SimpleImmutableEntry<String, String>(this.userDagTuplesPath.toString(), e.getClass().getSimpleName() + " - " + e.getMessage()));
            }
            ArrayList arrayList = exceptions;
            return arrayList;
        }
        finally {
            this.lockOnIO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subscribe(String dagkey, String username) throws IOException {
        Dag dag = this.dagmap.get(dagkey);
        if (dag == null) {
            throw new IOException("[" + dagkey + "] not found");
        }
        SetMultimap<String, String> setMultimap = this.user2dags;
        synchronized (setMultimap) {
            SetMultimap<String, String> setMultimap2 = this.dag2users;
            synchronized (setMultimap2) {
                this.user2dags.put((Object)username, (Object)dagkey);
                this.dag2users.put((Object)dagkey, (Object)username);
            }
        }
        this.writeUserDagTuples(this.userDagTuplesPath);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unsubscribe(String dagkey, String username) throws IOException {
        Dag dag = this.dagmap.get(dagkey);
        if (dag == null) {
            throw new IOException("[" + dagkey + "] not found");
        }
        SetMultimap<String, String> setMultimap = this.user2dags;
        synchronized (setMultimap) {
            SetMultimap<String, String> setMultimap2 = this.dag2users;
            synchronized (setMultimap2) {
                this.user2dags.remove((Object)username, (Object)dagkey);
                this.dag2users.remove((Object)dagkey, (Object)username);
            }
        }
        this.writeUserDagTuples(this.userDagTuplesPath);
        return true;
    }

    public Boolean isUserSubscribed(String dagkey, String username) {
        Set existingUsers = this.dag2users.get((Object)dagkey);
        return existingUsers.contains(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUserDagTuples(Path path) throws JsonProcessingException, IOException {
        this.lockOnIO.lock();
        try {
            ArrayList<UserDagTuple> userdags = new ArrayList<UserDagTuple>();
            Set entries = this.user2dags.entries();
            for (Map.Entry entry : entries) {
                userdags.add(new UserDagTuple((String)entry.getKey(), (String)entry.getValue()));
            }
            final byte[] bytes = this.mapper.writeValueAsBytes(userdags);
            DocumentHelper.write((Path)path, (ECMHelper.Stream)new ECMHelper.Stream(){

                public String getMimeType() {
                    return MediaType.JSON_UTF_8.toString();
                }

                public long getLength() {
                    return bytes.length;
                }

                public InputStream getInputStream() {
                    return new ByteArrayInputStream(bytes);
                }
            });
        }
        finally {
            this.lockOnIO.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUserDagTuples(Path path) throws IOException {
        this.lockOnIO.lock();
        try {
            this.user2dags.clear();
            this.dag2users.clear();
            InputStream inputStream = DocumentHelper.getInputStream((Path)path);
            if (inputStream == null) {
                throw new FileNotFoundException(path.toString());
            }
            List userdags = (List)this.mapper.readValue(inputStream, (TypeReference)new TypeReference<List<UserDagTuple>>(){});
            for (UserDagTuple tuple : userdags) {
                this.user2dags.put((Object)tuple.user, (Object)tuple.dag);
                this.dag2users.put((Object)tuple.dag, (Object)tuple.user);
            }
        }
        finally {
            this.lockOnIO.unlock();
        }
    }

    public static void dumpDag(Path path, Dag dag) throws IOException {
        serializer.write(path, dag);
    }

    private static class UserDagTuple {
        @JsonProperty
        String user;
        @JsonProperty
        String dag;

        private UserDagTuple() {
        }

        private UserDagTuple(String user, String dag) {
            this.user = user;
            this.dag = dag;
        }
    }
}

