/*
 * Decompiled with CFR 0.152.
 */
package net.aequologica.neo.dagr.jgrapht;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.aequologica.neo.dagr.jgrapht.TransitiveReduction;
import net.aequologica.neo.dagr.model.Dag;
import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

public class DagJGraphT {
    private final Dag dag;
    private final DirectedAcyclicGraph<Dag.Node, DefaultEdge> g;

    public DagJGraphT(Dag dag) {
        this.dag = dag;
        this.g = this.fromDag(dag);
    }

    private DirectedAcyclicGraph<Dag.Node, DefaultEdge> fromDag(Dag dag) {
        DirectedAcyclicGraph g = new DirectedAcyclicGraph(DefaultEdge.class);
        for (Dag.Node node : dag.getNodes()) {
            g.addVertex((Object)node);
        }
        for (Dag.Link link : dag.getLinks()) {
            g.addEdge((Object)dag.getNode(link.getU()), (Object)dag.getNode(link.getV()));
        }
        return g;
    }

    public Iterator<Dag.Node> getTopologicalOrderIterator() {
        return new TopologicalOrderIterator(this.g);
    }

    public List<Dag.Node> getTopologicalOrder() {
        return Lists.newArrayList(this.getTopologicalOrderIterator());
    }

    public Dag detectAndFlagTransitiveEdges() {
        Dag dagCloneWithoutParentLinks = new Dag(this.dag);
        ArrayList<Dag.Link> noParents = new ArrayList<Dag.Link>(this.dag.getLinks().size());
        ArrayList<Dag.Link> onlyParents = new ArrayList<Dag.Link>(this.dag.getLinks().size());
        for (Dag.Link l : this.dag.getLinks()) {
            if (l.getValue().getStyle() == null || l.getValue().getStyle().isEmpty()) {
                noParents.add(l);
                continue;
            }
            onlyParents.add(l);
        }
        dagCloneWithoutParentLinks.setLinks(noParents);
        DirectedAcyclicGraph<Dag.Node, DefaultEdge> prunedDirectedGraph = new DagJGraphT((Dag)dagCloneWithoutParentLinks).g;
        new TransitiveReduction<Dag.Node, DefaultEdge>().reduce((DirectedGraph<Dag.Node, DefaultEdge>)prunedDirectedGraph);
        for (Dag.Link link : this.dag.getLinks()) {
            DefaultEdge lookup = (DefaultEdge)prunedDirectedGraph.getEdge((Object)this.dag.getNode(link.getU()), (Object)this.dag.getNode(link.getV()));
            if (lookup != null || link.getClazz() != null && !link.getClazz().equals("default")) continue;
            link.setClazz("transitive");
        }
        return this.dag;
    }
}

