package net.aequologica.neo.dagr.jgrapht;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.dag.DirectedAcyclicGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

import com.google.common.collect.Lists;

import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.dagr.model.Dag.Link;
import net.aequologica.neo.dagr.model.Dag.Node;

public class DagJGraphT {

    private final Dag dag;
    private final DirectedAcyclicGraph<Node, DefaultEdge> g;

    public DagJGraphT(Dag dag) {
        super();
        this.dag = dag;
        this.g = fromDag(dag);
    }
    
    private DirectedAcyclicGraph<Node, DefaultEdge> fromDag(Dag dag) {
        DirectedAcyclicGraph<Node, DefaultEdge> g = new DirectedAcyclicGraph<>(DefaultEdge.class);
        for (Node node : dag.getNodes()) {
            g.addVertex(node);
        }
        for (Link link : dag.getLinks()) {
            g.addEdge(dag.getNode(link.getU()), dag.getNode(link.getV()));
        };
        return g;
    }

    public Iterator<Node> getTopologicalOrderIterator() {
        return new TopologicalOrderIterator<Node, DefaultEdge>(this.g);
    }

    public List<Node> getTopologicalOrder() {
        return Lists.newArrayList(getTopologicalOrderIterator());
    }

    public Dag detectAndFlagTransitiveEdges() {
        // remove parent links
        Dag dagCloneWithoutParentLinks = new Dag(this.dag);
        List<Link> noParents   = new ArrayList<Link>(this.dag.getLinks().size());
        List<Link> onlyParents = new ArrayList<Link>(this.dag.getLinks().size());;
        for(Link l : this.dag.getLinks()) {
           if (l.getValue().getStyle() == null || l.getValue().getStyle().isEmpty()) {
               noParents.add(l);
           } else {
               onlyParents.add(l);
           }
        }
        dagCloneWithoutParentLinks.setLinks(noParents);
        
        // transitive reduction
        DirectedGraph<Node,DefaultEdge> prunedDirectedGraph = new DagJGraphT(dagCloneWithoutParentLinks).g;
        
        new TransitiveReduction<Node, DefaultEdge>().reduce(prunedDirectedGraph);

        // if link not in graph it has been pruned by transitive reduction
        for (Link link : dag.getLinks()) {
            DefaultEdge lookup = prunedDirectedGraph.getEdge(dag.getNode(link.getU()), dag.getNode(link.getV()));
            if (lookup == null) {
                if (link.getClazz() == null || link.getClazz().equals("default")) {
                    link.setClazz("transitive");
                }
            }
        }

        return dag;
    }

}
