package net.aequologica.neo.dagr.model;

import static com.google.common.net.MediaType.JSON_UTF_8;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;

import net.aequologica.neo.dagr.model.AbstractDagSerializer;
import net.aequologica.neo.dagr.model.Dag;
import net.aequologica.neo.geppaequo.cmis.ECMHelper.Stream;
import net.aequologica.neo.geppaequo.document.DocumentHelper;

public final class DagDocumentSerializer extends AbstractDagSerializer {
    @Override
    public void write(Path path, Dag dag) throws IOException {
        final byte[] bytes = this.objectMapper.writeValueAsBytes(dag); // "Encoding used will be UTF-8."
        DocumentHelper.write(path, new Stream() {
            @Override public String      getMimeType()      { return JSON_UTF_8.toString(); }
            @Override public long        getLength()        { return bytes.length; }
            @Override public InputStream getInputStream()   { return new ByteArrayInputStream(bytes); }
        });
    }

    @Override
    public Dag read(Path path) throws IOException {
        final InputStream inputStream = DocumentHelper.getInputStream(path);
        if (inputStream == null) {
            throw new FileNotFoundException(path.toString());
        }
        return read(inputStream);
    }
}
