/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_staging_content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsStagingContentResponse;
import net.accelbyte.sdk.api.ugc.models.ModelsUpdateStagingContentRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class UpdateStagingContent
extends Operation {
    private String path = "/ugc/v2/public/namespaces/{namespace}/users/{userId}/staging-contents/{contentId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String contentId;
    private String namespace;
    private String userId;
    private ModelsUpdateStagingContentRequest body;

    @Deprecated
    public UpdateStagingContent(String customBasePath, String contentId, String namespace, String userId, ModelsUpdateStagingContentRequest body) {
        this.contentId = contentId;
        this.namespace = namespace;
        this.userId = userId;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.contentId != null) {
            pathParams.put("contentId", this.contentId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public ModelsUpdateStagingContentRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.contentId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelsStagingContentResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsStagingContentResponse().createFromJson(json);
    }

    public static UpdateStagingContentBuilder builder() {
        return new UpdateStagingContentBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public ModelsUpdateStagingContentRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBody(ModelsUpdateStagingContentRequest body) {
        this.body = body;
    }

    public static class UpdateStagingContentBuilder {
        private String customBasePath;
        private String contentId;
        private String namespace;
        private String userId;
        private ModelsUpdateStagingContentRequest body;

        UpdateStagingContentBuilder() {
        }

        public UpdateStagingContentBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public UpdateStagingContentBuilder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public UpdateStagingContentBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public UpdateStagingContentBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public UpdateStagingContentBuilder body(ModelsUpdateStagingContentRequest body) {
            this.body = body;
            return this;
        }

        public UpdateStagingContent build() {
            return new UpdateStagingContent(this.customBasePath, this.contentId, this.namespace, this.userId, this.body);
        }

        public String toString() {
            return "UpdateStagingContent.UpdateStagingContentBuilder(customBasePath=" + this.customBasePath + ", contentId=" + this.contentId + ", namespace=" + this.namespace + ", userId=" + this.userId + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

