/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.public_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedContentDownloadResponseV2;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class PublicGetContentByChannelIDV2
extends Operation {
    private String path = "/ugc/v2/public/namespaces/{namespace}/channels/{channelId}/contents";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json", "application/octet-stream");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String channelId;
    private String namespace;
    private Integer limit;
    private String name;
    private Integer offset;
    private String sortBy;

    @Deprecated
    public PublicGetContentByChannelIDV2(String customBasePath, String channelId, String namespace, Integer limit, String name, Integer offset, String sortBy) {
        this.channelId = channelId;
        this.namespace = namespace;
        this.limit = limit;
        this.name = name;
        this.offset = offset;
        this.sortBy = sortBy;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.channelId != null) {
            pathParams.put("channelId", this.channelId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("name", this.name == null ? null : Arrays.asList(this.name));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        return queryParams;
    }

    public boolean isValid() {
        if (this.channelId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsPaginatedContentDownloadResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedContentDownloadResponseV2().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("name", "None");
        result.put("offset", "None");
        result.put("sortBy", "None");
        return result;
    }

    public static PublicGetContentByChannelIDV2Builder builder() {
        return new PublicGetContentByChannelIDV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public static class PublicGetContentByChannelIDV2Builder {
        private String customBasePath;
        private String channelId;
        private String namespace;
        private Integer limit;
        private String name;
        private Integer offset;
        private String sortBy;

        PublicGetContentByChannelIDV2Builder() {
        }

        public PublicGetContentByChannelIDV2Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public PublicGetContentByChannelIDV2Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public PublicGetContentByChannelIDV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public PublicGetContentByChannelIDV2Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public PublicGetContentByChannelIDV2Builder name(String name) {
            this.name = name;
            return this;
        }

        public PublicGetContentByChannelIDV2Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public PublicGetContentByChannelIDV2Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public PublicGetContentByChannelIDV2 build() {
            return new PublicGetContentByChannelIDV2(this.customBasePath, this.channelId, this.namespace, this.limit, this.name, this.offset, this.sortBy);
        }

        public String toString() {
            return "PublicGetContentByChannelIDV2.PublicGetContentByChannelIDV2Builder(customBasePath=" + this.customBasePath + ", channelId=" + this.channelId + ", namespace=" + this.namespace + ", limit=" + this.limit + ", name=" + this.name + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ")";
        }
    }
}

