/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_staging_content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedListStagingContentResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminListUserStagingContents
extends Operation {
    private String path = "/ugc/v2/admin/namespaces/{namespace}/users/{userId}/staging-contents";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private Integer limit;
    private Integer offset;
    private String sortBy;
    private String status;

    @Deprecated
    public AdminListUserStagingContents(String customBasePath, String namespace, String userId, Integer limit, Integer offset, String sortBy, String status) {
        this.namespace = namespace;
        this.userId = userId;
        this.limit = limit;
        this.offset = offset;
        this.sortBy = sortBy;
        this.status = status;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("status", this.status == null ? null : Arrays.asList(this.status));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelsPaginatedListStagingContentResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedListStagingContentResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("offset", "None");
        result.put("sortBy", "None");
        result.put("status", "None");
        return result;
    }

    public static AdminListUserStagingContentsBuilder builder() {
        return new AdminListUserStagingContentsBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getStatus() {
        return this.status;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public static class AdminListUserStagingContentsBuilder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private Integer limit;
        private Integer offset;
        private String sortBy;
        private String status;

        AdminListUserStagingContentsBuilder() {
        }

        public AdminListUserStagingContentsBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminListUserStagingContentsBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminListUserStagingContentsBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminListUserStagingContentsBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminListUserStagingContentsBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminListUserStagingContentsBuilder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public AdminListUserStagingContentsBuilder status(String status) {
            this.status = status;
            return this;
        }

        public AdminListUserStagingContents build() {
            return new AdminListUserStagingContents(this.customBasePath, this.namespace, this.userId, this.limit, this.offset, this.sortBy, this.status);
        }

        public String toString() {
            return "AdminListUserStagingContents.AdminListUserStagingContentsBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", limit=" + this.limit + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ", status=" + this.status + ")";
        }
    }
}

