/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsContentDownloadResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class RollbackContentVersionV2
extends Operation {
    private String path = "/ugc/v2/admin/namespaces/{namespace}/contents/{contentId}/rollback/{versionId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("*/*");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String contentId;
    private String namespace;
    private String versionId;

    @Deprecated
    public RollbackContentVersionV2(String customBasePath, String contentId, String namespace, String versionId) {
        this.contentId = contentId;
        this.namespace = namespace;
        this.versionId = versionId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.contentId != null) {
            pathParams.put("contentId", this.contentId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.versionId != null) {
            pathParams.put("versionId", this.versionId);
        }
        return pathParams;
    }

    public boolean isValid() {
        if (this.contentId == null) {
            return false;
        }
        if (this.namespace == null) {
            return false;
        }
        return this.versionId != null;
    }

    public ModelsContentDownloadResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsContentDownloadResponse().createFromJson(json);
    }

    public static RollbackContentVersionV2Builder builder() {
        return new RollbackContentVersionV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public static class RollbackContentVersionV2Builder {
        private String customBasePath;
        private String contentId;
        private String namespace;
        private String versionId;

        RollbackContentVersionV2Builder() {
        }

        public RollbackContentVersionV2Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public RollbackContentVersionV2Builder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public RollbackContentVersionV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public RollbackContentVersionV2Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public RollbackContentVersionV2 build() {
            return new RollbackContentVersionV2(this.customBasePath, this.contentId, this.namespace, this.versionId);
        }

        public String toString() {
            return "RollbackContentVersionV2.RollbackContentVersionV2Builder(customBasePath=" + this.customBasePath + ", contentId=" + this.contentId + ", namespace=" + this.namespace + ", versionId=" + this.versionId + ")";
        }
    }
}

