/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedContentDownloadResponseV2;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminListContentV2
extends Operation {
    private String path = "/ugc/v2/admin/namespaces/{namespace}/contents";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private Boolean isOfficial;
    private Integer limit;
    private String name;
    private Integer offset;
    private String sortBy;
    private String subType;
    private List<String> tags;
    private String type;

    @Deprecated
    public AdminListContentV2(String customBasePath, String namespace, Boolean isOfficial, Integer limit, String name, Integer offset, String sortBy, String subType, List<String> tags, String type) {
        this.namespace = namespace;
        this.isOfficial = isOfficial;
        this.limit = limit;
        this.name = name;
        this.offset = offset;
        this.sortBy = sortBy;
        this.subType = subType;
        this.tags = tags;
        this.type = type;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("isOfficial", this.isOfficial == null ? null : Arrays.asList(String.valueOf(this.isOfficial)));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("name", this.name == null ? null : Arrays.asList(this.name));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("sortBy", this.sortBy == null ? null : Arrays.asList(this.sortBy));
        queryParams.put("subType", this.subType == null ? null : Arrays.asList(this.subType));
        queryParams.put("tags", this.tags == null ? null : this.tags.stream().map(i -> String.valueOf(i)).collect(Collectors.toList()));
        queryParams.put("type", this.type == null ? null : Arrays.asList(this.type));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelsPaginatedContentDownloadResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedContentDownloadResponseV2().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("isOfficial", "None");
        result.put("limit", "None");
        result.put("name", "None");
        result.put("offset", "None");
        result.put("sortBy", "None");
        result.put("subType", "None");
        result.put("tags", "csv");
        result.put("type", "None");
        return result;
    }

    public static AdminListContentV2Builder builder() {
        return new AdminListContentV2Builder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Boolean getIsOfficial() {
        return this.isOfficial;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public String getSubType() {
        return this.subType;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getType() {
        return this.type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setIsOfficial(Boolean isOfficial) {
        this.isOfficial = isOfficial;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static class AdminListContentV2Builder {
        private String customBasePath;
        private String namespace;
        private Boolean isOfficial;
        private Integer limit;
        private String name;
        private Integer offset;
        private String sortBy;
        private String subType;
        private List<String> tags;
        private String type;

        AdminListContentV2Builder() {
        }

        public AdminListContentV2Builder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminListContentV2Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminListContentV2Builder isOfficial(Boolean isOfficial) {
            this.isOfficial = isOfficial;
            return this;
        }

        public AdminListContentV2Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminListContentV2Builder name(String name) {
            this.name = name;
            return this;
        }

        public AdminListContentV2Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminListContentV2Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public AdminListContentV2Builder subType(String subType) {
            this.subType = subType;
            return this;
        }

        public AdminListContentV2Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public AdminListContentV2Builder type(String type) {
            this.type = type;
            return this;
        }

        public AdminListContentV2 build() {
            return new AdminListContentV2(this.customBasePath, this.namespace, this.isOfficial, this.limit, this.name, this.offset, this.sortBy, this.subType, this.tags, this.type);
        }

        public String toString() {
            return "AdminListContentV2.AdminListContentV2Builder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", isOfficial=" + this.isOfficial + ", limit=" + this.limit + ", name=" + this.name + ", offset=" + this.offset + ", sortBy=" + this.sortBy + ", subType=" + this.subType + ", tags=" + this.tags + ", type=" + this.type + ")";
        }
    }
}

