/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_content_v2;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsContentDownloadResponseV2;
import net.accelbyte.sdk.api.ugc.models.ModelsCopyContentRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminCopyContent
extends Operation {
    private String path = "/ugc/v2/admin/namespaces/{namespace}/channels/{channelId}/contents/{contentId}/copy";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String channelId;
    private String contentId;
    private String namespace;
    private ModelsCopyContentRequest body;

    @Deprecated
    public AdminCopyContent(String customBasePath, String channelId, String contentId, String namespace, ModelsCopyContentRequest body) {
        this.channelId = channelId;
        this.contentId = contentId;
        this.namespace = namespace;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.channelId != null) {
            pathParams.put("channelId", this.channelId);
        }
        if (this.contentId != null) {
            pathParams.put("contentId", this.contentId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelsCopyContentRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.channelId == null) {
            return false;
        }
        if (this.contentId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsContentDownloadResponseV2 parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 201) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsContentDownloadResponseV2().createFromJson(json);
    }

    public static AdminCopyContentBuilder builder() {
        return new AdminCopyContentBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelsCopyContentRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelsCopyContentRequest body) {
        this.body = body;
    }

    public static class AdminCopyContentBuilder {
        private String customBasePath;
        private String channelId;
        private String contentId;
        private String namespace;
        private ModelsCopyContentRequest body;

        AdminCopyContentBuilder() {
        }

        public AdminCopyContentBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminCopyContentBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public AdminCopyContentBuilder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }

        public AdminCopyContentBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminCopyContentBuilder body(ModelsCopyContentRequest body) {
            this.body = body;
            return this;
        }

        public AdminCopyContent build() {
            return new AdminCopyContent(this.customBasePath, this.channelId, this.contentId, this.namespace, this.body);
        }

        public String toString() {
            return "AdminCopyContent.AdminCopyContentBuilder(customBasePath=" + this.customBasePath + ", channelId=" + this.channelId + ", contentId=" + this.contentId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

