/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_content;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedContentDownloadResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminSearchContent
extends Operation {
    private String path = "/ugc/v1/admin/namespaces/{namespace}/contents/search";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String creator;
    private String ishidden;
    private String isofficial;
    private Integer limit;
    private String name;
    private Integer offset;
    private String orderby;
    private String sortby;
    private String subtype;
    private List<String> tags;
    private String type;
    private String userId;

    @Deprecated
    public AdminSearchContent(String customBasePath, String namespace, String creator, String ishidden, String isofficial, Integer limit, String name, Integer offset, String orderby, String sortby, String subtype, List<String> tags, String type, String userId) {
        this.namespace = namespace;
        this.creator = creator;
        this.ishidden = ishidden;
        this.isofficial = isofficial;
        this.limit = limit;
        this.name = name;
        this.offset = offset;
        this.orderby = orderby;
        this.sortby = sortby;
        this.subtype = subtype;
        this.tags = tags;
        this.type = type;
        this.userId = userId;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("creator", this.creator == null ? null : Arrays.asList(this.creator));
        queryParams.put("ishidden", this.ishidden == null ? null : Arrays.asList(this.ishidden));
        queryParams.put("isofficial", this.isofficial == null ? null : Arrays.asList(this.isofficial));
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("name", this.name == null ? null : Arrays.asList(this.name));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        queryParams.put("orderby", this.orderby == null ? null : Arrays.asList(this.orderby));
        queryParams.put("sortby", this.sortby == null ? null : Arrays.asList(this.sortby));
        queryParams.put("subtype", this.subtype == null ? null : Arrays.asList(this.subtype));
        queryParams.put("tags", this.tags == null ? null : this.tags.stream().map(i -> String.valueOf(i)).collect(Collectors.toList()));
        queryParams.put("type", this.type == null ? null : Arrays.asList(this.type));
        queryParams.put("userId", this.userId == null ? null : Arrays.asList(this.userId));
        return queryParams;
    }

    public boolean isValid() {
        return this.namespace != null;
    }

    public ModelsPaginatedContentDownloadResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedContentDownloadResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("creator", "None");
        result.put("ishidden", "None");
        result.put("isofficial", "None");
        result.put("limit", "None");
        result.put("name", "None");
        result.put("offset", "None");
        result.put("orderby", "None");
        result.put("sortby", "None");
        result.put("subtype", "None");
        result.put("tags", "csv");
        result.put("type", "None");
        result.put("userId", "None");
        return result;
    }

    public static AdminSearchContentBuilder builder() {
        return new AdminSearchContentBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getIshidden() {
        return this.ishidden;
    }

    public String getIsofficial() {
        return this.isofficial;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public String getOrderby() {
        return this.orderby;
    }

    public String getSortby() {
        return this.sortby;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getType() {
        return this.type;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setIshidden(String ishidden) {
        this.ishidden = ishidden;
    }

    public void setIsofficial(String isofficial) {
        this.isofficial = isofficial;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public void setOrderby(String orderby) {
        this.orderby = orderby;
    }

    public void setSortby(String sortby) {
        this.sortby = sortby;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public static class AdminSearchContentBuilder {
        private String customBasePath;
        private String namespace;
        private String creator;
        private String ishidden;
        private String isofficial;
        private Integer limit;
        private String name;
        private Integer offset;
        private String orderby;
        private String sortby;
        private String subtype;
        private List<String> tags;
        private String type;
        private String userId;

        AdminSearchContentBuilder() {
        }

        public AdminSearchContentBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminSearchContentBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminSearchContentBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AdminSearchContentBuilder ishidden(String ishidden) {
            this.ishidden = ishidden;
            return this;
        }

        public AdminSearchContentBuilder isofficial(String isofficial) {
            this.isofficial = isofficial;
            return this;
        }

        public AdminSearchContentBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminSearchContentBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AdminSearchContentBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminSearchContentBuilder orderby(String orderby) {
            this.orderby = orderby;
            return this;
        }

        public AdminSearchContentBuilder sortby(String sortby) {
            this.sortby = sortby;
            return this;
        }

        public AdminSearchContentBuilder subtype(String subtype) {
            this.subtype = subtype;
            return this;
        }

        public AdminSearchContentBuilder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public AdminSearchContentBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AdminSearchContentBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminSearchContent build() {
            return new AdminSearchContent(this.customBasePath, this.namespace, this.creator, this.ishidden, this.isofficial, this.limit, this.name, this.offset, this.orderby, this.sortby, this.subtype, this.tags, this.type, this.userId);
        }

        public String toString() {
            return "AdminSearchContent.AdminSearchContentBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", creator=" + this.creator + ", ishidden=" + this.ishidden + ", isofficial=" + this.isofficial + ", limit=" + this.limit + ", name=" + this.name + ", offset=" + this.offset + ", orderby=" + this.orderby + ", sortby=" + this.sortby + ", subtype=" + this.subtype + ", tags=" + this.tags + ", type=" + this.type + ", userId=" + this.userId + ")";
        }
    }
}

