/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_channel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsChannelResponse;
import net.accelbyte.sdk.api.ugc.models.ModelsUpdateChannelRequest;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class SingleAdminUpdateChannel
extends Operation {
    private String path = "/ugc/v1/admin/namespaces/{namespace}/channels/{channelId}";
    private String method = "PUT";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String channelId;
    private String namespace;
    private ModelsUpdateChannelRequest body;

    @Deprecated
    public SingleAdminUpdateChannel(String customBasePath, String channelId, String namespace, ModelsUpdateChannelRequest body) {
        this.channelId = channelId;
        this.namespace = namespace;
        this.body = body;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.channelId != null) {
            pathParams.put("channelId", this.channelId);
        }
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        return pathParams;
    }

    public ModelsUpdateChannelRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.channelId == null) {
            return false;
        }
        return this.namespace != null;
    }

    public ModelsChannelResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsChannelResponse().createFromJson(json);
    }

    public static SingleAdminUpdateChannelBuilder builder() {
        return new SingleAdminUpdateChannelBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ModelsUpdateChannelRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setBody(ModelsUpdateChannelRequest body) {
        this.body = body;
    }

    public static class SingleAdminUpdateChannelBuilder {
        private String customBasePath;
        private String channelId;
        private String namespace;
        private ModelsUpdateChannelRequest body;

        SingleAdminUpdateChannelBuilder() {
        }

        public SingleAdminUpdateChannelBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public SingleAdminUpdateChannelBuilder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public SingleAdminUpdateChannelBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SingleAdminUpdateChannelBuilder body(ModelsUpdateChannelRequest body) {
            this.body = body;
            return this;
        }

        public SingleAdminUpdateChannel build() {
            return new SingleAdminUpdateChannel(this.customBasePath, this.channelId, this.namespace, this.body);
        }

        public String toString() {
            return "SingleAdminUpdateChannel.SingleAdminUpdateChannelBuilder(customBasePath=" + this.customBasePath + ", channelId=" + this.channelId + ", namespace=" + this.namespace + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

