/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.ugc.operations.admin_channel;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.ugc.models.ModelsPaginatedGetChannelResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class AdminGetChannel
extends Operation {
    private String path = "/ugc/v1/admin/namespaces/{namespace}/users/{userId}/channels";
    private String method = "GET";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String userId;
    private Integer limit;
    private String name;
    private Integer offset;

    @Deprecated
    public AdminGetChannel(String customBasePath, String namespace, String userId, Integer limit, String name, Integer offset) {
        this.namespace = namespace;
        this.userId = userId;
        this.limit = limit;
        this.name = name;
        this.offset = offset;
        this.customBasePath = customBasePath != null ? customBasePath : "";
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.userId != null) {
            pathParams.put("userId", this.userId);
        }
        return pathParams;
    }

    public Map<String, List<String>> getQueryParams() {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
        queryParams.put("limit", this.limit == null ? null : Arrays.asList(String.valueOf(this.limit)));
        queryParams.put("name", this.name == null ? null : Arrays.asList(this.name));
        queryParams.put("offset", this.offset == null ? null : Arrays.asList(String.valueOf(this.offset)));
        return queryParams;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.userId != null;
    }

    public ModelsPaginatedGetChannelResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsPaginatedGetChannelResponse().createFromJson(json);
    }

    protected Map<String, String> getCollectionFormatMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("limit", "None");
        result.put("name", "None");
        result.put("offset", "None");
        return result;
    }

    public static AdminGetChannelBuilder builder() {
        return new AdminGetChannelBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getName() {
        return this.name;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public static class AdminGetChannelBuilder {
        private String customBasePath;
        private String namespace;
        private String userId;
        private Integer limit;
        private String name;
        private Integer offset;

        AdminGetChannelBuilder() {
        }

        public AdminGetChannelBuilder customBasePath(String customBasePath) {
            this.customBasePath = customBasePath;
            return this;
        }

        public AdminGetChannelBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public AdminGetChannelBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public AdminGetChannelBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public AdminGetChannelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AdminGetChannelBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public AdminGetChannel build() {
            return new AdminGetChannel(this.customBasePath, this.namespace, this.userId, this.limit, this.name, this.offset);
        }

        public String toString() {
            return "AdminGetChannel.AdminGetChannelBuilder(customBasePath=" + this.customBasePath + ", namespace=" + this.namespace + ", userId=" + this.userId + ", limit=" + this.limit + ", name=" + this.name + ", offset=" + this.offset + ")";
        }
    }
}

