/*
 * Decompiled with CFR 0.152.
 */
package net.accelbyte.sdk.api.sessionbrowser.operations.session;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.accelbyte.sdk.api.sessionbrowser.models.ModelsJoinGameSessionRequest;
import net.accelbyte.sdk.api.sessionbrowser.models.ModelsSessionResponse;
import net.accelbyte.sdk.core.HttpResponseException;
import net.accelbyte.sdk.core.Operation;
import net.accelbyte.sdk.core.util.Helper;

public class JoinSession
extends Operation {
    private String path = "/sessionbrowser/namespaces/{namespace}/gamesession/{sessionID}/join";
    private String method = "POST";
    private List<String> consumes = Arrays.asList("application/json");
    private List<String> produces = Arrays.asList("application/json");
    private String locationQuery = null;
    private String namespace;
    private String sessionID;
    private ModelsJoinGameSessionRequest body;

    @Deprecated
    public JoinSession(String namespace, String sessionID, ModelsJoinGameSessionRequest body) {
        this.namespace = namespace;
        this.sessionID = sessionID;
        this.body = body;
        this.securities.add("Bearer");
    }

    public Map<String, String> getPathParams() {
        HashMap<String, String> pathParams = new HashMap<String, String>();
        if (this.namespace != null) {
            pathParams.put("namespace", this.namespace);
        }
        if (this.sessionID != null) {
            pathParams.put("sessionID", this.sessionID);
        }
        return pathParams;
    }

    public ModelsJoinGameSessionRequest getBodyParams() {
        return this.body;
    }

    public boolean isValid() {
        if (this.namespace == null) {
            return false;
        }
        return this.sessionID != null;
    }

    public ModelsSessionResponse parseResponse(int code, String contentType, InputStream payload) throws HttpResponseException, IOException {
        if (code != 200) {
            String json = Helper.convertInputStreamToString((InputStream)payload);
            throw new HttpResponseException(code, json);
        }
        String json = Helper.convertInputStreamToString((InputStream)payload);
        return new ModelsSessionResponse().createFromJson(json);
    }

    public static JoinSessionBuilder builder() {
        return new JoinSessionBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public String getLocationQuery() {
        return this.locationQuery;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public ModelsJoinGameSessionRequest getBody() {
        return this.body;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setConsumes(List<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(List<String> produces) {
        this.produces = produces;
    }

    public void setLocationQuery(String locationQuery) {
        this.locationQuery = locationQuery;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setBody(ModelsJoinGameSessionRequest body) {
        this.body = body;
    }

    public static class JoinSessionBuilder {
        private String namespace;
        private String sessionID;
        private ModelsJoinGameSessionRequest body;

        JoinSessionBuilder() {
        }

        public JoinSessionBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public JoinSessionBuilder sessionID(String sessionID) {
            this.sessionID = sessionID;
            return this;
        }

        public JoinSessionBuilder body(ModelsJoinGameSessionRequest body) {
            this.body = body;
            return this;
        }

        public JoinSession build() {
            return new JoinSession(this.namespace, this.sessionID, this.body);
        }

        public String toString() {
            return "JoinSession.JoinSessionBuilder(namespace=" + this.namespace + ", sessionID=" + this.sessionID + ", body=" + (Object)((Object)this.body) + ")";
        }
    }
}

